/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;
import jbot.Inherit;
import jbot.Rabbit2;
import jbot.tracer.Ray;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import jbot.tracer.Wave;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.Vector2;
import robocode.Rules;

public class SegmentedAngleTechnique
extends TracerTechnique {
    protected double mRecentMaxKDAngle = 0.0;
    protected double mRecentMaxRDAngle = 0.0;
    Vector<Integer> mRecentFactorIndices = new Vector();
    public static final double FACTOR_GAIN_RATE = 1.0;
    public static final double MIN_FACTOR = 0.0;
    public static final double MAX_FACTOR = 1.0;
    public final boolean ORBIAVGV_ABS;
    public final int ORBIAVGV_SEGMENTS;
    public final int ORBITVEL_SEGMENTS;
    public final int VERTIVEL_SEGMENTS;
    public final int TIMEDIST_SEGMENTS;
    public static final int FACTOR_SEGMENTS = 11;
    public static final double FACTOR_STEP = 0.1;
    float[][][][][] mFactorsCounter = null;
    private static boolean mOrbiAvgVelAbs = false;
    private static int mOrbiAvgVelSegments = 5;
    private static int mOrbiVelSegments = 5;
    private static int mVertiVelSegments = 5;
    private static int mTimeDistSegments = 12;
    private double mEstimatedFactorSum = 0.0;
    private double mEstimatedFactorCount = 0.0;

    public Inherit.Container collectData() {
        TechniqueContainer o = new TechniqueContainer(this);
        o.mSavedFactorDimensions = new Vector();
        o.mSavedFactorDimensions.add(this.ORBIAVGV_SEGMENTS);
        o.mSavedFactorDimensions.add(this.ORBITVEL_SEGMENTS);
        o.mSavedFactorDimensions.add(this.VERTIVEL_SEGMENTS);
        o.mSavedFactorDimensions.add(this.TIMEDIST_SEGMENTS);
        o.mSavedFactorDimensions.add(11);
        o.mSavedFactor = (float[][][][][])this.mFactorsCounter.clone();
        return o;
    }

    public boolean extractData(Inherit.Container io) {
        TechniqueContainer o = (TechniqueContainer)io;
        if (o.mSavedFactorDimensions.get(0) == this.ORBIAVGV_SEGMENTS && o.mSavedFactorDimensions.get(1) == this.ORBITVEL_SEGMENTS && o.mSavedFactorDimensions.get(2) == this.VERTIVEL_SEGMENTS && o.mSavedFactorDimensions.get(3) == this.TIMEDIST_SEGMENTS && o.mSavedFactorDimensions.get(4) == 11) {
            this.mFactorsCounter = (float[][][][][])o.mSavedFactor.clone();
            return true;
        }
        return false;
    }

    public double getRecentFactorSum() {
        return this.mEstimatedFactorSum;
    }

    public double getRecentFactorCount() {
        return this.mEstimatedFactorCount;
    }

    public float[] getRecentFactorCountsVector() {
        return (float[])this.mFactorsCounter[this.mRecentFactorIndices.get(0)][this.mRecentFactorIndices.get(1)][this.mRecentFactorIndices.get(2)][this.mRecentFactorIndices.get(3)].clone();
    }

    public static void presetOrbiAvgVelAbs(boolean abs) {
        mOrbiAvgVelAbs = abs;
    }

    public static void presetOrbiAvgVelSegments(int segments) {
        mOrbiAvgVelSegments = segments;
    }

    public static void presetOrbiVelSegments(int segments) {
        mOrbiVelSegments = segments;
    }

    public static void presetVertiVelSegments(int segments) {
        mVertiVelSegments = segments;
    }

    public static void presetTimeDistSegments(int segments) {
        mTimeDistSegments = segments;
    }

    public SegmentedAngleTechnique(String techName, Rabbit2 bot, Target self, Target target, double initialEfficient, double learnFactor) {
        super(techName, bot, self, target, initialEfficient, learnFactor);
        this.mColor = Color.RED;
        this.ORBIAVGV_ABS = mOrbiAvgVelAbs;
        this.ORBIAVGV_SEGMENTS = mOrbiAvgVelSegments;
        this.ORBITVEL_SEGMENTS = mOrbiVelSegments;
        this.VERTIVEL_SEGMENTS = mVertiVelSegments;
        this.TIMEDIST_SEGMENTS = mTimeDistSegments;
        TechniqueContainer o = (TechniqueContainer)this.mBot.getInherit().getContainerBy(this.getName());
        if (o == null || !this.extractData(o)) {
            this.mFactorsCounter = new float[this.ORBIAVGV_SEGMENTS][this.ORBITVEL_SEGMENTS][this.VERTIVEL_SEGMENTS][this.TIMEDIST_SEGMENTS][11];
            int od = 0;
            while (od < this.ORBIAVGV_SEGMENTS) {
                int ov = 0;
                while (ov < this.ORBITVEL_SEGMENTS) {
                    int vv = 0;
                    while (vv < this.VERTIVEL_SEGMENTS) {
                        int td = 0;
                        while (td < this.TIMEDIST_SEGMENTS) {
                            int f = 0;
                            while (f < 11) {
                                if (f == 5) {
                                    this.mFactorsCounter[od][ov][vv][td][f] = 1.0E-4f;
                                }
                                ++f;
                            }
                            ++td;
                        }
                        ++vv;
                    }
                    ++ov;
                }
                ++od;
            }
        }
    }

    public double getHitProbability(double distance) {
        double p = super.getHitProbability(distance);
        if (this.mEstimatedFactorSum > 0.2) {
            p /= 3.0;
            p += this.mEstimatedFactorCount / this.mEstimatedFactorSum;
            p = this.normalProbability(p);
        }
        return p;
    }

    public static double normalFactor(double factor) {
        if (factor < 0.0) {
            factor = 0.0;
        } else if (factor > 1.0) {
            factor = 1.0;
        }
        return factor;
    }

    public static int orbitalAvgVelocityToIndex(double orbiAvgVel, int segments) {
        return (int)Math.round((orbiAvgVel + 8.0) * ((double)(segments - 1) / 16.0));
    }

    public static int orbitalVelocityToIndex(double orbiVel, int segments) {
        return (int)Math.round((orbiVel + 8.0) * ((double)(segments - 1) / 16.0));
    }

    public static int verticalVelocityToIndex(double v, int segments) {
        return (int)Math.round((v + 8.0) * ((double)(segments - 1) / 16.0));
    }

    public static int timeDistanceToIndex(double timeDist, int segments) {
        int o = (int)Math.round((timeDist - 9.5) / 3.0);
        if (o < 0) {
            o = 0;
        } else if (o >= segments) {
            o = segments - 1;
        }
        return o;
    }

    public static int factorToIndex(double factor) {
        int factorIndex = (int)Math.round(factor *= 10.0);
        if (factorIndex < 0) {
            factorIndex = 0;
        } else if (factorIndex >= 11) {
            factorIndex = 10;
        }
        return factorIndex;
    }

    public static double indexToFactor(int index) {
        return 0.1 * (double)index;
    }

    public static double factorToHeading(double factor, double maxFEAngle, double maxBEAngle) {
        Vector2 v1 = new Vector2(maxFEAngle);
        Vector2 v2 = new Vector2(maxBEAngle);
        double f = factor;
        v1.multiply(f);
        v2.multiply(1.0 - f);
        return v1.add(v2).getAngle();
    }

    public static double headingToFactor(double heading, double maxFEAngle, double maxBEAngle) {
        Vector2 v1 = new Vector2(maxFEAngle);
        Vector2 v2 = new Vector2(maxBEAngle);
        Vector2 va = new Vector2(heading);
        va.sub(v2);
        v1.sub(v2);
        return SegmentedAngleTechnique.normalFactor(va.getLength() / v1.getLength());
    }

    double estimateBestFactor(int orbiDispIndex, int orbiVelIndex, int vertiVelIndex, int timeDistIndex) {
        float[] factors = this.mFactorsCounter[orbiDispIndex][orbiVelIndex][vertiVelIndex][timeDistIndex];
        int bestCountFactorIndex = 0;
        double sum = 0.0;
        float[] fArray = factors;
        int n = factors.length;
        int n2 = 0;
        while (n2 < n) {
            float c = fArray[n2];
            sum += (double)c;
            ++n2;
        }
        this.mEstimatedFactorSum = sum;
        double a = this.mBot.getRandom().nextDouble() * sum;
        double passed = 0.0;
        int j = 0;
        float[] fArray2 = factors;
        int n3 = factors.length;
        int n4 = 0;
        while (n4 < n3) {
            float c = fArray2[n4];
            if (a <= (passed += (double)c)) {
                bestCountFactorIndex = j;
                break;
            }
            ++j;
            ++n4;
        }
        this.mEstimatedFactorCount = factors[bestCountFactorIndex];
        return SegmentedAngleTechnique.indexToFactor(bestCountFactorIndex);
    }

    public void addEstimatedRay(Wave w) {
        Vector2 direction = new Vector2(this.getShotAngleFor(w.getShotTime(), w.getShotPos(), w.getPower()));
        w.addRay(new RayEx(this, direction, this.getHitProbability(w.getDistToTarget()), this.mRecentMaxKDAngle, this.mRecentMaxRDAngle, this.mRecentFactorIndices));
    }

    public double getShotAngleFor(long shootTime, Vector2 shootPos, double shootPower) {
        double vertiVel;
        double orbiVel;
        Target.Data target = this.mTarget.getHistoryAt(shootTime);
        Vector2 smoothVel = target.getVelocity();
        if (this.mTarget.getHistoryEntriesBefore(shootTime) >= 4) {
            int i = 1;
            while (i < 4) {
                smoothVel.add(this.mTarget.getHistoryAt(shootTime - (long)i).getVelocity());
                ++i;
            }
            smoothVel.multiply(0.25);
        }
        Vector2 distance = target.getPosition().sub(shootPos);
        if (smoothVel.getLength() > 0.05) {
            double angle = distance.getAngleTo(smoothVel);
            Vector2 velocity = Vector2.UP.clone().rotate(angle);
            velocity.multiply(8.0);
            orbiVel = Math.abs(velocity.getX()) * Math.signum(target.getSpeed());
            vertiVel = velocity.getY();
        } else {
            orbiVel = 0.0;
            vertiVel = 0.0;
        }
        double timeDist = Math.ceil(distance.getLength() / Rules.getBulletSpeed((double)shootPower));
        int iterations = (int)timeDist;
        int historyEntries = this.mTarget.getHistoryEntriesBefore(shootTime);
        if (iterations > historyEntries) {
            iterations = historyEntries;
        }
        Vector2 avgVel = smoothVel.clone().multiply(4.0);
        int i = 4;
        while (i < iterations) {
            avgVel.add(this.mTarget.getHistoryAt(shootTime - (long)i).getVelocity());
            ++i;
        }
        avgVel.multiply(1.0 / (double)iterations);
        double orbiDisp = 0.0;
        if (avgVel.getLength() > 0.05) {
            double angle = distance.getAngleTo(avgVel);
            Vector2 velocity = Vector2.UP.clone().rotate(angle);
            velocity.multiply(8.0);
            orbiDisp = Math.abs(velocity.getX()) * Math.signum(target.getSpeed());
        } else {
            orbiDisp = 0.0;
        }
        if (this.ORBIAVGV_ABS) {
            orbiDisp = Math.abs(orbiDisp);
        }
        int orbiDispIndex = SegmentedAngleTechnique.orbitalAvgVelocityToIndex(orbiDisp, this.ORBIAVGV_SEGMENTS);
        int orbiVelIndex = SegmentedAngleTechnique.orbitalVelocityToIndex(orbiVel, this.ORBITVEL_SEGMENTS);
        int vertiVelIndex = SegmentedAngleTechnique.verticalVelocityToIndex(vertiVel, this.VERTIVEL_SEGMENTS);
        int timeDistIndex = SegmentedAngleTechnique.timeDistanceToIndex(timeDist, this.TIMEDIST_SEGMENTS);
        double factor = this.estimateBestFactor(orbiDispIndex, orbiVelIndex, vertiVelIndex, timeDistIndex);
        double factorCount = this.mEstimatedFactorCount;
        if (factorCount < 0.5) {
            double sum = 0.0;
            double avgFactor = 0.0;
            int i2 = 0;
            while (i2 < this.TIMEDIST_SEGMENTS) {
                double f = i2 != timeDistIndex ? this.estimateBestFactor(orbiDispIndex, orbiVelIndex, vertiVelIndex, i2) : factor;
                double ratio = (double)Math.abs(timeDistIndex - i2) / (double)this.TIMEDIST_SEGMENTS * this.mEstimatedFactorCount;
                avgFactor += f * ratio;
                sum += ratio;
                ++i2;
            }
            factor = avgFactor /= sum;
        }
        double maxFEAngle = Tracer.getMaxKeepDirAngle(shootPos.clone(), this.mTarget, shootPower);
        double maxBEAngle = Tracer.getMaxReverseDirAngle(shootPos.clone(), this.mTarget, shootPower);
        double shootAngle = SegmentedAngleTechnique.factorToHeading(factor, maxFEAngle, maxBEAngle);
        this.mRecentFactorIndices.clear();
        this.mRecentFactorIndices.add(orbiDispIndex);
        this.mRecentFactorIndices.add(orbiVelIndex);
        this.mRecentFactorIndices.add(vertiVelIndex);
        this.mRecentFactorIndices.add(timeDistIndex);
        this.mRecentMaxKDAngle = maxFEAngle;
        this.mRecentMaxRDAngle = maxBEAngle;
        return shootAngle;
    }

    public void selfLearn(Wave wave, Ray ray, double aimError) {
        double gain = 1.0;
        if (!wave.isRealBullet()) {
            gain *= 0.001;
        }
        if (wave.getTraveledDistance() < 100.0) {
            gain = Math.pow(wave.getTraveledDistance() / 100.0, 2.0) * gain;
        }
        gain *= this.getEfficient();
        RayEx rex = (RayEx)ray;
        double angle = rex.getDirection().rotate(-aimError).getAngle();
        double factor = SegmentedAngleTechnique.headingToFactor(angle, rex.mMaxKeepDirAngle, rex.mMaxReverseDirAngle);
        float[] fArray = this.mFactorsCounter[rex.mFactorIndices.get(0)][rex.mFactorIndices.get(1)][rex.mFactorIndices.get(2)][rex.mFactorIndices.get(3)];
        int n = SegmentedAngleTechnique.factorToIndex(factor);
        fArray[n] = (float)((double)fArray[n] + gain);
    }

    public String prepareLogString() {
        return "";
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.green);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RayEx
    extends Ray {
        double mMaxKeepDirAngle;
        double mMaxReverseDirAngle;
        Vector<Integer> mFactorIndices;

        public RayEx(TracerTechnique technique, Vector2 direction, double probability, double maxForwardAngle, double maxBackwardAngle, Vector<Integer> factorIndices) {
            super(technique, direction, probability);
            this.mMaxKeepDirAngle = maxForwardAngle;
            this.mMaxReverseDirAngle = maxBackwardAngle;
            this.mFactorIndices = factorIndices;
        }
    }

    protected static class TechniqueContainer
    extends Inherit.Container {
        private static final long serialVersionUID = 4705098229254903104L;
        Vector<Integer> mSavedFactorDimensions;
        float[][][][][] mSavedFactor;

        protected TechniqueContainer(TracerTechnique t) {
            super(t.getName());
        }
    }
}

