/*
 * Decompiled with CFR 0.152.
 */
package dk;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Histogram {
    protected static boolean terse = true;
    private Bucket[] buckets_;
    private Map bucketMap;
    private int totalSuccesses = 0;
    private int uses = 0;
    private String name;

    public Histogram(int numberOfBuckets) {
        this.buckets_ = new Bucket[numberOfBuckets];
        int i = 0;
        while (i < numberOfBuckets) {
            this.buckets_[i] = new Bucket(i);
            ++i;
        }
    }

    public Histogram(List bucketObjects) {
        int numberOfBuckets = bucketObjects.size();
        this.buckets_ = new Bucket[numberOfBuckets];
        this.bucketMap = new HashMap(numberOfBuckets);
        int i = 0;
        while (i < numberOfBuckets) {
            Object o = bucketObjects.get(i);
            this.buckets_[i] = new Bucket(o, i);
            this.bucketMap.put(o, this.buckets_[i]);
            ++i;
        }
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    protected void recordUse() {
        ++this.uses;
    }

    public void recordFailure(int index) {
        this.buckets_[index].recordFailure();
    }

    public void recordSuccess(int index) {
        this.buckets_[index].recordSuccess();
        ++this.totalSuccesses;
    }

    public void recordFailure(Object key) {
        Bucket bucket = (Bucket)this.bucketMap.get(key);
        if (bucket != null) {
            bucket.recordFailure();
        }
    }

    public void recordSuccess(Object key) {
        Bucket bucket = (Bucket)this.bucketMap.get(key);
        if (bucket != null) {
            bucket.recordSuccess();
            ++this.totalSuccesses;
        }
    }

    public int getBestIndex() {
        int bestIndex = 0;
        double bestRate = this.buckets_[0].getSuccessRate() - this.buckets_[0].getConfidence();
        int i = 1;
        while (i < this.buckets_.length) {
            double rate = this.buckets_[i].getSuccessRate() - this.buckets_[i].getConfidence();
            if (rate > bestRate) {
                bestRate = rate;
                bestIndex = i;
            }
            ++i;
        }
        return bestIndex;
    }

    public Bucket getBestBucket() {
        return this.buckets_[this.getBestIndex()];
    }

    public int getRandomIndex() {
        double scalingFactor = 0.0;
        int i = 0;
        while (i < this.buckets_.length) {
            scalingFactor += this.buckets_[i].getSuccessRate();
            ++i;
        }
        double choice = Math.random() * scalingFactor;
        int i2 = 0;
        while (i2 < this.buckets_.length) {
            if ((choice -= this.buckets_[i2].getSuccessRate()) <= 0.0) {
                return i2;
            }
            ++i2;
        }
        return 0;
    }

    public int getSampleWeightedRandomIndex() {
        int randomIndex = (int)(Math.random() * (double)this.totalSuccesses);
        int seenCount = 0;
        int i = 0;
        while (i < this.buckets_.length) {
            int bucketSuccesses = this.buckets_[i].getSuccesses();
            if (randomIndex <= seenCount + bucketSuccesses) {
                return i;
            }
            seenCount += bucketSuccesses;
            ++i;
        }
        return 0;
    }

    public Object getRandomObject() {
        return this.buckets_[this.getRandomIndex()].getObject();
    }

    public Bucket getRandomBucket() {
        return this.buckets_[this.getRandomIndex()];
    }

    public Iterator getObjectIterator() {
        return this.bucketMap.keySet().iterator();
    }

    public void printStats(PrintStream out) {
        if (terse && this.uses == 0) {
            return;
        }
        if (this.name != null) {
            out.println(this.name);
        }
        int i = 0;
        int c = this.buckets_.length;
        while (i < c) {
            this.buckets_[i].printStats(out);
            ++i;
        }
    }

    public int getTotalSuccesses() {
        return this.totalSuccesses;
    }

    public class Bucket {
        private Object object_;
        private int attempts_ = 0;
        private int success_ = 0;
        private int index_;
        private int uses_;

        private Bucket(Object o, int index) {
            this(index);
            this.object_ = o;
        }

        private Bucket(int index) {
            this.index_ = index;
        }

        public int getAttempts() {
            return this.attempts_;
        }

        public int getSuccesses() {
            return this.success_;
        }

        public double getSuccessRate() {
            if (this.attempts_ > 0) {
                return (double)this.success_ / (double)this.attempts_;
            }
            return 0.0;
        }

        public double getConfidence() {
            if (this.attempts_ > 0) {
                return Math.max(0.0, 1.0 - 0.01 * (double)this.attempts_);
            }
            return 1.0;
        }

        public int getIndex() {
            return this.index_;
        }

        public Object getObject() {
            return this.object_;
        }

        public void recordUse() {
            ++this.uses_;
            Histogram.this.recordUse();
        }

        public String getHistogramName() {
            return this.getName();
        }

        public void printStats(PrintStream out) {
            if (terse && this.uses_ == 0) {
                return;
            }
            out.print("  use " + this.uses_ + "   ");
            if (this.object_ != null) {
                out.print("" + this.index_ + " " + this.getName() + " ");
            } else {
                out.print("" + this.index_ + " ");
            }
            out.println("" + this.getSuccesses() + " / " + this.getAttempts() + " (" + this.getSuccessRate() + ")");
        }

        public String getName() {
            return this.object_.getClass().getName();
        }

        private void recordFailure() {
            ++this.attempts_;
        }

        private void recordSuccess() {
            ++this.success_;
            ++this.attempts_;
        }
    }
}

