/*
 * Decompiled with CFR 0.152.
 */
package dk;

import dk.Point;
import dk.Util;

public class Vector {
    private double angle_;
    private double magnitude_;
    public static final Vector ZERO = new Vector(0.0, 0.0);

    public Vector(double angle, double magnitude) {
        this.angle_ = angle;
        this.magnitude_ = magnitude;
    }

    public double getAngle() {
        return this.angle_;
    }

    public double getMagnitude() {
        return this.magnitude_;
    }

    public Vector add(Vector v) {
        Point p1 = this.add(Point.ZERO);
        Point p2 = v.add(Point.ZERO);
        Point mid = new Point(p1.getX() + p2.getX(), p1.getY() + p2.getY());
        return new Vector(Util.bearing(Point.ZERO, mid), Util.range(Point.ZERO, mid));
    }

    public Point add(Point p) {
        return Util.applyHeading(p, this.getAngle(), this.getMagnitude());
    }

    public String toString() {
        return "(" + Util.toDegrees(this.getAngle()) + ", " + this.getMagnitude() + ")";
    }
}

