/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.utils;

import catcat20.jewel.iolite.knnUtils.Data;
import catcat20.jewel.iolite.knnUtils.WeightedData;
import catcat20.jewel.iolite.move.MeleeSurfing;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import robocode.Bullet;
import robocode.Rules;
import robocode.util.Utils;

public class Wave
extends Point2D.Double {
    public ArrayList<BulletShadow> shadows = new ArrayList();
    private static final double MAX_ESCAPE_FACTOR = 1.1;
    public double fireTime;
    public double bulletPower;
    public double distanceTraveled;
    public double direction;
    public double directAngle;
    public boolean isMeleeWave = false;
    public BotState enemyData;
    public BotState myData;
    public double weight = 1.0;
    public double linear = 0.0;
    public double minDanger;
    public double maxDanger;
    public ArrayList<Bullet> shadowedBullet = new ArrayList();
    public double[] shadowBins = new double[MeleeSurfing.BINS];
    public double[] surfBins = null;
    public double[] moveModelBins = new double[MeleeSurfing.BINS];
    public double[] moveHitModelBins = new double[MeleeSurfing.BINS];
    public double[] moveMeleeModelBins = new double[MeleeSurfing.BINS];
    public double[] moveMeleeHitModelBins = new double[MeleeSurfing.BINS];
    public ArrayList<WeightedData<Data>> nearestNeighbors;
    public ArrayList<Data> dangers;
    public boolean isRealWave = true;
    public boolean rammerWave = false;
    public long ramTimeCount = 0L;
    public double[] nnData;

    public final void shadowBullet(Bullet b, Line2D.Double line, long time) {
        double distB;
        double angle;
        int i;
        double minFactor = Double.POSITIVE_INFINITY;
        double maxFactor = Double.NEGATIVE_INFINITY;
        boolean intersect = false;
        double radius = this.bulletVelocity() * ((double)time - this.fireTime);
        double nextRadius = this.bulletVelocity() * ((double)(time + 1L) - this.fireTime);
        double[] current = IUtils.intersectSegCircle(this.x, this.y, radius, line.x1, line.y1, line.x2, line.y2);
        double[] next = IUtils.intersectSegCircle(this.x, this.y, nextRadius, line.x1, line.y1, line.x2, line.y2);
        for (i = 0; i < current.length; i += 2) {
            angle = Utils.normalRelativeAngle((double)(this.angleTo(current[i], current[i + 1]) - this.directAngle)) / Wave.maxEscapeAngle(this.bulletVelocity());
            if (angle < minFactor) {
                minFactor = angle;
            }
            if (angle > maxFactor) {
                maxFactor = angle;
            }
            intersect = true;
        }
        for (i = 0; i < next.length; i += 2) {
            angle = Utils.normalRelativeAngle((double)(this.angleTo(next[i], next[i + 1]) - this.directAngle)) / Wave.maxEscapeAngle(this.bulletVelocity());
            if (angle < minFactor) {
                minFactor = angle;
            }
            if (angle > maxFactor) {
                maxFactor = angle;
            }
            intersect = true;
        }
        double distA = this.distanceSq(line.x1, line.y1);
        if (distA < nextRadius * nextRadius && distA > radius * radius) {
            double angle2 = Utils.normalRelativeAngle((double)(this.angleTo(line.x1, line.y1) - this.directAngle)) / Wave.maxEscapeAngle(this.bulletVelocity());
            if (angle2 < minFactor) {
                minFactor = angle2;
            }
            if (angle2 > maxFactor) {
                maxFactor = angle2;
            }
            intersect = true;
        }
        if ((distB = this.distanceSq(line.x2, line.y2)) < nextRadius * nextRadius && distB > radius * radius) {
            double angle3 = Utils.normalRelativeAngle((double)(this.angleTo(line.x2, line.y2) - this.directAngle)) / Wave.maxEscapeAngle(this.bulletVelocity());
            if (angle3 < minFactor) {
                minFactor = angle3;
            }
            if (angle3 > maxFactor) {
                maxFactor = angle3;
            }
            intersect = true;
        }
        if (intersect) {
            if (minFactor > 1.1 && maxFactor > 1.1 || minFactor < -1.1 && maxFactor < -1.1) {
                return;
            }
            minFactor = IUtils.limit(-1.1, minFactor, 1.1);
            maxFactor = IUtils.limit(-1.1, maxFactor, 1.1);
            BulletShadow shadow = new BulletShadow(minFactor, maxFactor);
            this.shadows.add(shadow);
        }
    }

    public double angleTo(double x, double y) {
        return IUtils.absoluteBearing(this, new Point2D.Double(x, y));
    }

    public Wave() {
        Arrays.fill(this.shadowBins, 1.0);
    }

    public double bulletVelocity() {
        return Rules.getBulletSpeed((double)this.bulletPower);
    }

    public double firingAngle(double guessFactor) {
        return this.directAngle + guessFactor * this.direction * Wave.maxEscapeAngle(this.bulletVelocity());
    }

    public double guessFactor(Point2D.Double targetLocation) {
        double bearingToTarget = IUtils.absoluteBearing(this, targetLocation);
        return this.guessFactor(bearingToTarget);
    }

    public double guessFactor(double bearingToTarget) {
        return this.guessAngle(bearingToTarget) / Wave.maxEscapeAngle(this.bulletVelocity());
    }

    public double guessAngle(Point2D.Double targetLocation) {
        double bearingToTarget = IUtils.absoluteBearing(this, targetLocation);
        return this.guessAngle(bearingToTarget);
    }

    public double guessAngle(double bearingToTarget) {
        return this.direction * Utils.normalRelativeAngle((double)(bearingToTarget - this.directAngle));
    }

    public double virtuality() {
        long timeSinceLastBullet = (long)(this.fireTime - (double)this.enemyData.lastFireTime);
        long timeToNextBullet = Math.round(Math.ceil(this.enemyData.gunHeat * 10.0));
        if (this.isRealWave) {
            return 0.0;
        }
        if (this.enemyData.lastFireTime > 0L) {
            return (double)Math.min(timeSinceLastBullet, timeToNextBullet) / 8.0;
        }
        return Math.min(1.0, (double)timeToNextBullet / 8.0);
    }

    private static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static class BulletShadow {
        public double minAngle;
        public double maxAngle;

        public BulletShadow(double minAngle, double maxAngle) {
            this.minAngle = minAngle;
            this.maxAngle = maxAngle;
        }

        public boolean overlaps(BulletShadow that) {
            double thatMinAngle = IUtils.normalizeAngle(that.minAngle, this.minAngle);
            double thatMaxAngle = IUtils.normalizeAngle(that.maxAngle, thatMinAngle);
            return this.overlaps(that.minAngle) || this.overlaps(that.maxAngle) || thatMinAngle <= this.minAngle && thatMaxAngle >= this.maxAngle;
        }

        private boolean overlaps(double angle) {
            return this.minAngle <= (angle = IUtils.normalizeAngle(angle, this.minAngle)) && this.maxAngle >= angle;
        }
    }
}

