/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import pa3k.CircleMoving;
import pa3k.Coloring;
import pa3k.GlobalTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.MonteCarlo;
import pa3k.MonteCarloAiming;
import pa3k.MonteCarloGun;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.RandomChangeMoving;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import pa3k.Tracking;
import pa3k.TronAiming;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;

public class Manta
extends AdvancedRobot
implements OpponentCreator {
    protected RobotModule[] modules;
    protected Tracking tracking;
    protected Gun gun;
    protected CircleMoving moving;
    protected MonteCarlo mc;

    public Manta() {
        SelfTracking selfTracking = new SelfTracking(this, 4);
        this.tracking = new GlobalTracking(this, selfTracking, this);
        this.mc = new MonteCarlo(this, this.tracking, selfTracking);
        this.gun = new MonteCarloGun(this, this.tracking, this.mc);
        this.moving = new RandomChangeMoving(this, this.tracking, true);
        this.tracking.setMoving(this.moving);
        this.modules = new RobotModule[6];
        this.modules[0] = new Coloring(this, new Color(255, 120, 120), new Color(255, 255, 120), Color.BLACK, new Color(200, 200, 40), Color.WHITE);
        this.modules[1] = this.moving;
        this.modules[2] = selfTracking;
        this.modules[3] = this.tracking;
        this.modules[4] = this.mc;
        this.modules[5] = this.gun;
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        this.tracking.bulletMissed(bulletMissedEvent);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.tracking.opponentScanned(scannedRobotEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this.tracking.hitByBullet(hitByBulletEvent);
    }

    public void onBuletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.tracking.bulletHitBullet(bulletHitBulletEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        this.tracking.bulletHit(bulletHitEvent);
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.moving.onHitRobot(hitRobotEvent);
        this.gun.hitRobot(this.tracking.getByName(hitRobotEvent.getName()));
        this.tracking.onHitRobot(hitRobotEvent);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this.tracking.robotDeath(robotDeathEvent);
        this.gun.robotDeath(robotDeathEvent);
    }

    public void onPaint(Graphics2D graphics2D) {
        RobotModule.onPaint(this.modules, graphics2D);
        Log.onPaint(graphics2D);
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        Log.log(1, "***********************************");
        Log.log(1, "Turn " + skippedTurnEvent.getTime() + " skipped!");
    }

    public void onDeath(DeathEvent deathEvent) {
        this.mc.dumpData();
    }

    public void run() {
        Log.myNameIs(this.getName());
        Position.setBattleField((Robot)this);
        RobotModule.init(this.modules);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            RobotModule.turn(this.modules);
            this.execute();
        }
    }

    @Override
    public Opponent createOpponent(String string, AdvancedRobot advancedRobot) {
        return new Opponent(string, advancedRobot, new MonteCarloAiming(advancedRobot, string, true, this.mc), new TronAiming(advancedRobot, string, false));
    }
}

