/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.turning;

import benhorner.utility.Rules;
import benhorner.utility.turning.EqualsHint;
import benhorner.utility.turning.Item;
import benhorner.utility.turning.TurnSet;
import benhorner.utility.turning.Variable;
import benhorner.utility.units.Angle;
import benhorner.utility.units.Bearing;
import benhorner.utility.units.Units;
import benhorner.utility.units.Velocity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TurnCoordinator {
    private Item[] priority = new Item[3];

    public TurnCoordinator(Item priority0, Item priority1, Item priority2) {
        this.priority[0] = priority0;
        this.priority[1] = priority1;
        this.priority[2] = priority2;
        HashSet<Item> items = new HashSet<Item>();
        items.add(priority0);
        items.add(priority1);
        items.add(priority2);
        assert (items.size() == 3);
    }

    public TurnSet coordinate(Velocity velocity, Bearing bot_goal, Bearing gun_goal, Bearing rad_goal) {
        Variable bot_turn = new Variable(velocity.getMaxTurn().negate(), velocity.getMaxTurn());
        Variable gun_turn = new Variable(Rules.GUN_TURN_RATE.negate(), Rules.GUN_TURN_RATE);
        Variable rad_turn = new Variable(Rules.RADAR_TURN_RATE.negate(), Rules.RADAR_TURN_RATE);
        List<Variable> effect_rob_turn = Arrays.asList(bot_turn);
        List<Variable> effect_gun_turn = Arrays.asList(bot_turn, gun_turn);
        List<Variable> effect_rad_turn = Arrays.asList(bot_turn, gun_turn, rad_turn);
        Bearing adj_bot_goal = bot_goal;
        double move_direction = 1.0;
        if (bot_goal.toDegrees() > 90.0 || bot_goal.toDegrees() < -90.0) {
            move_direction = -1.0;
            Bearing abs_bot_goal = Units.abs(bot_goal);
            Angle complement = Units.HALF_CIRCLE.subtract(abs_bot_goal.toAngle());
            adj_bot_goal = new Bearing(complement.multiply(-Units.sign(bot_goal)));
        }
        HashMap<Item, EqualsHint> hints = new HashMap<Item, EqualsHint>();
        hints.put(Item.ROBOT, new EqualsHint(effect_rob_turn, adj_bot_goal));
        hints.put(Item.GUN, new EqualsHint(effect_gun_turn, gun_goal));
        hints.put(Item.RADAR, new EqualsHint(effect_rad_turn, rad_goal));
        boolean reduced = true;
        while (reduced) {
            reduced = false;
            int i = 0;
            while (i < this.priority.length) {
                reduced = reduced || ((EqualsHint)hints.get((Object)this.priority[i])).propagate();
                ++i;
            }
        }
        assert (bot_turn.isBound());
        assert (gun_turn.isBound());
        assert (rad_turn.isBound());
        return new TurnSet(bot_turn.getMin(), gun_turn.getMin(), rad_turn.getMin(), move_direction);
    }
}

