/*
 * Decompiled with CFR 0.152.
 */
package ola;

import ola.AvoidXLine;
import ola.AvoidYLine;
import ola.Base;
import ola.CircleTarget;
import ola.Coordinate;
import ola.Direction;
import ola.Driver;
import ola.FullAhead;
import ola.Log;
import ola.MovingObject;
import ola.TrigonomyAimer;
import ola.TurnAndSpeed;

public class Puffin
extends Base {
    @Override
    protected void action() {
        this.move();
        this.hunt();
    }

    private void move() {
        Driver driver = this.getDriver();
        TurnAndSpeed turnAndSpeed = driver.drive();
        Log.value("turnAndSpeed", turnAndSpeed);
        this.setTurnRight(turnAndSpeed.turn());
        this.setMaxVelocity(turnAndSpeed.speed());
        this.setAhead(Double.POSITIVE_INFINITY);
    }

    private Driver getDriver() {
        Driver driver = new Driver();
        Coordinate currentPos = this.getCurrentPos();
        Direction currentHeading = this.getCurrentHeading();
        MovingObject selectTarget = this.selectTarget();
        Coordinate targetPos = null;
        if (selectTarget != null) {
            targetPos = selectTarget.getExpectedPossision(this.getTime());
        }
        driver.addDirective(new AvoidXLine(0.0, new Direction(270.0), currentPos, currentHeading));
        driver.addDirective(new AvoidXLine(this.getBattleFieldWidth(), new Direction(90.0), currentPos, currentHeading));
        driver.addDirective(new AvoidYLine(0.0, new Direction(180.0), currentPos, currentHeading));
        driver.addDirective(new AvoidYLine(this.getBattleFieldHeight(), new Direction(0.0), currentPos, currentHeading));
        driver.addDirective(new CircleTarget(currentPos, currentHeading, targetPos));
        driver.addDirective(new FullAhead());
        return driver;
    }

    private void hunt() {
        if (this.targetSeen()) {
            MovingObject target = this.selectTarget();
            boolean firePower = true;
            Direction aim = new TrigonomyAimer().aim(target, this.getTime(), this.getCurrentMovingObject(), (double)firePower);
            if (this.redyToFire(aim, target)) {
                this.setFire((double)firePower);
                this.logTitle("FIRE");
            } else {
                Direction nextTurnAim = new TrigonomyAimer().aim(target, this.getTime() + 1L, this.getCurrentMovingObject(), (double)firePower);
                this.turnGunTo(nextTurnAim);
            }
        }
    }

    private MovingObject selectTarget() {
        if (this.targets.isEmpty()) {
            return null;
        }
        return (MovingObject)this.targets.values().iterator().next();
    }

    private boolean targetSeen() {
        return !this.targets.isEmpty();
    }

    private MovingObject getCurrentMovingObject() {
        return new MovingObject(this.getTime(), this.getCurrentPos(), this.getCurrentMovment(), "ME");
    }

    private boolean redyToFire(Direction aim, MovingObject target) {
        return this.gunReady() && this.aimingCloseEnough(aim, target);
    }

    private boolean gunReady() {
        return this.getGunHeat() <= 0.0;
    }

    private boolean aimingCloseEnough(Direction aim, MovingObject target) {
        Coordinate targetPos = target.getExpectedPossision(this.getTime());
        double distanceTo = this.getCurrentPos().distance(targetPos);
        double hitSectorRad = this.getWidth() / distanceTo;
        double hitSector = Math.toDegrees(hitSectorRad);
        double tolerance = hitSector / 2.0;
        this.logValue("tolerance", tolerance);
        boolean closeEnough = this.getCurrentGunHeading().isClose(aim, tolerance);
        return closeEnough;
    }
}

