/*
 * Decompiled with CFR 0.152.
 */
package seed.dataset;

import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import seed.Anastasia;
import seed.dataset.DatasetElement;
import seed.dataset.SampleVector;
import seed.predmodel.BattleConfig;

public class BulletData
extends DatasetElement {
    protected double radian;
    protected double distance;
    protected double bulletSpeed;
    protected Point2D.Double myVec;
    protected Point2D.Double enmVec;

    public void setSample(Anastasia robot, ScannedRobotEvent e, int xDim, int yDim) {
        double absBearing = e.getBearingRadians() + robot.getHeadingRadians();
        this.xDim = xDim;
        this.yDim = yDim;
        Point2D.Double myVec = new Point2D.Double(robot.getVelocity() * Math.sin(robot.getHeadingRadians()), robot.getVelocity() * Math.cos(robot.getHeadingRadians()));
        myVec = new Point2D.Double(myVec.getX() * Math.sin(-absBearing) - myVec.getY() * -Math.cos(-absBearing), myVec.getX() * Math.cos(-absBearing) + myVec.getY() * Math.sin(-absBearing));
        Point2D.Double enmVec = new Point2D.Double(e.getVelocity() * Math.sin(e.getHeadingRadians()), e.getVelocity() * Math.cos(e.getHeadingRadians()));
        enmVec = new Point2D.Double(enmVec.getX() * Math.cos(-absBearing) - enmVec.getY() * Math.sin(-absBearing), enmVec.getX() * Math.sin(-absBearing) + enmVec.getY() * Math.cos(-absBearing));
        this.radian = 0.0;
        this.myVec = myVec;
        this.enmVec = enmVec;
        this.bulletSpeed = Rules.getBulletSpeed((double)Anastasia.myBulletPower);
        this.distance = e.getDistance();
        this.normalize(robot, Anastasia.bc);
    }

    public double getRadian() {
        return this.radian;
    }

    public void setRadian(double radian) {
        this.radian = radian;
    }

    public Point2D.Double getMyVec() {
        return this.myVec;
    }

    public void setMyVec(Point2D.Double myVec) {
        this.myVec = myVec;
    }

    public Point2D.Double getEnmVec() {
        return this.enmVec;
    }

    public void setEnmVec(Point2D.Double enmVec) {
        this.enmVec = enmVec;
    }

    private void normalize(Anastasia robot, BattleConfig conf) {
        double x = (this.myVec.getX() + 8.0) / 16.0;
        double y = (this.myVec.getY() + 8.0) / 16.0;
        this.myVec.setLocation(x, y);
        x = (this.enmVec.getX() + 8.0) / 16.0;
        y = (this.enmVec.getY() + 8.0) / 16.0;
        this.enmVec.setLocation(x, y);
        double maxDistance = Point2D.distance(36.0, 36.0, conf.getFieldWidth() - 36.0, conf.getFieldHeight() - 36.0);
        double minBulletSpeed = Rules.getBulletSpeed((double)3.0);
        double minDistance = Point2D.distance(36.0, 0.0, 72.0, 0.0);
        double maxBulletSpeed = Rules.getBulletSpeed((double)0.1);
        this.distance = (this.distance - minDistance) / (maxDistance - minDistance);
        this.bulletSpeed = (this.bulletSpeed - minBulletSpeed) / (maxBulletSpeed - minBulletSpeed);
    }

    @Override
    public SampleVector getVector() {
        SampleVector vector = new SampleVector(this.xDim, this.yDim);
        vector.y[0] = this.radian;
        vector.x[0] = this.distance;
        vector.x[1] = this.bulletSpeed;
        vector.x[2] = this.myVec.getX();
        vector.x[3] = this.myVec.getY();
        vector.x[4] = this.enmVec.getX();
        vector.x[5] = this.enmVec.getY();
        return vector;
    }
}

