/*
 * Decompiled with CFR 0.152.
 */
package mb.radar;

import mb.MBRobot;
import mb.radar.Radar;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class NarrowLockRadar
extends Radar {
    protected double lastScanTime = 0.0;
    private int slips = 0;
    private static double factor = 1.9;

    public NarrowLockRadar(MBRobot me) {
        super(me);
    }

    @Override
    public void run() {
        if ((double)this.getTime() - this.lastScanTime > 3.0) {
            ++this.slips;
            this.getRobot().turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
        if (this.slips > 2) {
            this.slips = 0;
            factor += 0.1;
        }
        super.run();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        this.lastScanTime = this.getTime();
        double radarTurn = this.getHeadingRadians() + event.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(factor * Utils.normalRelativeAngle((double)radarTurn));
        super.onScannedRobot(event);
    }
}

