/*
 * Decompiled with CFR 0.152.
 */
package mb.utils;

import mb.core.Coordinates;
import mb.utils.CoordinatesUtils;

public class MathUtils {
    public static Coordinates getEnemyCoordinates(Coordinates start, double myHeading, double enemyBearing, double distance) {
        double radians = Math.toRadians((myHeading + enemyBearing) % 360.0);
        return MathUtils.getCoordinatesByRadians(start, radians, distance);
    }

    public static Coordinates getCoordinates(Coordinates start, double angle, double distance) {
        double radians = Math.toRadians(angle);
        return MathUtils.getCoordinatesByRadians(start, radians, distance);
    }

    public static Coordinates getCoordinatesByRadians(Coordinates start, double radians, double distance) {
        double x = start.getX() + Math.sin(radians) * distance;
        double y = start.getY() + Math.cos(radians) * distance;
        return new Coordinates(x, y);
    }

    public static double getDistance(Coordinates point1, Coordinates point2) {
        return CoordinatesUtils.getDistance(point1, point2);
    }
}

