/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import pa3k.BulletTracking;

class DataStorage {
    protected static Map<String, AbstractList<BulletTracking>> incomingHits = null;
    protected static Map<String, AbstractList<BulletTracking>> incomingMisses = null;
    protected static Map<String, AbstractList<BulletTracking>> incomingPossibleHits = null;
    protected static Map<String, AbstractList<BulletTracking>> outgoingHits = null;
    protected static Map<String, AbstractList<BulletTracking>> outgoingMisses = null;
    protected static Map<String, AbstractList<BulletTracking>> outgoingPossibleHits = null;

    DataStorage() {
    }

    private static AbstractList<BulletTracking> getData(String name, Map<String, AbstractList<BulletTracking>> data) {
        AbstractList<BulletTracking> d = null;
        if (data.containsKey(name)) {
            d = data.get(name);
        } else {
            d = new ArrayList<BulletTracking>(10);
            data.put(name, d);
        }
        return d;
    }

    public static AbstractList<BulletTracking> getIncommingHits(String name) {
        if (incomingHits == null) {
            incomingHits = new HashMap<String, AbstractList<BulletTracking>>();
        }
        return DataStorage.getData(name, incomingHits);
    }

    public static AbstractList<BulletTracking> getIncommingMisses(String name) {
        if (incomingMisses == null) {
            incomingMisses = new HashMap<String, AbstractList<BulletTracking>>();
        }
        return DataStorage.getData(name, incomingMisses);
    }

    public static AbstractList<BulletTracking> getIncommingPossibleHits(String name) {
        if (incomingPossibleHits == null) {
            incomingPossibleHits = new HashMap<String, AbstractList<BulletTracking>>();
        }
        return DataStorage.getData(name, incomingPossibleHits);
    }

    public static AbstractList<BulletTracking> getOutgoingHits(String name) {
        if (outgoingHits == null) {
            outgoingHits = new HashMap<String, AbstractList<BulletTracking>>();
        }
        return DataStorage.getData(name, outgoingHits);
    }

    public static AbstractList<BulletTracking> getOutgoingMisses(String name) {
        if (outgoingMisses == null) {
            outgoingMisses = new HashMap<String, AbstractList<BulletTracking>>();
        }
        return DataStorage.getData(name, outgoingMisses);
    }

    public static AbstractList<BulletTracking> getOutgoingPossibleHits(String name) {
        if (outgoingPossibleHits == null) {
            outgoingPossibleHits = new HashMap<String, AbstractList<BulletTracking>>();
        }
        return DataStorage.getData(name, outgoingPossibleHits);
    }
}

