/*
 * Decompiled with CFR 0.152.
 */
package xander.core;

import java.awt.geom.Rectangle2D;
import java.io.File;
import robocode.Condition;
import xander.core.AbstractXanderRobot;
import xander.core.math.RCMath;
import xander.paint.Paintable;
import xander.paint.Paintables;

public class RobotProxy
implements Paintable {
    AbstractXanderRobot robot;
    private Double battleFieldDiagonal;

    public RobotProxy() {
        Paintables.addPaintable(this);
    }

    void setRobot(AbstractXanderRobot robot) {
        this.robot = robot;
    }

    public String getName() {
        return this.robot.getName();
    }

    public long getTime() {
        return this.robot.getTime();
    }

    public int getRoundNum() {
        return this.robot.getRoundNum();
    }

    public int getOthers() {
        return this.robot.getOthers();
    }

    public double getX() {
        return this.robot.getX();
    }

    public double getY() {
        return this.robot.getY();
    }

    public double getVelocity() {
        return this.robot.getVelocity();
    }

    public double getHeadingDegrees() {
        return this.robot.getHeading();
    }

    public double getHeadingRadians() {
        return this.robot.getHeadingRadians();
    }

    public double getBackAsFrontHeadingDegrees() {
        double heading = this.robot.getHeading();
        if (this.robot.getVelocity() < 0.0) {
            heading = RCMath.normalizeDegrees(heading + 180.0);
        }
        return heading;
    }

    public String getActiveRadarName() {
        return this.robot.getActiveRadarName();
    }

    public String getActiveDriveName() {
        return this.robot.getActiveDriveName();
    }

    public String getActiveGunName() {
        return this.robot.getActiveGunName();
    }

    public double getBattleFieldHeight() {
        return this.robot.getBattleFieldHeight();
    }

    public double getBattleFieldWidth() {
        return this.robot.getBattleFieldWidth();
    }

    public Rectangle2D.Double getBattleFieldSize() {
        return this.robot.getBattleFieldSize();
    }

    public double getBattleFieldDiagonal() {
        if (this.battleFieldDiagonal == null) {
            this.battleFieldDiagonal = Math.sqrt(this.robot.getBattleFieldHeight() * this.robot.getBattleFieldHeight() + this.robot.getBattleFieldWidth() * this.robot.getBattleFieldWidth());
        }
        return this.battleFieldDiagonal;
    }

    public double getEnergy() {
        return this.robot.getEnergy();
    }

    public double getGunCoolingRate() {
        return this.robot.getGunCoolingRate();
    }

    public double getGunHeadingDegrees() {
        return this.robot.getGunHeading();
    }

    public double getGunHeadingRadians() {
        return this.robot.getGunHeadingRadians();
    }

    public double getGunHeat() {
        return this.robot.getGunHeat();
    }

    public double getGunTurnRemainingDegrees() {
        return this.robot.getGunTurnRemaining();
    }

    public double getGunTurnRemainingRadians() {
        return this.robot.getGunTurnRemainingRadians();
    }

    public int getNumRounds() {
        return this.robot.getNumRounds();
    }

    public double getRadarHeadingDegrees() {
        return this.robot.getRadarHeading();
    }

    public double getRadarHeadingRadians() {
        return this.robot.getRadarHeadingRadians();
    }

    public double getRadarTurnRemainingDegrees() {
        return this.robot.getRadarTurnRemaining();
    }

    public double getRadarTurnRemainingRadians() {
        return this.robot.getRadarTurnRemainingRadians();
    }

    public double getTurnRemainingDegrees() {
        return this.robot.getTurnRemaining();
    }

    public double getTurnRemainingRadians() {
        return this.robot.getTurnRemainingRadians();
    }

    public File getDataFile(String filename) {
        return this.robot.getDataFile(filename);
    }

    public boolean isAdjustGunForRobotTurn() {
        return this.robot.isAdjustGunForRobotTurn();
    }

    public boolean isAdjustRadarForGunTurn() {
        return this.robot.isAdjustRadarForGunTurn();
    }

    public boolean isAdjustRadarForRobotTurn() {
        return this.robot.isAdjustRadarForRobotTurn();
    }

    public int getSkippedTurns() {
        return this.robot.getSkippedTurns();
    }

    public void addCustomEvent(Condition condition) {
        this.robot.addCustomEvent(condition);
    }

    public void removeCustomEvent(Condition condition) {
        this.robot.removeCustomEvent(condition);
    }

    @Override
    public String getPainterName() {
        return null;
    }
}

