/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.awt.geom.Point2D;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.log.Logger;
import xander.core.math.RCMath;

public class Snapshot {
    private String name;
    private Point2D.Double location;
    private long time;
    private double headingRoboRadians;
    private double velocity;
    private double distance;
    private double energy;

    public Snapshot(String name, double x, double y, double headingRoboRadians, double velocity, double distance, double energy, long time) {
        this.name = name;
        this.location = new Point2D.Double(x, y);
        this.time = time;
        this.headingRoboRadians = headingRoboRadians;
        this.velocity = velocity;
        this.distance = distance;
        this.energy = energy;
    }

    public Snapshot(RobotProxy robot, double distance) {
        this.name = robot.getName();
        this.location = new Point2D.Double(robot.getX(), robot.getY());
        this.time = robot.getTime();
        this.headingRoboRadians = robot.getHeadingRadians();
        this.velocity = robot.getVelocity();
        this.distance = distance;
        this.energy = robot.getEnergy();
    }

    public String getName() {
        return this.name;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public double getX() {
        return this.location.x;
    }

    public double getY() {
        return this.location.y;
    }

    public double[] getXYShift() {
        Snapshot previous = Resources.getSnapshotHistory().getSnapshot(this.name, this.time - 1L, false);
        double[] xyShift = new double[2];
        double magnitude = this.velocity;
        double fheading = this.headingRoboRadians;
        if (previous != null) {
            double deltaV = this.velocity - previous.velocity;
            magnitude = deltaV < 0.0 ? Math.max(this.velocity + deltaV, -8.0) : Math.min(this.velocity + deltaV, 8.0);
            double deltaH = this.headingRoboRadians - previous.headingRoboRadians;
            fheading = RCMath.normalizeRadians(this.headingRoboRadians + deltaH);
        }
        if (magnitude < 0.0) {
            fheading = RCMath.normalizeRadians(this.headingRoboRadians + Math.PI);
            magnitude = -magnitude;
        }
        double conventionalHeading = RCMath.convertRadiansRobocodeToNormal(fheading);
        xyShift[0] = magnitude * Math.cos(conventionalHeading);
        xyShift[1] = magnitude * Math.sin(conventionalHeading);
        return xyShift;
    }

    public double[] getNextXY() {
        double[] nextXY = this.getXYShift();
        nextXY[0] = nextXY[0] + this.location.x;
        nextXY[1] = nextXY[1] + this.location.y;
        return nextXY;
    }

    public Snapshot advance(double oppX, double oppY) {
        double[] nextXY = this.getNextXY();
        double dist = RCMath.getDistanceBetweenPoints(nextXY[0], nextXY[1], oppX, oppY);
        return new Snapshot(this.name, nextXY[0], nextXY[1], this.headingRoboRadians, this.velocity, dist, this.energy, this.time + 1L);
    }

    public Snapshot advance() {
        double[] nextXY = this.getNextXY();
        return new Snapshot(this.name, nextXY[0], nextXY[1], this.headingRoboRadians, this.velocity, this.distance, this.energy, this.time + 1L);
    }

    public long getTime() {
        return this.time;
    }

    public double getHeadingRoboRadians() {
        return this.headingRoboRadians;
    }

    public double getHeadingRoboDegrees() {
        return Math.toDegrees(this.headingRoboRadians);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Snapshot[");
        sb.append("name=").append(this.name);
        sb.append(";location=").append(this.location.toString());
        sb.append(";time=").append(this.time);
        sb.append(";headingRoboRadians=").append(Logger.format(this.headingRoboRadians, 4));
        sb.append(";velocity=").append(Logger.format(this.velocity, 3));
        sb.append(";distance=").append(Logger.format(this.distance));
        sb.append(";energy=").append(Logger.format(this.energy, 3));
        sb.append("]");
        return sb.toString();
    }
}

