/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.enemy;

import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.AimingStrategy;
import dmh.robocode.gunner.enemy.EnemyShootingAtUsStrategy;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EnemySet
implements Iterable<EnemyRobot> {
    private Set<EnemyRobot> enemies = new HashSet<EnemyRobot>();
    private boolean isLearningAllowed = true;

    @Override
    public Iterator<EnemyRobot> iterator() {
        return this.enemies.iterator();
    }

    public EnemyRobot getEnemy(String enemyName) {
        for (EnemyRobot enemy : this.enemies) {
            if (!enemy.getName().equals(enemyName)) continue;
            return enemy;
        }
        EnemyRobot newEnemy = new EnemyRobot(enemyName);
        if (!this.isLearningAllowed) {
            newEnemy.turnOffLearning();
        }
        this.enemies.add(newEnemy);
        return newEnemy;
    }

    public int getNumberOfEnemies() {
        return this.enemies.size();
    }

    public void addEnemyForTesting(EnemyRobot mockEnemy) {
        this.enemies.add(mockEnemy);
    }

    public int getNumberOfLiveEnemiesSeenSince(long sinceTime) {
        int seen = 0;
        for (EnemyRobot enemy : this.enemies) {
            if (enemy.getLatestRadarObservation() == null || !enemy.isAlive() || enemy.getLatestRadarObservation().getTimeSeen() < sinceTime) continue;
            ++seen;
        }
        return seen;
    }

    public void resetForNextRound() {
        for (EnemyRobot enemy : this.enemies) {
            enemy.resetForNextRound();
        }
    }

    public List<AimingStrategy> getAllAimingStrategies() {
        ArrayList<AimingStrategy> result = new ArrayList<AimingStrategy>();
        for (EnemyRobot enemy : this.enemies) {
            for (AimingStrategy aimingStrategy : enemy.getAimingStrategies()) {
                result.add(aimingStrategy);
            }
        }
        return result;
    }

    public List<EnemyShootingAtUsStrategy> getAllShootingAtUsStrategies() {
        ArrayList<EnemyShootingAtUsStrategy> result = new ArrayList<EnemyShootingAtUsStrategy>();
        for (EnemyRobot enemy : this.enemies) {
            for (EnemyShootingAtUsStrategy aimingStrategy : enemy.getShootingAtUsStrategies()) {
                result.add(aimingStrategy);
            }
        }
        return result;
    }

    public void displayDebugEndOfRound() {
        for (EnemyRobot enemy : this.enemies) {
            System.out.println("--------------------");
            System.out.println(enemy.getName());
            System.out.println("--------------------");
            System.out.println(enemy.getStatisticsDebugString());
            for (AimingStrategy aimingStrategy : enemy.getAimingStrategies()) {
                aimingStrategy.debugDisplayStats();
            }
            System.out.println("");
            for (EnemyShootingAtUsStrategy enemyShootingStrategy : enemy.getShootingAtUsStrategies()) {
                System.out.println(enemyShootingStrategy.toString());
            }
        }
    }

    public double getTotalDangerEnergy() {
        double dangerEnergy = 0.0;
        for (EnemyRobot enemy : this.enemies) {
            if (!enemy.isAlive()) continue;
            dangerEnergy += enemy.getDangerEnergy();
        }
        return dangerEnergy;
    }

    public EnemyRobot getClosestLiveEnemy(Location myLocation) {
        double closestDistance = 0.0;
        EnemyRobot closestEnemy = null;
        for (EnemyRobot enemy : this.enemies) {
            double distance;
            RadarObservation observation = enemy.getLatestRadarObservation();
            if (!enemy.isAlive() || observation == null || !((distance = Geometry.getDistanceBetweenLocations(myLocation, observation.getLocation())) < closestDistance) && closestEnemy != null) continue;
            closestDistance = distance;
            closestEnemy = enemy;
        }
        return closestEnemy;
    }

    public double getTotalDangerEnergyWithGravity(double safeDistance, Location myLocation) {
        double dangerEnergy = 0.0;
        for (EnemyRobot enemy : this.enemies) {
            if (!enemy.isAlive()) continue;
            dangerEnergy += enemy.getDangerEnergyWithGravity(safeDistance, myLocation);
        }
        return dangerEnergy;
    }

    public EnemyRobot getBestShootingTarget(Location myLocation) {
        EnemyRobot closestEnemy = this.getClosestLiveEnemy(myLocation);
        if (closestEnemy == null) {
            return null;
        }
        double bestTargetScore = 0.0;
        EnemyRobot bestTarget = null;
        double maxDistance = 1.25 * Geometry.getDistanceBetweenLocations(myLocation, closestEnemy.getLatestRadarObservation().getLocation());
        for (EnemyRobot enemy : this.enemies) {
            double targetScore;
            double distance;
            RadarObservation observation = enemy.getLatestRadarObservation();
            if (!enemy.isAlive() || observation == null || !((distance = Geometry.getDistanceBetweenLocations(myLocation, observation.getLocation())) <= maxDistance) || !((targetScore = enemy.getShootingAccuracy(distance)) > bestTargetScore) && bestTarget != null) continue;
            bestTargetScore = targetScore;
            bestTarget = enemy;
        }
        return bestTarget;
    }

    public double getBestDoubleTargetEnergyWithGravity(double safeDistance, Location myLocation) {
        double best = 0.0;
        double secondBest = 0.0;
        for (EnemyRobot enemy : this.enemies) {
            if (!enemy.isAlive()) continue;
            double targetEnergy = enemy.getTargetEnergyWithGravity(safeDistance, myLocation);
            if (targetEnergy >= best) {
                secondBest = best;
                best = targetEnergy;
                continue;
            }
            secondBest = Math.max(targetEnergy, secondBest);
        }
        return best + secondBest;
    }

    public EnemySet getLiveEnemiesSeenSince(long sinceTime) {
        EnemySet filteredSet = new EnemySet();
        for (EnemyRobot enemy : this.enemies) {
            if (enemy.getLatestRadarObservation() == null || !enemy.isAlive() || enemy.getLatestRadarObservation().getTimeSeen() < sinceTime) continue;
            filteredSet.enemies.add(enemy);
        }
        return filteredSet;
    }

    public void paint(Graphics2D g, Color upToDateColour, Color fairlyRecentColour, int radius, long currentTime) {
        for (EnemyRobot enemy : this.enemies) {
            enemy.drawCircle(g, upToDateColour, fairlyRecentColour, radius, currentTime);
            this.drawAverageLocationBlobs(g, enemy);
        }
    }

    private void drawAverageLocationBlobs(Graphics2D g, EnemyRobot enemy) {
        Location averageLocation = enemy.getAverageLocation();
        Location averageFutureLocation = enemy.getAverageFutureLocation();
        Location behindLocation = enemy.getLocationBehind(200.0);
        if (averageLocation != null) {
            g.setColor(Color.CYAN);
            g.fillOval((int)averageLocation.getX() - 5, (int)averageLocation.getY() - 5, 10, 10);
            g.setColor(Color.YELLOW);
            g.fillOval((int)averageFutureLocation.getX() - 5, (int)averageFutureLocation.getY() - 5, 10, 10);
            g.setColor(Color.WHITE);
            g.fillOval((int)behindLocation.getX() - 5, (int)behindLocation.getY() - 5, 10, 10);
        }
    }

    public void turnOffLearning() {
        this.isLearningAllowed = false;
    }

    public EnemySet getAllLiveEnemiesCloserThan(Location location, double distance) {
        EnemySet filteredSet = new EnemySet();
        for (EnemyRobot enemy : this.enemies) {
            if (enemy.getLatestRadarObservation() == null || !enemy.isAlive() || !(Geometry.getDistanceBetweenLocations(location, enemy.getLatestRadarObservation().getLocation()) < distance)) continue;
            filteredSet.enemies.add(enemy);
        }
        return filteredSet;
    }

    public EnemySet getEnemiesWithAtLeastEnergy(double minimumEnergy) {
        EnemySet filteredSet = new EnemySet();
        for (EnemyRobot enemy : this.enemies) {
            if (enemy.getLatestRadarObservation() == null || !enemy.isAlive() || !(enemy.getLatestRadarObservation().getEnergy() >= minimumEnergy)) continue;
            filteredSet.enemies.add(enemy);
        }
        return filteredSet;
    }
}

