/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.navigator;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.navigator.NavigatorCommand;
import dmh.robocode.simulate.SimulateableRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.Rules;

public class NavigateToLocation
implements NavigatorCommand {
    private static final int maximumSensibleWiggleFactor = 20;
    private static final double wiggleAngle = 3.0;
    private static final double defaultTurningSlowDown = 0.66;
    private Location target;
    private SimulateableRobot myRobot;
    private boolean stopAtTarget = false;
    private int reverseTurnsRemaining = 0;
    private int wiggleFactorTurnsEachWay = 0;
    private int currentWiggleTurn = 0;
    private int currentWiggleDirection = 1;
    private long wiggleExpiry = 0L;
    private double rightTurn = 0.0;
    private double edgeSpace = Math.max(BattleConstants.getInstance().getRobotHeight(), BattleConstants.getInstance().getRobotWidth()) / 2.0;
    private wiggleModeType wiggleState = wiggleModeType.NO_WIGGLE;
    private directionOfTravelType directionOfTravel = directionOfTravelType.FORWARD;
    private int autoReverseTimeout = 10;
    private long remainingTravelTime;
    private double maxVelocity;
    private double sharpTurnVelocity;

    public NavigateToLocation(Location target, SimulateableRobot myRobot) {
        this.initialise(target, myRobot, 8.0, 5.28);
    }

    public NavigateToLocation(Location target, SimulateableRobot myRobot, double maxVelocity) {
        this.initialise(target, myRobot, maxVelocity, maxVelocity * 0.66);
    }

    private void initialise(Location target, SimulateableRobot myRobot, double maxVelocity, double sharpTurnVelocity) {
        this.target = target;
        this.myRobot = myRobot;
        this.maxVelocity = maxVelocity;
        this.sharpTurnVelocity = sharpTurnVelocity;
        this.directionOfTravel = myRobot.getVelocity() >= 0.0 ? directionOfTravelType.FORWARD : directionOfTravelType.BACKWARD;
        this.remainingTravelTime = (long)(Geometry.getDistanceBetweenLocations(myRobot.getLocation(), target) / maxVelocity * 4.0);
        this.executed();
    }

    @Override
    public void reverseDirection() {
        this.directionOfTravel = this.directionOfTravel == directionOfTravelType.FORWARD ? directionOfTravelType.BACKWARD : directionOfTravelType.FORWARD;
        if (this.wiggleState == wiggleModeType.SHARP_TURN) {
            this.wiggleState = wiggleModeType.RECOVER_HEADING;
        }
    }

    public NavigateToLocation mustStopAtTarget() {
        this.stopAtTarget = true;
        return this;
    }

    @Override
    public void setWiggleFactor(int wiggleFactor) {
        this.wiggleFactorTurnsEachWay = Math.min(wiggleFactor, 20);
        if (this.wiggleState == wiggleModeType.NO_WIGGLE) {
            this.wiggleState = wiggleModeType.RECOVER_HEADING;
        }
    }

    @Override
    public int getWiggleFactor() {
        return this.wiggleFactorTurnsEachWay;
    }

    @Override
    public void setWiggleExpiry(long wiggleExpiry) {
        this.wiggleExpiry = wiggleExpiry;
    }

    @Override
    public long getWiggleExpiry() {
        return this.wiggleExpiry;
    }

    @Override
    public boolean isDone() {
        boolean isDone = this.stopAtTarget ? this.remainingTravelTime <= 0L || this.target.isSameAs(this.myRobot.getLocation(), 0.1) : this.remainingTravelTime <= 0L || this.target.isSameAs(this.myRobot.getLocation(), this.myRobot.getVelocity() / 2.0);
        return isDone;
    }

    @Override
    public double getRightTurn() {
        return this.rightTurn;
    }

    @Override
    public double getAhead() {
        if (this.reverseTurnsRemaining > 0) {
            return -24.0;
        }
        if (this.stopAtTarget) {
            return Geometry.getDistanceBetweenLocations(this.myRobot.getLocation(), this.target) * (double)this.velocitySignum();
        }
        return 24.0 * (double)this.velocitySignum();
    }

    @Override
    public double getVelocity() {
        double velocity = this.maxVelocity * (double)this.velocitySignum();
        if (Math.abs(this.getRightTurn()) > Rules.getTurnRate((double)velocity) && this.myRobot.getLocation().getHowCloseToEdgeOfBattlefield() < 50.0) {
            velocity = this.sharpTurnVelocity * (double)this.velocitySignum();
        }
        return velocity;
    }

    private int velocitySignum() {
        return this.directionOfTravel == directionOfTravelType.FORWARD ? 1 : -1;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location newTarget) {
        this.target = newTarget;
    }

    @Override
    public void executed() {
        if (this.reverseTurnsRemaining > 0) {
            --this.reverseTurnsRemaining;
        }
        this.turnOffWiggleIfExpired();
        this.rightTurn = this.getRightTurnWithoutWiggle();
        this.considerReversing();
        --this.remainingTravelTime;
        switch (this.wiggleState) {
            case RECOVER_HEADING: {
                this.controlWiggleRecover();
                break;
            }
            case SHARP_TURN: {
                this.controlWiggleTurn();
                break;
            }
        }
    }

    private void considerReversing() {
        Location likelyPositionSoon;
        --this.autoReverseTimeout;
        if (this.autoReverseTimeout < 0 && Math.abs(this.rightTurn) >= 45.0 && Math.abs(this.rightTurn) <= 135.0) {
            this.reverseDirection();
            this.autoReverseTimeout = 200;
        }
        if (this.myRobot.getLocation() != null && this.autoReverseTimeout < 20 && (likelyPositionSoon = Geometry.getLocationAtBearing(this.myRobot.getLocation(), this.myRobot.getHeading(), 3.0 * this.myRobot.getVelocity())).getHowCloseToEdgeOfBattlefield() <= this.edgeSpace) {
            this.reverseDirection();
            this.autoReverseTimeout = 200;
        }
    }

    private boolean isVeryNearEdge() {
        double howClose = this.myRobot.getLocation().getHowCloseToEdgeOfBattlefield(BattleConstants.getInstance().getBattlefieldWidth(), BattleConstants.getInstance().getBattlefieldHeight());
        return howClose < 50.0;
    }

    private double getRightTurnWithoutWiggle() {
        double requiredHeading = Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), this.target);
        if (this.directionOfTravel == directionOfTravelType.BACKWARD) {
            requiredHeading = this.oppositeDirectionOf(requiredHeading);
        }
        return Geometry.getRelativeBearing(this.myRobot.getHeading(), requiredHeading);
    }

    private double oppositeDirectionOf(double requiredHeading) {
        if (requiredHeading < 180.0) {
            return requiredHeading + 180.0;
        }
        return requiredHeading - 180.0;
    }

    private void controlWiggleTurn() {
        if (this.currentWiggleTurn <= this.wiggleFactorTurnsEachWay && !this.isVeryNearEdge()) {
            this.rightTurn = (double)this.currentWiggleDirection * 3.0;
            ++this.currentWiggleTurn;
        } else {
            this.wiggleState = wiggleModeType.RECOVER_HEADING;
        }
    }

    private void controlWiggleRecover() {
        if (Math.abs(this.rightTurn) < 10.0 && !this.isVeryNearEdge()) {
            this.wiggleState = wiggleModeType.SHARP_TURN;
            this.currentWiggleDirection = -this.currentWiggleDirection;
            double maxWiggles = (Geometry.getDistanceBetweenLocations(this.myRobot.getLocation(), this.target) - 50.0) / 20.0;
            this.currentWiggleTurn = (int)Math.max((double)this.wiggleFactorTurnsEachWay - maxWiggles, 1.0);
        }
    }

    private void turnOffWiggleIfExpired() {
        if (this.myRobot.getTime() >= this.wiggleExpiry) {
            this.wiggleState = wiggleModeType.NO_WIGGLE;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        g.setColor(Color.RED);
        g.drawLine((int)this.myRobot.getLocation().getX(), (int)this.myRobot.getLocation().getY(), (int)this.target.getX(), (int)this.target.getY());
        g.fillOval((int)this.target.getX() - 4, (int)this.target.getY() - 4, 8, 8);
    }

    private static enum directionOfTravelType {
        FORWARD,
        BACKWARD;

    }

    private static enum wiggleModeType {
        NO_WIGGLE,
        RECOVER_HEADING,
        SHARP_TURN;

    }
}

