/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import java.util.Iterator;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.iterator.MatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.operation.MatrixVectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;

public class OoPlaceMatrixByVectorMultiplication
extends MatrixVectorOperation<Vector> {
    @Override
    public Vector apply(DenseMatrix a, DenseVector b) {
        Vector result = b.blankOfLength(a.rows());
        for (int i = 0; i < a.rows(); ++i) {
            double acc = 0.0;
            for (int j = 0; j < a.columns(); ++j) {
                acc += a.get(i, j) * b.get(j);
            }
            result.set(i, acc);
        }
        return result;
    }

    @Override
    public Vector apply(DenseMatrix a, SparseVector b) {
        DenseVector result = DenseVector.zero(a.rows());
        for (int i = 0; i < a.rows(); ++i) {
            double acc = 0.0;
            VectorIterator it = b.nonZeroIterator();
            while (it.hasNext()) {
                double x = (Double)it.next();
                int j = it.index();
                acc += a.get(i, j) * x;
            }
            result.set(i, acc);
        }
        return result;
    }

    @Override
    public Vector apply(RowMajorSparseMatrix a, DenseVector b) {
        DenseVector result = DenseVector.zero(a.rows());
        MatrixIterator it = a.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, result.get(i) + x * b.get(j));
        }
        return result;
    }

    @Override
    public Vector apply(RowMajorSparseMatrix a, SparseVector b) {
        Vector result = b.blankOfLength(a.rows());
        Iterator<Integer> it = a.iteratorOfNonZeroRows();
        while (it.hasNext()) {
            int i = it.next();
            VectorIterator these = a.nonZeroIteratorOfRow(i);
            VectorIterator those = b.nonZeroIterator();
            result.set(i, these.innerProduct(those));
        }
        return result;
    }

    @Override
    public Vector apply(ColumnMajorSparseMatrix a, DenseVector b) {
        DenseVector result = DenseVector.zero(a.rows());
        MatrixIterator it = a.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, result.get(i) + x * b.get(j));
        }
        return result;
    }

    @Override
    public Vector apply(ColumnMajorSparseMatrix a, SparseVector b) {
        Vector result = b.blankOfLength(a.rows());
        VectorIterator it = b.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            VectorIterator these = a.nonZeroIteratorOfColumn(j);
            while (these.hasNext()) {
                double y = (Double)these.next();
                int i = these.index();
                result.updateAt(i, Vectors.asPlusFunction(x * y));
            }
        }
        return result;
    }

    @Override
    public void ensureApplicableTo(Matrix a, Vector b) {
        if (a.columns() != b.length()) {
            throw new IllegalArgumentException("Given vector should have the same length as number of columns in the given matrix: " + b.length() + " does not equal to " + a.columns() + ".");
        }
    }
}

