/*
 * Decompiled with CFR 0.152.
 */
package learn;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import learn.BotToStudy;
import learn.ISmart;
import learn.Net;
import learn.Utilities;
import robocode.util.Utils;

class GunHandler {
    ISmart Is;
    Utilities utils;
    BotToStudy enemy;
    Net myNet;
    List<Integer> topology = new ArrayList<Integer>();
    long learningPass = 0L;
    List<GunHandler> waveGroup = new ArrayList<GunHandler>();
    HashMap<double[], Double> offsetMap = new HashMap();
    List<double[]> neighborGroup = new ArrayList<double[]>();
    double bPower = 3.0;
    Point2D.Double shotPosition;
    double distance;
    double distTravelled;
    double bSpeed;
    double absBearing;
    double maxEscapeAngle;
    double latDirection;
    long shotTime;
    double[] dataPoints = new double[13];
    double[] weights;
    double[] tempWeights;
    double bias = 0.0;
    boolean fireToDeath = false;
    double predictedOffset = 0.0;
    double lastInputOffset = 0.0;
    static double MaxTime = 90.9090909090909;
    double timeSinceShot = 0.0;
    double timeSinceDirectionChange = 0.0;
    double timeSinceHit = 0.0;
    double radiansToWall = 0.0;
    double radiansToBackWall = 0.0;
    GunHandler lastWave;
    boolean isReal = false;
    double currentFiringOffset = 0.0;
    double newOffset = 0.0;

    GunHandler(ISmart type1, Utilities type2, BotToStudy type3) {
        this.Is = type1;
        this.utils = type2;
        this.enemy = type3;
        this.weights = new double[]{0.3333333333333333, 0.125, 0.00125, 0.17453292519943295, 0.5, 0.125};
        this.tempWeights = this.weights;
        this.offsetMap = ISmart.gunOffsetMap;
        this.topology = ISmart.topology;
        this.myNet = ISmart.net;
    }

    GunHandler() {
    }

    double maximizePerformance(double desiredOutput, GunHandler wave) {
        ArrayList<Double> inputVals = new ArrayList<Double>();
        ArrayList<Double> targetVal = new ArrayList<Double>();
        ArrayList<Double> resultVal = new ArrayList<Double>();
        resultVal.add(0.0);
        ++this.learningPass;
        double[] dArray = wave.dataPoints;
        int n = wave.dataPoints.length;
        int n2 = 0;
        while (n2 < n) {
            double iVal = dArray[n2];
            inputVals.add(iVal);
            ++n2;
        }
        int i = 0;
        while (i < this.topology.get(this.topology.size() - 1)) {
            targetVal.add(desiredOutput);
            ++i;
        }
        i = 0;
        while (i < 90) {
            if (inputVals.size() != this.topology.get(0).intValue()) {
                System.out.println("wrong Input Vals");
                break;
            }
            this.myNet.feedForward(inputVals);
            assert (targetVal.size() == this.topology.get(this.topology.size() - 1).intValue());
            this.myNet.backProp(targetVal);
            ++i;
        }
        return (Double)resultVal.get(0);
    }

    double getNearestOffset(double[] data) {
        if (this.offsetMap.containsKey(data)) {
            return this.offsetMap.get(data);
        }
        double offset = 0.0;
        double minimumDist = 100000.0;
        for (double[] o7 : this.offsetMap.keySet()) {
            double tempDist = this.utils.distanceSquared(data, o7);
            if (!(tempDist < minimumDist)) continue;
            minimumDist = tempDist;
            offset = this.offsetMap.get(o7);
        }
        return offset;
    }

    void update() {
        this.timeSinceShot += 1.0;
        this.timeSinceDirectionChange += 1.0;
        this.timeSinceHit += 1.0;
        this.bPower = 2.0;
        if (this.enemy.energy < 4.0) {
            this.bPower = this.enemy.energy / 4.0;
        } else if (this.enemy.energy < 16.0) {
            this.bPower = (this.enemy.energy + 2.0) / 6.0;
        }
        if (this.Is.getEnergy() < 16.0 && this.enemy.energy > 20.0) {
            this.bPower = this.Is.getEnergy() / (this.enemy.energy * 2.0);
        }
        if (this.enemy.latDirection != this.enemy.lastLatDirection) {
            this.timeSinceDirectionChange = 0.0;
        }
        this.tempWeights = this.weights;
        MaxTime = this.enemy.position.distance(this.Is.position) / 11.0;
        this.radiansToWall = this.utils.radiansToWall(this.Is.position, this.enemy.position, this.enemy.heading, 1);
        this.radiansToBackWall = this.utils.radiansToWall(this.Is.position, this.enemy.position, this.enemy.heading, -1);
        this.bPower = this.utils.limit(0.1, this.bPower, 3.0);
        this.bSpeed = this.utils.bSpeed(this.bPower);
        this.dataPoints[0] = this.bPower / 3.0;
        this.dataPoints[1] = this.enemy.lateralVelocity / 8.0;
        this.dataPoints[2] = this.enemy.distance / this.Is.greatestDist;
        this.dataPoints[3] = (this.enemy.lateralHeading - this.enemy.lastLateralHeading) / 0.17453292519943295;
        this.dataPoints[4] = (this.enemy.velocity - this.enemy.lastVelocity) / 2.0;
        this.dataPoints[5] = this.enemy.velocity / 8.0;
        this.dataPoints[6] = this.utils.limit(0.0, this.timeSinceShot / MaxTime, 1.0);
        this.dataPoints[7] = this.utils.limit(0.0, this.timeSinceDirectionChange / MaxTime, 1.0);
        this.dataPoints[8] = (this.enemy.lateralVelocity - this.enemy.lastLateralVelocity) / 2.0;
        this.dataPoints[9] = this.utils.limit(0.0, this.timeSinceHit / MaxTime, 1.0);
        this.dataPoints[10] = this.utils.limit(-1.0, this.radiansToWall / Math.asin(8.0 / this.bSpeed), 1.0) * (double)this.enemy.latDirection;
        this.dataPoints[11] = this.utils.limit(-1.0, this.radiansToBackWall / Math.asin(8.0 / this.bSpeed), 1.0) * (double)this.enemy.latDirection;
        this.dataPoints[12] = this.currentFiringOffset;
        this.advanceWaves();
        boolean fire = this.checkFire();
        this.aimGun();
        if (fire) {
            this.spawnWave(true);
            this.timeSinceShot = 0.0;
        }
    }

    void advanceWaves() {
        int i = 0;
        while (i < this.waveGroup.size()) {
            GunHandler wave = this.waveGroup.get(i);
            wave.distTravelled = (double)(this.Is.getTime() - wave.shotTime) * wave.bSpeed;
            boolean remove = this.checkWave(wave);
            if (remove) {
                this.waveGroup.remove(i);
                --i;
            }
            ++i;
        }
    }

    boolean checkWave(GunHandler wave) {
        if (wave.distTravelled > wave.shotPosition.distance(this.enemy.position)) {
            this.storeWave(wave);
            return true;
        }
        return false;
    }

    void storeWave(GunHandler wave) {
        double offset = this.getImmediateOffset(wave);
        if (wave.isReal) {
            this.offsetMap.put(wave.dataPoints, offset);
            this.lastInputOffset = offset;
        }
        this.maximizePerformance(offset, wave);
    }

    double getImmediateOffset(GunHandler wave) {
        double resultBearing = this.utils.getAbsBearing(wave.shotPosition, this.enemy.position);
        double bearingDiff = Utils.normalRelativeAngle((double)(resultBearing - wave.absBearing));
        return bearingDiff / wave.maxEscapeAngle;
    }

    void aimGun() {
        double aimBearing = this.checkHeaviestAngle();
        this.Is.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(aimBearing - this.Is.getGunHeadingRadians())));
    }

    double heaviestOffset() {
        ArrayList<Double> inputVals = new ArrayList<Double>();
        ArrayList<Double> resultVals = new ArrayList<Double>();
        int i = 0;
        while (i < this.dataPoints.length) {
            inputVals.add(this.dataPoints[i]);
            ++i;
        }
        this.myNet.feedForward(inputVals);
        this.myNet.getResults(resultVals);
        return (Double)resultVals.get(0);
    }

    double checkHeaviestAngle() {
        double firingAngle = this.enemy.absBearing;
        ArrayList<Double> inputVals = new ArrayList<Double>();
        ArrayList<Double> resultVals = new ArrayList<Double>();
        int i = 0;
        while (i < this.dataPoints.length) {
            inputVals.add(this.dataPoints[i]);
            ++i;
        }
        this.myNet.feedForward(inputVals);
        this.myNet.getResults(resultVals);
        this.currentFiringOffset = (Double)resultVals.get(0);
        firingAngle = this.thetaForOffset(this.currentFiringOffset);
        return firingAngle;
    }

    double getNearestThetaForData(double[] dataPointActual) {
        double tempDist = 100000.0;
        double offset = 0.0;
        for (double[] dataPointPast : this.offsetMap.keySet()) {
            double dist = this.utils.distanceSquared(dataPointPast, dataPointActual);
            if (!(dist < tempDist)) continue;
            tempDist = dist;
            offset = this.offsetMap.get(dataPointPast);
        }
        return Utils.normalRelativeAngle((double)(offset * Math.asin(8.0 / this.bSpeed) * (double)this.enemy.latDirection + this.enemy.absBearing));
    }

    double getThetaForData(double[] dataPoint) {
        return Utils.normalRelativeAngle((double)(this.offsetMap.get(dataPoint) * Math.asin(8.0 / this.bSpeed) * (double)this.enemy.latDirection + this.enemy.absBearing));
    }

    double thetaForOffset(double ofS) {
        return Utils.normalRelativeAngle((double)(ofS * Math.asin(8.0 / this.bSpeed) * (double)this.enemy.latDirection + this.enemy.absBearing));
    }

    boolean checkFire() {
        return this.Is.getGunTurnRemainingRadians() == 0.0 && this.Is.getGunHeat() == 0.0 && (this.Is.getEnergy() > this.bPower || this.fireToDeath) && this.Is.getEnergy() > 0.0;
    }

    void spawnWave(boolean real) {
        GunHandler gWave = new GunHandler();
        gWave.bPower = this.bPower;
        gWave.shotPosition = this.Is.position;
        gWave.distance = this.Is.position.distance(this.enemy.position);
        gWave.distTravelled = 0.0;
        gWave.bSpeed = this.utils.bSpeed(this.bPower);
        gWave.maxEscapeAngle = Math.asin(8.0 / gWave.bSpeed) * (double)this.enemy.latDirection;
        gWave.shotTime = this.Is.getTime() + 1L;
        gWave.absBearing = this.enemy.absBearing;
        gWave.latDirection = this.enemy.latDirection;
        gWave.predictedOffset = this.predictedOffset;
        gWave.isReal = real;
        gWave.dataPoints[0] = this.bPower / 3.0;
        gWave.dataPoints[1] = this.enemy.lateralVelocity / 8.0;
        gWave.dataPoints[2] = this.enemy.distance / this.Is.greatestDist;
        gWave.dataPoints[3] = (this.enemy.lateralHeading - this.enemy.lastLateralHeading) / 0.17453292519943295;
        gWave.dataPoints[4] = (this.enemy.velocity - this.enemy.lastVelocity) / 2.0;
        gWave.dataPoints[5] = this.enemy.velocity / 8.0;
        gWave.dataPoints[6] = this.utils.limit(0.0, this.timeSinceShot / MaxTime, 1.0);
        gWave.dataPoints[7] = this.utils.limit(0.0, this.timeSinceDirectionChange / MaxTime, 1.0);
        gWave.dataPoints[8] = (this.enemy.lateralVelocity - this.enemy.lastLateralVelocity) / 2.0;
        gWave.dataPoints[9] = this.utils.limit(0.0, this.timeSinceHit / MaxTime, 1.0);
        gWave.dataPoints[10] = this.utils.limit(-1.0, this.radiansToWall / gWave.maxEscapeAngle, 1.0);
        gWave.dataPoints[11] = this.utils.limit(-1.0, this.radiansToBackWall / gWave.maxEscapeAngle, 1.0);
        gWave.dataPoints[12] = this.currentFiringOffset;
        this.waveGroup.add(gWave);
        this.Is.setFire(this.bPower);
        this.lastWave = gWave;
    }
}

