/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.movement;

import gf.Centaur.Data;
import gf.Centaur.movement.MoveToPoint;
import gf.Centaur.movement.Movement;
import gf.Centaur.movement.PrecisePrediction;
import gf.Centaur.movement.PredictionRobot;
import gf.Centaur.utils.EuclideanVector;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.VirtualRobot;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.CustomEvent;

public class MinimumRiskGTMovement
extends Movement {
    private static final double MIN_MOVE_DIST = 0.0;
    private static final double DIST_STEP = 20.0;
    private static final double MAX_DISTANCE = 200.0;
    private static final int MAX_LAST_POINTS = 5;
    private static final double MAX_DRAW_RISK = 2.0;
    private static final double NEAREST_WEIGHT = 0.6;
    private static final double DIST_WEIGHT = 0.03;
    private static final double HIT_WALL_WEIGHT = Double.POSITIVE_INFINITY;
    private static final double LAST_POINTS_WEIGHT = 0.003;
    private static final double DIST_DIVISOR = 1500.0;
    private static final double LATERAL_DIVISOR = Math.PI;
    private static final double LATERAL_WEIGHT = 0.01;
    private static final double CENTER_WEIGHT = 0.01;
    private final double battleFieldWidth;
    private final double battleFieldHeight;
    private Point2D.Double ownRobotPos;
    private LinkedList<Point2D.Double> lastPoints = new LinkedList();

    public MinimumRiskGTMovement(AdvancedRobot robot, Data data) {
        super(robot, data);
        this.battleFieldWidth = robot.getBattleFieldWidth();
        this.battleFieldHeight = robot.getBattleFieldHeight();
        System.out.println("Neue Bewegungssteuerung: MinimumRiskGTMovement");
    }

    @Override
    public void start() {
        this.nextMove();
    }

    public void nextMove() {
        this.ownRobotPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        PrecisePrediction pp = new PrecisePrediction(new ExecutingRobot(this.robot));
        this.shapes.clear();
        HashMap<Point2D.Double, Double> points = new HashMap<Point2D.Double, Double>();
        double bestRisk = Double.POSITIVE_INFINITY;
        MoveToPoint bestMove = null;
        double angle = Math.PI * -2;
        while (angle <= Math.PI * 2) {
            double dist = -200.0;
            while (dist <= 200.0) {
                PredictionRobot rob = pp.getPrediction(dist, angle);
                MoveToPoint move = new MoveToPoint(rob, dist, angle);
                double risk = this.getRisk(move);
                points.put(move.getPosition(), risk);
                if (bestMove == null || risk < bestRisk) {
                    bestRisk = risk;
                    bestMove = move;
                }
                if (dist + 20.0 > -0.0) {
                    // empty if block
                }
                dist += 20.0;
            }
            angle += Math.toRadians(5.0);
        }
        double minRisk = Math.min((Double)Collections.min(points.values()), 1.0);
        double maxRisk = Math.min((Double)Collections.max(points.values()), 2.0);
        for (Map.Entry entry : points.entrySet()) {
            Point2D.Double point = (Point2D.Double)entry.getKey();
            double redValue = (Math.min((Double)entry.getValue(), 2.0) - minRisk) / (maxRisk - minRisk);
            Color paint = new Color((float)redValue, 0.0f, (float)(1.0 - redValue));
            this.shapes.put(new Ellipse2D.Double(point.x - 2.0, point.y - 2.0, 4.0, 4.0), paint);
        }
        this.shapes.put(new Ellipse2D.Double(bestMove.getX() - 2.0, bestMove.getY() - 2.0, 4.0, 4.0), Color.green);
        if (this.lastPoints.size() == 5) {
            this.lastPoints.removeFirst();
        }
        this.lastPoints.add(bestMove.getPosition());
        this.robot.setAhead(bestMove.getDistance());
        this.robot.setTurnRightRadians(bestMove.getTurn());
        this.isMoving = true;
        this.isTurning = true;
    }

    private double getRisk(MoveToPoint move) {
        double risk = 0.0;
        if (move.hasHitWall()) {
            risk += Double.POSITIVE_INFINITY;
        }
        for (VirtualRobot robot : this.data.getEnemies().values()) {
            double leastDistance = Double.POSITIVE_INFINITY;
            for (VirtualRobot otherRobot : this.data.getEnemies().values()) {
                double distance;
                if (otherRobot == robot || !((distance = robot.getPosition().distance(otherRobot.getPosition())) < leastDistance)) continue;
                leastDistance = distance;
            }
            if (!(robot.getPosition().distance(move.getPosition()) < leastDistance)) continue;
            risk += 0.6;
        }
        for (VirtualRobot rob : this.data.getEnemies().values()) {
            risk += 1.0 / (move.getPosition().distance(rob.getPosition()) / 1500.0) * 0.03;
        }
        for (Point2D.Double point : this.lastPoints) {
            risk += 1.0 / (move.getPosition().distance(point) / 1500.0) * 0.003;
        }
        for (VirtualRobot rob : this.data.getEnemies().values()) {
            risk += 1.0 / Math.abs(new EuclideanVector(rob.getPosition(), this.ownRobotPos).angleBetween(new EuclideanVector(rob.getPosition(), move.getPosition())) / Math.PI) * 0.01;
        }
        return risk += 1.0 / (move.getPosition().distance(new Point2D.Double(this.battleFieldWidth / 2.0, this.battleFieldHeight / 2.0)) / 1500.0) * 0.01;
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() == this.MyMoveCompleteCondition) {
            this.nextMove();
        }
    }
}

