/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.targeting;

import gf.Centaur.Data;
import gf.Centaur.abstracts.Module;
import gf.Centaur.targeting.AdvancedGun;
import gf.Centaur.targeting.GunControll;
import gf.Centaur.targeting.HeadOnGun;
import gf.Centaur.targeting.LinearGun;
import gf.Centaur.targeting.VirtualGun;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.VirtualRobot;
import gf.Centaur.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.text.DecimalFormat;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;

public class Gun
extends Module {
    private AdvancedRobot robot;
    private Data data;
    private GunControll gun = new HeadOnGun();
    private boolean isTurningGun = false;
    private double bulletPower = 0.0;
    private Condition MyGunTurnCompleteCondition = new Condition("MyGunTurnCompleteCondition"){

        public boolean test() {
            if (Gun.this.isTurningGun && Gun.this.robot.getGunTurnRemaining() == 0.0) {
                Gun.this.isTurningGun = false;
                return true;
            }
            return false;
        }
    };
    private Condition NoGunHeatCondition = new Condition("NoGunHeatCondition"){

        public boolean test() {
            return Gun.this.robot.getGunHeat() == 0.0;
        }
    };

    public void setOther(Data data, AdvancedRobot robot) {
        this.robot = robot;
        this.data = data;
        robot.addCustomEvent(this.MyGunTurnCompleteCondition);
        robot.addCustomEvent(this.NoGunHeatCondition);
    }

    public double getNewBulletPower(VirtualRobot target) {
        double power = this.data.getLastDistance() <= 200.0 ? 3.0 : 4.0 - Math.log10(this.data.getLastDistance() - 200.0);
        if (this.robot.getEnergy() <= 30.0) {
            power *= this.robot.getEnergy() / 50.0;
        }
        if (Rules.getBulletDamage((double)power) > target.getEnergy()) {
            power = target.getEnergy() / 4.0;
        }
        return power;
    }

    public void fire() {
        if (this.data.getVictim() == null) {
            return;
        }
        Bullet b = this.robot.setFireBullet(this.bulletPower);
        if (b != null) {
            this.data.addBullet(b);
            this.data.getOwnWaves().add(new Wave(new ExecutingRobot(this.robot), this.data.getGunArray(), this.data.getGuessFactors().get(this.data.getVictimName()), this.bulletPower, this.data.getVictim(), true, true));
        }
    }

    private void printGuns() {
        DecimalFormat format = new DecimalFormat("#.##");
        GunControll[] gunControllArray = this.data.getGunArray();
        int n = gunControllArray.length;
        int n2 = 0;
        while (n2 < n) {
            GunControll gc = gunControllArray[n2];
            System.out.println(String.valueOf(gc.getClass().getName()) + ":");
            for (Map.Entry<String, GunControll.HitRate> entry : gc.getHitRates().entrySet()) {
                System.out.println("  " + entry.getKey() + ": " + format.format(entry.getValue().getHitRate() * 100.0) + "%");
            }
            ++n2;
        }
    }

    @Override
    public void draw(Graphics2D g2d) {
        for (Map.Entry<Shape, Paint> entry : this.gun.getShapes().entrySet()) {
            g2d.setPaint(entry.getValue());
            g2d.draw(entry.getKey());
        }
        GunControll[] gunArray = this.data.getGunArray();
        int i = 0;
        while (i < gunArray.length) {
            GunControll gc = gunArray[i];
            int red = (int)((float)i / (float)(gunArray.length - 1) * 255.0f);
            g2d.setColor(new Color(red, 0, 255 - red));
            String gunName = gc.getClass().getName();
            g2d.drawChars(gunName.toCharArray(), 0, gunName.length(), 10, (int)this.robot.getBattleFieldHeight() - (15 * i + 15));
            if (gc.getHitRates() != null) {
                for (Map.Entry<String, GunControll.HitRate> entry : gc.getHitRates().entrySet()) {
                    VirtualRobot enemie = this.data.getEnemie(entry.getKey());
                    if (enemie == null) continue;
                    g2d.fillRect((int)enemie.getX() + 23, (int)enemie.getY() + 16 - 4 * i, (int)(40.0 * entry.getValue().getHitRate()), 4);
                }
            }
            ++i;
        }
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
        this.printGuns();
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        VirtualRobot target;
        if (e.getCondition() == this.MyGunTurnCompleteCondition) {
            this.fire();
        } else if (e.getCondition() == this.NoGunHeatCondition && (target = this.data.getVictim()) != null) {
            this.bulletPower = this.getNewBulletPower(this.data.getVictim());
            Double turnAngle = null;
            if (this.data.getLastDistance() <= 200.0) {
                this.gun = new LinearGun();
            } else {
                GunControll bestGun = null;
                GunControll[] gunControllArray = this.data.getGunArray();
                int n = gunControllArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GunControll gc = gunControllArray[n2];
                    if (bestGun == null) {
                        bestGun = gc;
                    } else if (bestGun.getHitRate(target.getName()) < gc.getHitRate(target.getName())) {
                        bestGun = gc;
                    }
                    ++n2;
                }
                this.gun = bestGun;
            }
            if (this.gun instanceof VirtualGun) {
                turnAngle = ((VirtualGun)this.gun).getTurnAngle(target, this.bulletPower, this.robot);
            } else if (this.gun instanceof AdvancedGun) {
                turnAngle = ((AdvancedGun)this.gun).getTurnAngle(this.robot, this.data.getGuessFactors().get(this.data.getVictimName()), this.bulletPower, this.data.getVictim());
            }
            if (turnAngle != null) {
                this.robot.setTurnGunRightRadians(turnAngle.doubleValue());
                this.isTurningGun = true;
            }
        }
    }
}

