/*
 * Decompiled with CFR 0.152.
 */
package racso;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Frog
extends AdvancedRobot {
    static final int minWallDist = 50;
    static final int enemyWallDist = 20;
    static final double ERR = 0.01;
    int MOVE_MODE = 0;
    static final int MOVE_SMART = 0;
    static final int MOVE_RANDOM = 1;
    static final int MOVE_RAM = 2;
    static final int MOVE_CENTER = 3;
    static final int SHOOT_SMART = 0;
    static final int SHOOT_FIXED_SMALL = 1;
    static final int SHOOT_FIXED_BIG = 2;
    static final int AIM_SMART = 0;
    static final int AIM_LOCK = 1;
    static final int AIM_RANDOM = 2;
    static final int AIM_SMART_INVERTED = 3;
    static final int AIM_SMART_ANGLE = 4;
    Gun currentGun;
    Enemy enemy = new Enemy(5);
    int scanStep = 0;
    int targetLostTime = 0;
    ArrayList<testShot> bullets = new ArrayList();
    ArrayList<Gun> GunStats = new ArrayList();
    double MaxEnergy;
    boolean evadingWall = false;
    boolean shotThisTurn = false;
    int moveDirection = 1;
    int evadeCounter = 0;
    boolean runningAway = false;
    LimitedQueue<Double> bestAngles = new LimitedQueue(1);

    public void onPaint(Graphics2D g) {
        for (Gun tg : this.GunStats) {
            for (testShot ts : tg.testShots) {
                g.setColor(Color.orange);
                int size = 4;
                g.fillOval((int)ts.getCurrentPosition((long)this.getTime()).x - 2, (int)ts.getCurrentPosition((long)this.getTime()).y - 2, size, size);
            }
        }
    }

    public void run() {
        this.setColors(Color.black, Color.green, Color.black);
        this.MaxEnergy = this.getEnergy();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setEvadeCounter();
        this.MOVE_MODE = 0;
        this.GunStats.add(new Gun(1, 0, "[Small, Smart]"));
        this.GunStats.add(new Gun(0, 0, "[Smart, Smart]"));
        this.GunStats.add(new Gun(2, 0, "[Big, Smart]"));
        this.GunStats.add(new Gun(1, 1, "[Small, Lock]"));
        this.GunStats.add(new Gun(0, 1, "[Smart, Lock]"));
        this.GunStats.add(new Gun(2, 1, "[Big, Lock]"));
        this.GunStats.add(new Gun(1, 2, "[Small, Random]"));
        this.GunStats.add(new Gun(0, 2, "[Smart, Random]"));
        this.GunStats.add(new Gun(2, 2, "[Big, Random]"));
        this.GunStats.add(new Gun(1, 4, "[Small, Angles]"));
        this.GunStats.add(new Gun(0, 4, "[Smart, Angles]"));
        this.GunStats.add(new Gun(2, 4, "[Big, Angles]"));
        this.GunStats.add(new Gun(0, 3, "[Smart, Smart_INV]"));
        this.currentGun = this.GunStats.get(0);
        while (true) {
            this.moveRadar();
            int i = this.bullets.size() - 1;
            while (i >= 0) {
                testShot b = this.bullets.get(i);
                Pair position = b.getCurrentPosition(this.getTime());
                if (Point.distance(position.x, position.y, b.getOrigin().x, b.getOrigin().y) >= Point.distance(this.enemy.getPosition().x, this.enemy.getPosition().y, b.getOrigin().x, b.getOrigin().y)) {
                    this.bestAngles.add(this.quickAngle(this.enemy.getPositionAngle() - b.getAngle()));
                    this.bullets.remove(b);
                }
                --i;
            }
            this.shotThisTurn = false;
            double[] params = this.getAimAngleAndPower(this.currentGun);
            if (this.getGunTurnRemaining() == 0.0 && this.getGunHeat() == 0.0 && params[1] > 0.0 && this.enemy.getDistance() < 700.0 && this.getEnergy() > params[1]) {
                this.setFire(params[1]);
                this.shotThisTurn = true;
            }
            this.setTurnGunRight(this.quickAngle(this.quickAngle(params[0]) - this.quickAngle(this.getGunHeading())));
            Gun best = this.currentGun;
            double bestDmg = best.getHits();
            for (Gun g : this.GunStats) {
                params = g.currentParams;
                if (this.shotThisTurn) {
                    g.addTestShot(params[1], params[0], new Pair(this.getX(), this.getY()));
                    if (g == this.currentGun) {
                        this.bullets.add(new testShot(params[1], params[0], new Pair(this.getX(), this.getY()), 0, 0));
                    }
                }
                g.checkForHits();
                if ((double)g.getHits() > bestDmg) {
                    best = g;
                    bestDmg = g.getHits();
                }
                g.currentParams = this.getAimAngleAndPower(g);
            }
            if (best != this.currentGun) {
                this.out.println("Switching gun. New: " + best.getName());
                this.currentGun = best;
            }
            if (this.runningAway) {
                if (this.enemy.getDistance() > 50.0 || this.getEnergy() > this.enemy.getEnergy() * 1.4) {
                    this.runningAway = false;
                } else {
                    this.MOVE_MODE = 1;
                    this.setColors(Color.black, Color.yellow, Color.black);
                }
            } else if (this.MOVE_MODE != 2 && this.getEnergy() > this.enemy.getEnergy() + 200.0) {
                this.evadeCounter = 5000;
                this.moveDirection = 1;
                this.MOVE_MODE = 2;
                this.setColors(Color.black, Color.red, Color.black);
            } else if (this.MOVE_MODE != 0 && this.getEnergy() < this.enemy.getEnergy() + 10.0) {
                this.setEvadeCounter();
                this.MOVE_MODE = 0;
                this.setColors(Color.black, Color.green, Color.black);
            }
            this.move();
            this.evadeWalls();
            this.evade();
            this.execute();
        }
    }

    public void evade() {
        --this.evadeCounter;
        if (this.evadeCounter == 0) {
            this.moveDirection *= -1;
            this.setEvadeCounter();
        }
    }

    public void moveRadar() {
        if (this.targetLostTime == 0) {
            this.setTurnRadarRight(45.0);
        } else {
            --this.targetLostTime;
            if (this.targetLostTime == 0) {
                this.out.println("Target lost. Searching.");
            } else if (this.scanStep == 1) {
                double angle = this.quickAngle(this.enemy.getPositionAngle() + 10.0 - this.getRadarHeading());
                this.setTurnRadarRight(angle);
                this.scanStep = 2;
            } else if (this.scanStep == 2) {
                double angle = this.quickAngle(this.enemy.getPositionAngle() - 10.0 - this.getRadarHeading());
                this.setTurnRadarRight(angle);
                this.scanStep = 1;
            }
        }
    }

    public double[] getAimAngleAndPower(Gun gun) {
        double retAngle;
        double retPower;
        block17: {
            retPower = 0.0;
            retAngle = 0.0;
            if (gun.getShootMode() == 0) {
                retPower = this.map(this.enemy.getDistance(), 50.0, 700.0, 3.0, 1.1);
                if ((retPower *= this.map(this.getEnergy(), 0.2 * this.MaxEnergy, 0.8 * this.MaxEnergy, 0.2, 1.0)) * 4.0 > this.enemy.getEnergy()) {
                    retPower = Math.ceil(this.enemy.getEnergy() / 4.0) + 0.1;
                }
            } else if (gun.getShootMode() == 1) {
                retPower = 1.1;
            } else if (gun.getShootMode() == 2) {
                retPower = 3.0;
            }
            if (gun.getAimMode() == 0 || gun.getAimMode() == 3) {
                int dir = 1;
                if (gun.getAimMode() == 3) {
                    dir = -1;
                }
                int iter = 1;
                double rotation = this.enemy.getHeading() - this.enemy.getHeading(1);
                Pair futureSpeed = new Pair();
                Pair futurePos = new Pair(this.enemy.getPosition().x, this.enemy.getPosition().y);
                double futureAngle = this.enemy.getHeading();
                do {
                    futureSpeed.x = (double)dir * this.enemy.getVelocity() * Math.sin(this.rad(futureAngle += rotation));
                    futureSpeed.y = (double)dir * this.enemy.getVelocity() * Math.cos(this.rad(futureAngle));
                    futurePos.x += futureSpeed.x;
                    futurePos.y += futureSpeed.y;
                    if (futureSpeed.x < -0.01 && futurePos.x < 20.0 || futureSpeed.x > 0.01 && futurePos.x > this.getBattleFieldWidth() - 20.0 || futureSpeed.y < -0.01 && futurePos.y < 20.0 || futureSpeed.y > 0.01 && futurePos.y > this.getBattleFieldHeight() - 20.0) {
                        retAngle = this.quickAngle(Math.atan2(futurePos.x - this.getX(), futurePos.y - this.getY()) * 360.0 / (Math.PI * 2));
                        retPower = 0.1;
                    } else {
                        double distance = Math.sqrt(Math.pow(futurePos.x - this.getX(), 2.0) + Math.pow(futurePos.y - this.getY(), 2.0));
                        double hitTime = distance / Rules.getBulletSpeed((double)retPower);
                        if (!((double)iter > hitTime)) continue;
                        retAngle = this.quickAngle(Math.atan2(futurePos.x - this.getX(), futurePos.y - this.getY()) * 360.0 / (Math.PI * 2));
                    }
                    break block17;
                } while (++iter <= 150);
                this.out.println("Impossible shot. Skipping.");
                retPower = 0.0;
            } else if (gun.getAimMode() == 1) {
                retAngle = this.quickAngle(this.quickAngle(this.enemy.getPositionAngle()));
            } else if (gun.getAimMode() == 2) {
                retAngle = this.quickAngle(this.quickAngle(this.enemy.getPositionAngle() + Utils.getRandom().nextDouble() * 30.0 - 15.0));
            } else if (gun.getAimMode() == 4) {
                retAngle = this.quickAngle(this.quickAngle(this.enemy.getPositionAngle()) + this.getMean(this.bestAngles));
            }
        }
        return new double[]{retAngle, retPower};
    }

    public void move() {
        if (this.MOVE_MODE == 0) {
            double rotateLeftAngle = this.quickAngle(this.enemy.getPositionAngle() + 90.0 - this.getHeading());
            double rotateRightAngle = this.quickAngle(this.enemy.getPositionAngle() - 90.0 - this.getHeading());
            if (Math.abs(rotateLeftAngle) < Math.abs(rotateRightAngle)) {
                this.setTurnRight(rotateLeftAngle);
            } else {
                this.setTurnRight(rotateRightAngle);
            }
            double tmpAngle = this.enemy.getHeading() % 180.0;
            double alpha = this.quickAngle(tmpAngle - this.enemy.getPositionAngle());
            double beta = this.quickAngle(180.0 - alpha);
            double outSgn = Math.abs(alpha) < Math.abs(beta) ? Math.signum(alpha) : Math.signum(beta) * -1.0;
            outSgn = this.checkRotationIfSummed(this.enemy.getDistance(), this.quickAngle(180.0 + this.enemy.getPositionAngle()), 1.0, this.getHeading()) == 1 ? (outSgn *= 1.0) : (outSgn *= -1.0);
            this.setAhead(20.0 * outSgn * (double)this.moveDirection);
        } else if (this.MOVE_MODE == 2) {
            double rotateRightAngle = this.quickAngle(this.quickAngle(this.enemy.getPositionAngle()) - this.quickAngle(this.getHeading()));
            double rotateLeftAngle = this.quickAngle(this.quickAngle(this.enemy.getPositionAngle()) - this.quickAngle(this.getHeading() - 180.0));
            if (Math.abs(rotateLeftAngle) < Math.abs(rotateRightAngle)) {
                this.setTurnRight(rotateLeftAngle);
                this.setAhead(-20 * this.moveDirection);
            } else {
                this.setTurnRight(rotateRightAngle);
                this.setAhead(20 * this.moveDirection);
            }
        } else if (this.MOVE_MODE == 1) {
            double rotateLeftAngle = this.quickAngle(this.enemy.getPositionAngle() + 90.0 - this.getHeading());
            this.setTurnRight(rotateLeftAngle);
            this.setAhead(20 * this.moveDirection);
        }
    }

    public void evadeWalls() {
        Pair speedDir = new Pair(Math.signum(this.getVelocity()) * Math.sin(this.rad(this.getHeading())), Math.signum(this.getVelocity()) * Math.cos(this.rad(this.getHeading())));
        if (speedDir.x < 0.0 && this.getX() < 50.0) {
            if (!this.evadingWall) {
                this.evadeCounter = 1;
            }
            this.evadingWall = true;
        } else if (speedDir.x > 0.0 && this.getX() > this.getBattleFieldWidth() - 50.0) {
            if (!this.evadingWall) {
                this.evadeCounter = 1;
            }
            this.evadingWall = true;
        } else if (speedDir.y < 0.0 && this.getY() < 50.0) {
            if (!this.evadingWall) {
                this.evadeCounter = 1;
            }
            this.evadingWall = true;
        } else if (speedDir.y > 0.0 && this.getY() > this.getBattleFieldHeight() - 50.0) {
            if (!this.evadingWall) {
                this.evadeCounter = 1;
            }
            this.evadingWall = true;
        } else {
            this.evadingWall = false;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemy.setEnergy(e.getEnergy());
        this.enemy.setLocation(e.getDistance(), this.quickAngle(e.getBearing() + this.getHeading()));
        this.enemy.setHeading(e.getHeading());
        this.enemy.setVelocity(e.getVelocity());
        this.targetLostTime = 3;
        if (this.scanStep == 0) {
            this.out.println("Target locked. Deploying.");
            this.scanStep = 1;
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.getEnergy() < e.getEnergy() * 1.1) {
            this.runningAway = true;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public double getMean(ArrayList<Double> X) {
        double sum = 0.0;
        int count = 0;
        int i = 0;
        while (i < X.size()) {
            if (X.get(i) != null) {
                sum += X.get(i).doubleValue();
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            return sum / (double)count;
        }
        return 0.0;
    }

    public double quickAngle(double angle) {
        if ((angle = (angle % 360.0 + 360.0) % 360.0) > 180.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public int checkRotationIfSummed(double d1, double a1, double d2, double a2) {
        double y;
        double x = d1 * Math.sin(this.rad(a1)) + d2 * Math.sin(this.rad(a2));
        double newAngle = this.quickAngle(Math.atan2(x, y = d1 * Math.cos(this.rad(a1)) + d2 * Math.cos(this.rad(a2))) * 360.0 / (Math.PI * 2));
        if (newAngle - a1 > 0.0) {
            return 1;
        }
        return -1;
    }

    public double map(double number, double min1, double max1, double min2, double max2) {
        if (number < min1) {
            return min2;
        }
        if (number > max1) {
            return max2;
        }
        return (number - min1) * (max2 - min2) / (max1 - min1) + min2;
    }

    public double rad(double deg) {
        return deg * 2.0 * Math.PI / 360.0;
    }

    public void setEvadeCounter() {
        this.evadeCounter = 10 + Utils.getRandom().nextInt(15);
    }

    private class Enemy {
        int historySize;
        private LimitedQueue<Double> energy;
        private LimitedQueue<Double> positionAngle;
        private LimitedQueue<Double> distance;
        private LimitedQueue<Pair> position;
        private LimitedQueue<Double> heading;
        private LimitedQueue<Double> velocity;

        public Enemy(int historySize) {
            this.energy = new LimitedQueue(5);
            this.positionAngle = new LimitedQueue(5);
            this.distance = new LimitedQueue(5);
            this.position = new LimitedQueue(5);
            this.heading = new LimitedQueue(5);
            this.velocity = new LimitedQueue(5);
            this.historySize = historySize;
            double i = 0.0;
            while (i < (double)historySize) {
                this.energy.add(0.0);
                this.positionAngle.add(0.0);
                this.position.add(new Pair());
                this.distance.add(0.0);
                this.heading.add(0.0);
                this.velocity.add(0.0);
                i += 1.0;
            }
        }

        public void setEnergy(double energy) {
            this.energy.add(energy);
        }

        public double getEnergy(int position) {
            return this.energy.get(position);
        }

        public double getEnergy() {
            return this.getEnergy(0);
        }

        public double getPositionAngle(int position) {
            return this.positionAngle.get(position);
        }

        public double getPositionAngle() {
            return this.getPositionAngle(0);
        }

        public double getDistance(int position) {
            return this.distance.get(position);
        }

        public double getDistance() {
            return this.getDistance(0);
        }

        public void setLocation(double distance, double angle) {
            this.distance.add(distance);
            this.positionAngle.add(angle);
            Pair pos = new Pair(Frog.this.getX() + distance * Math.sin(Frog.this.rad(angle)), Frog.this.getY() + distance * Math.cos(Frog.this.rad(angle)));
            this.position.add(pos);
        }

        public Pair getPosition(int position) {
            return this.position.get(position);
        }

        public Pair getPosition() {
            return this.getPosition(0);
        }

        public void setHeading(double heading) {
            this.heading.add(heading);
        }

        public double getHeading(int position) {
            return this.heading.get(position);
        }

        public double getHeading() {
            return this.getHeading(0);
        }

        public void setVelocity(double velocity) {
            this.velocity.add(velocity);
        }

        public double getVelocity(int position) {
            return this.velocity.get(position);
        }

        public double getVelocity() {
            return this.getVelocity(0);
        }
    }

    private class Gun {
        private String name;
        private int shootMode;
        private int aimMode;
        private int shots = 0;
        private int hits = 0;
        private double dmg = 0.0;
        private double lifeCost = 0.0;
        public ArrayList<testShot> testShots = new ArrayList();
        public double[] currentParams = new double[2];

        public Gun(int shootMode, int aimMode, String name) {
            this.shootMode = shootMode;
            this.aimMode = aimMode;
            this.name = name;
        }

        public void addTestShot(double power, double angle, Pair origin) {
            this.testShots.add(new testShot(power, angle, origin, this.shootMode, this.aimMode));
            ++this.shots;
            this.lifeCost += power;
        }

        public String getName() {
            return this.name;
        }

        public void checkForHits() {
            int n = this.testShots.size() - 1;
            while (n >= 0) {
                testShot ts = this.testShots.get(n);
                Pair position = ts.getCurrentPosition(Frog.this.getTime());
                if (Point.distance(position.x, position.y, Frog.this.enemy.getPosition().x, Frog.this.enemy.getPosition().y) < 25.0) {
                    ++this.hits;
                    this.dmg += Rules.getBulletDamage((double)ts.getPower());
                    this.testShots.remove(ts);
                    this.lifeCost -= Rules.getBulletHitBonus((double)ts.getPower());
                } else if (position.x <= 0.0 || position.x >= Frog.this.getBattleFieldWidth() || position.y <= 0.0 || position.y >= Frog.this.getBattleFieldHeight()) {
                    this.testShots.remove(ts);
                }
                --n;
            }
        }

        int getHits() {
            return this.hits;
        }

        int getShots() {
            return this.shots;
        }

        double getLifeCost() {
            return this.lifeCost;
        }

        double getDmg() {
            return this.dmg;
        }

        int getShootMode() {
            return this.shootMode;
        }

        int getAimMode() {
            return this.aimMode;
        }
    }

    private class LimitedQueue<T>
    extends ArrayList<T> {
        private int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(T item) {
            if (this.size() == this.limit) {
                this.remove(0);
            }
            return super.add(item);
        }

        @Override
        public T get(int position) {
            return (T)super.get(this.size() - position - 1);
        }
    }

    private class Pair {
        public double x;
        public double y;

        public Pair() {
        }

        public Pair(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private class testShot {
        private double power;
        private double angle;
        private long time;
        private Pair origin;
        private int shootMode;
        private int aimMode;

        public testShot(double power, double angle, Pair origin, int shootMode, int aimMode) {
            this.power = power;
            this.angle = angle;
            this.origin = origin;
            this.shootMode = shootMode;
            this.aimMode = aimMode;
            this.time = Frog.this.getTime();
        }

        public double getAngle() {
            return this.angle;
        }

        public double getPower() {
            return this.power;
        }

        public Pair getOrigin() {
            return this.origin;
        }

        public Pair getCurrentPosition(long time) {
            long t = time - this.time;
            Pair speed = new Pair(Rules.getBulletSpeed((double)this.power) * Math.sin(Frog.this.rad(this.angle)), Rules.getBulletSpeed((double)this.power) * Math.cos(Frog.this.rad(this.angle)));
            Pair position = new Pair(this.origin.x + (double)t * speed.x, this.origin.y + (double)t * speed.y);
            return position;
        }
    }
}

