/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.Component;
import dmonner.xlbp.Network;
import dmonner.xlbp.compound.Compound;
import dmonner.xlbp.compound.IndirectWeightBank;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.compound.WeightedCompound;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.Layer;
import dmonner.xlbp.layer.UpstreamLayer;
import dmonner.xlbp.util.ListSet;
import java.util.Set;

public class NetworkDotBuilder {
    private final Set<String> nodes;
    private final Set<String> edges;
    private final Network root;

    public NetworkDotBuilder(Network net) {
        this.root = net;
        this.nodes = new ListSet<String>();
        this.edges = new ListSet<String>();
        this.processNet(net);
    }

    private void processCompound(Compound comp) {
        if (comp instanceof WeightedCompound) {
            WeightedCompound wcomp = (WeightedCompound)comp;
            for (int i = 0; i < wcomp.nUpstreamWeights(); ++i) {
                this.processWeightBank(wcomp.getUpstreamWeights(i));
            }
        }
        for (Component component : comp.getComponents()) {
            if (component instanceof Compound) {
                this.processCompound((Compound)component);
                continue;
            }
            if (component instanceof Layer) {
                this.processNode((Layer)component);
                continue;
            }
            if (component instanceof Network) {
                this.processNet((Network)component);
                continue;
            }
            throw new IllegalArgumentException("Unhandled");
        }
    }

    private void processEdge(Layer from, Layer to) {
        this.edges.add(from.getName() + " -> " + to.getName() + " [style=dotted]");
    }

    private void processNet(Network net) {
        for (Component component : net.getComponents()) {
            if (component instanceof Compound) {
                this.processCompound((Compound)component);
                continue;
            }
            if (component instanceof Layer) {
                this.processNode((Layer)component);
                continue;
            }
            if (component instanceof Network) {
                this.processNet((Network)component);
                continue;
            }
            throw new IllegalArgumentException("Unhandled");
        }
    }

    private void processNode(Layer node) {
        int i;
        this.nodes.add(node.getName());
        if (node instanceof UpstreamLayer) {
            UpstreamLayer unode = (UpstreamLayer)node;
            for (i = 0; i < unode.nDownstream(); ++i) {
                this.processEdge(unode, unode.getDownstream(i).asDownstreamLayer());
            }
        }
        if (node instanceof DownstreamLayer) {
            DownstreamLayer dnode = (DownstreamLayer)node;
            for (i = 0; i < dnode.nUpstream(); ++i) {
                this.processEdge(dnode.getUpstream(i).asUpstreamLayer(), dnode);
            }
        }
    }

    private void processWeightBank(WeightBank wb) {
        if (wb instanceof IndirectWeightBank) {
            this.edges.add(wb.getWeightOutput() + " -> " + wb.getWeightInput() + " [style=dotted]");
        } else {
            this.edges.add(wb.getWeightOutput() + " -> " + wb.getWeightInput() + " [style=bold]");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph D {\n");
        sb.append("  rankdir = BT;\n");
        for (String node : this.nodes) {
            sb.append("  ");
            sb.append(node);
            sb.append(";\n");
        }
        for (String edge : this.edges) {
            sb.append("  ");
            sb.append(edge);
            sb.append(";\n");
        }
        sb.append(this.toSubgraphString(this.root, "  "));
        sb.append("}\n");
        return sb.toString();
    }

    private String toSubgraphString(Compound net, String pre) {
        StringBuilder sb = new StringBuilder();
        String name = net.getName();
        sb.append(pre);
        sb.append("subgraph cluster_");
        sb.append(name);
        sb.append(" {\n");
        sb.append(pre);
        sb.append("  ");
        sb.append("label=\"");
        sb.append(name);
        sb.append("\";\n");
        if (net instanceof WeightedCompound) {
            WeightedCompound wcomp = (WeightedCompound)net;
            for (int i = 0; i < wcomp.nUpstreamWeights(); ++i) {
                WeightBank wb = wcomp.getUpstreamWeights(i);
                sb.append(this.toSubgraphString(wb.getWeightOutput(), pre));
                sb.append(this.toSubgraphString(wb.getWeightInput(), pre));
            }
        }
        for (Component comp : net.getComponents()) {
            if (comp instanceof Network) {
                sb.append(this.toSubgraphString((Network)comp, pre + "  "));
                continue;
            }
            if (comp instanceof Compound) {
                sb.append(this.toSubgraphString((Compound)comp, pre + "  "));
                continue;
            }
            if (comp instanceof Layer) {
                sb.append(this.toSubgraphString((Layer)comp, pre + "  "));
                continue;
            }
            throw new IllegalArgumentException("Unhandled");
        }
        sb.append(pre);
        sb.append("}\n");
        return sb.toString();
    }

    private String toSubgraphString(Layer layer, String pre) {
        StringBuilder sb = new StringBuilder();
        String name = layer.getName();
        sb.append(pre);
        sb.append(name);
        sb.append(";\n");
        return sb.toString();
    }

    private String toSubgraphString(Network net, String pre) {
        StringBuilder sb = new StringBuilder();
        String name = net.getName();
        sb.append(pre);
        sb.append("subgraph cluster_");
        sb.append(name);
        sb.append(" {\n");
        sb.append(pre);
        sb.append("  ");
        sb.append("label=\"");
        sb.append(name);
        sb.append("\";\n");
        for (Component comp : net.getComponents()) {
            if (comp instanceof Network) {
                sb.append(this.toSubgraphString((Network)comp, pre + "  "));
                continue;
            }
            if (comp instanceof Compound) {
                sb.append(this.toSubgraphString((Compound)comp, pre + "  "));
                continue;
            }
            if (comp instanceof Layer) {
                sb.append(this.toSubgraphString((Layer)comp, pre + "  "));
                continue;
            }
            throw new IllegalArgumentException("Unhandled");
        }
        sb.append(pre);
        sb.append("}\n");
        return sb.toString();
    }
}

