/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.WeightUpdater;
import dmonner.xlbp.connection.Connection;
import java.io.Serializable;
import java.util.Map;

public class WeightUpdaterType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Class<?>[] classes;
    private final Object[] params;

    public static WeightUpdaterType basic() {
        String name = "dmonner.xlbp.BasicWeightUpdater";
        Class[] classes = new Class[]{Connection.class};
        Object[] params = new Object[]{null};
        return new WeightUpdaterType("dmonner.xlbp.BasicWeightUpdater", classes, params);
    }

    public static WeightUpdaterType basic(float a) {
        String name = "dmonner.xlbp.BasicWeightUpdater";
        Class[] classes = new Class[]{Connection.class, Float.TYPE};
        Object[] params = new Object[]{null, Float.valueOf(a)};
        return new WeightUpdaterType("dmonner.xlbp.BasicWeightUpdater", classes, params);
    }

    public static WeightUpdaterType batch() {
        String name = "dmonner.xlbp.BatchWeightUpdater";
        Class[] classes = new Class[]{Connection.class};
        Object[] params = new Object[]{null};
        return new WeightUpdaterType("dmonner.xlbp.BatchWeightUpdater", classes, params);
    }

    public static WeightUpdaterType batch(float a) {
        String name = "dmonner.xlbp.BatchWeightUpdater";
        Class[] classes = new Class[]{Connection.class, Float.TYPE};
        Object[] params = new Object[]{null, Float.valueOf(a)};
        return new WeightUpdaterType("dmonner.xlbp.BatchWeightUpdater", classes, params);
    }

    public static WeightUpdaterType decay(float a, float b) {
        String name = "dmonner.xlbp.DecayWeightUpdater";
        Class[] classes = new Class[]{Connection.class, Float.TYPE, Float.TYPE};
        Object[] params = new Object[]{null, Float.valueOf(a), Float.valueOf(b)};
        return new WeightUpdaterType("dmonner.xlbp.DecayWeightUpdater", classes, params);
    }

    private static float f(Map<String, Object> p, String key) {
        return Float.parseFloat(p.get(key).toString());
    }

    public static WeightUpdaterType fromString(String type, Map<String, Object> p) {
        if (type.equalsIgnoreCase("momentum")) {
            return WeightUpdaterType.momentum(WeightUpdaterType.f(p, "learningRate"), WeightUpdaterType.f(p, "momentum"));
        }
        if (type.equalsIgnoreCase("resilient")) {
            return WeightUpdaterType.resilient();
        }
        if (type.equalsIgnoreCase("relig")) {
            return WeightUpdaterType.relig();
        }
        if (type.equalsIgnoreCase("basic")) {
            return WeightUpdaterType.basic(WeightUpdaterType.f(p, "learningRate"));
        }
        if (type.equalsIgnoreCase("batch")) {
            return WeightUpdaterType.batch(WeightUpdaterType.f(p, "learningRate"));
        }
        if (type.equalsIgnoreCase("decay")) {
            return WeightUpdaterType.decay(WeightUpdaterType.f(p, "learningRate"), WeightUpdaterType.f(p, "decayRate"));
        }
        throw new IllegalArgumentException("Unhandled WeightUpdaterType: " + type);
    }

    public static WeightUpdaterType momentum() {
        String name = "dmonner.xlbp.MomentumWeightUpdater";
        Class[] classes = new Class[]{Connection.class};
        Object[] params = new Object[]{null};
        return new WeightUpdaterType("dmonner.xlbp.MomentumWeightUpdater", classes, params);
    }

    public static WeightUpdaterType momentum(float a, float m) {
        String name = "dmonner.xlbp.MomentumWeightUpdater";
        Class[] classes = new Class[]{Connection.class, Float.TYPE, Float.TYPE};
        Object[] params = new Object[]{null, Float.valueOf(a), Float.valueOf(m)};
        return new WeightUpdaterType("dmonner.xlbp.MomentumWeightUpdater", classes, params);
    }

    public static WeightUpdaterType relig() {
        String name = "dmonner.xlbp.ResilientEligibilitiesWeightUpdater";
        Class[] classes = new Class[]{Connection.class};
        Object[] params = new Object[]{null};
        return new WeightUpdaterType("dmonner.xlbp.ResilientEligibilitiesWeightUpdater", classes, params);
    }

    public static WeightUpdaterType resilient() {
        String name = "dmonner.xlbp.ResilientWeightUpdater";
        Class[] classes = new Class[]{Connection.class};
        Object[] params = new Object[]{null};
        return new WeightUpdaterType("dmonner.xlbp.ResilientWeightUpdater", classes, params);
    }

    private WeightUpdaterType(String name, Class<?>[] classes, Object[] params) {
        this.name = name;
        this.classes = classes;
        this.params = params;
    }

    public WeightUpdater make(Connection conn) {
        this.params[0] = conn;
        try {
            return (WeightUpdater)Class.forName(this.name).getConstructor(this.classes).newInstance(this.params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

