/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.layer.AbstractInternalLayer;
import dmonner.xlbp.util.MatrixTools;

public class OffsetLayer
extends AbstractInternalLayer {
    private static final long serialVersionUID = 1L;
    private final int offset;
    private float[] x;

    public OffsetLayer(OffsetLayer that, NetworkCopier copier) {
        super(that, copier);
        this.offset = that.offset;
        if (that.x != null) {
            this.x = copier.copyState() ? MatrixTools.copy(that.x) : MatrixTools.empty(that.x);
        }
    }

    public OffsetLayer(String name, int size, int offset) {
        super(name, size);
        this.offset = offset;
    }

    @Override
    public void activateTest() {
        MatrixTools.rotateRight(this.y, this.x, this.offset);
    }

    @Override
    public void activateTrain() {
        this.activateTest();
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.upstream.build();
            this.x = this.upstream.getActivations();
            this.y = new float[this.size];
            this.d = new Responsibilities(this.size);
            this.built = true;
        }
    }

    @Override
    public OffsetLayer copy(NetworkCopier copier) {
        return new OffsetLayer(this, copier);
    }

    @Override
    public OffsetLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showExtra()) {
            sb.appendln("Offset: " + this.offset);
        }
        sb.popIndent();
    }

    @Override
    public void updateEligibilities() {
        if (this.downstreamCopyLayer != null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateResponsibilities() {
        if (this.downstreamCopyLayer == null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateUpstreamResponsibilities(int index) {
        Responsibilities dup = this.upstream.getResponsibilities(this.myIndexInUpstream);
        MatrixTools.rotateLeft(dup.get(), this.d.get(), this.offset);
        dup.touch();
    }
}

