/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

public class Point {
    public double x;
    public double y;

    public void rotate(double rotAngle) {
        double angle = Math.atan2(this.x, this.y) + rotAngle;
        double length = Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = Math.sin(angle) * length;
        this.y = Math.cos(angle) * length;
    }

    public double getAngle() {
        return Math.atan2(this.x, this.y);
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distance(Point p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(double pX, double pY) {
        double dx = this.x - pX;
        double dy = this.y - pY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceSq(Point p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(double pX, double pY) {
        double dx = this.x - pX;
        double dy = this.y - pY;
        return dx * dx + dy * dy;
    }

    public double bearingTo(Point endPoint) {
        return Math.atan2(endPoint.x - this.x, endPoint.y - this.y);
    }

    public double bearingTo(double pX, double pY) {
        return Math.atan2(pX - this.x, pY - this.y);
    }

    public Point projectPoint(double distance, double angle) {
        return new Point(this.x + distance * Math.sin(angle), this.y + distance * Math.cos(angle));
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(double px, double py, double dist, double angle) {
        this.x = px + dist * Math.sin(angle);
        this.y = py + dist * Math.cos(angle);
    }
}

