/*
 * Decompiled with CFR 0.152.
 */
package amc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class ROBv202
extends AdvancedRobot {
    private double _bfWidth;
    private double _bfHeight;
    private Rectangle2D.Double _fieldRect;
    private int scannedX = Integer.MIN_VALUE;
    private int scannedY = Integer.MIN_VALUE;
    private static int WALL_STICK = 40;
    private double distanceThreshold = 150.0;
    private int direction = 1;
    private double goalDir;

    public void run() {
        this.setColors(Color.white, Color.white, Color.white, Color.white, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this._bfWidth = this.getBattleFieldWidth();
        this._bfHeight = this.getBattleFieldHeight();
        this._fieldRect = new Rectangle2D.Double(18.0, 18.0, this._bfWidth - 36.0, this._bfHeight - 36.0);
        while (true) {
            this.turnGunRight(360.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double angle = Math.toRadians(this.getHeading() + e.getBearing());
        this.scannedX = (int)(this.getX() + Math.sin(angle) * e.getDistance());
        this.scannedY = (int)(this.getY() + Math.cos(angle) * e.getDistance());
        double radarTurn = angle - Math.toRadians(this.getRadarHeading());
        this.setTurnGunRight(1.9 * Utils.normalRelativeAngle((double)radarTurn) * 180.0 / Math.PI);
        double distanceOffset = this.distanceCheck(e.getDistance());
        double angleDirection = 90.0 - e.getBearing() + distanceOffset;
        this.wallsCheck(Math.toRadians(angleDirection));
        this.setTurnLeft(angleDirection);
        this.setAhead(this.direction * 50);
    }

    private void wallsCheck(double goalDirection) {
        double absDir;
        double offset = 0.0;
        if (this.direction < 0) {
            offset = Math.PI;
        }
        this.goalDir = absDir = offset + (this.getHeadingRadians() + goalDirection);
        if (!this._fieldRect.contains(this.getX() + Math.sin(absDir) * (double)WALL_STICK, this.getY() + Math.cos(absDir) * (double)WALL_STICK)) {
            this.direction *= -1;
        }
    }

    private double distanceCheck(double distance) {
        double offset = 20.0;
        if (distance > this.distanceThreshold + 20.0) {
            offset *= (double)(-this.direction);
        } else if (distance < this.distanceThreshold - 20.0) {
            offset *= (double)this.direction;
            this.setFire(3.0);
        } else {
            offset = 0.0;
            this.setFire(2.0);
        }
        return offset;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Math.abs(e.getBearing());
    }

    public void onWin(WinEvent e) {
        this.turnLeft(60.0);
        this.turnRight(120.0);
        this.turnLeft(120.0);
        this.turnRight(120.0);
        this.turnLeft(60.0);
        this.out.println("Vyhral jsem!");
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(255, 0, 0, 128));
        g.drawLine(this.scannedX, this.scannedY, (int)this.getX(), (int)this.getY());
        g.fillRect(this.scannedX - 20, this.scannedY - 20, 40, 40);
        g.setColor(new Color(0, 255, 0));
        g.drawOval((int)this.getX() - WALL_STICK, (int)this.getY() - WALL_STICK, 2 * WALL_STICK, 2 * WALL_STICK);
        g.fillOval((int)(this.getX() + Math.sin(this.goalDir) * (double)WALL_STICK) - 2, (int)(this.getY() + Math.cos(this.goalDir) * (double)WALL_STICK) + 2, 5, 5);
        g.setColor(new Color(0, 0, 255));
        g.draw(this._fieldRect);
    }
}

