package chase.twin;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class SurroundOne extends TeamRobot {
	private static Map<String,EnemyInfo> enemies;
	private static Point2D.Double myLocation;
	public static boolean isLeader = false;
	Point2D.Double center = null;
	public void run() {
		enemies = new HashMap<String,EnemyInfo>();
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		if(getEnergy() > 101) {
			isLeader = true;
		}
		
		while(true) {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double eAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double eDistance = e.getDistance();
		String eName;
		myLocation = new Point2D.Double(getX(), getY());
		
		//Info
		if(!isTeammate(eName = e.getName())) {
			EnemyInfo eInfo = enemies.get(eName);
			if(eInfo == null) eInfo = new EnemyInfo();
			eInfo.setLocation(project(myLocation,eAbsoluteBearing,eDistance));
			eInfo.name = eName;
			eInfo.lastScanTime = e.getTime();
			eInfo.angle =  eAbsoluteBearing;
			eInfo.distance = e.getDistance();
			eInfo.heading = e.getHeadingRadians();
			eInfo.velocity = e.getVelocity();
			if(e.getEnergy() > 150) eInfo.isLeader = true;
			eInfo.isSet = true;
			enemies.put(eName, eInfo);
		}
		
		double centerX = 0;
		double centerY = 0;
		
		if(enemies.size() == 2) {
			EnemyInfo Leader = null;
			EnemyInfo Slave = null;
			
			//Radar
			Iterator<EnemyInfo> it = enemies.values().iterator();
			double eRadarAngle = eAbsoluteBearing;
			long oldestScan = Long.MAX_VALUE;
			while(it.hasNext()) {
				EnemyInfo tmpInfo = it.next();
				centerX += tmpInfo.x;
				centerY += tmpInfo.y;
				if(tmpInfo.isLeader) {
					Leader = tmpInfo;
				} else {
					Slave = tmpInfo;
				}
				
				if(tmpInfo.lastScanTime < oldestScan) {
					eRadarAngle = absoluteAngle(myLocation,tmpInfo);
					oldestScan = tmpInfo.lastScanTime;
				}
			}
		
			setTurnRadarRightRadians(Utils.normalRelativeAngle(eRadarAngle -
				getRadarHeadingRadians())*2);
			
			//First Determine the Center of the two enemy robots;
			center = new Point2D.Double(centerX/2, centerY/2);
			
			//Movement
			if(isLeader) {
				double myDistance = Leader.distance(center) + 100;
				double myAngle = absoluteAngle(center, Leader);
				Point2D.Double wantToBe = project(center, myAngle, myDistance);
				setGoto(wantToBe.x, wantToBe.y);
				
				//Targeting
				if(Leader.distance < 150) {
					setTurnGunRightRadians(Utils.normalRelativeAngle(Leader.angle
						- getGunHeadingRadians() + (Leader.velocity *
						Math.sin(Leader.heading - Leader.angle) / 13.0)));
					setFire(3);
				}
			} else {
				double myDistance = Slave.distance(center) + 100;
				double myAngle = absoluteAngle(center, Slave);
				Point2D.Double wantToBe = project(center, myAngle, myDistance);
				setGoto(wantToBe.x, wantToBe.y);
				
				//Targeting
				if(Slave.distance < 150) {
					setTurnGunRightRadians(Utils.normalRelativeAngle(Slave.angle
						- getGunHeadingRadians() + (Slave.velocity *
						Math.sin(Slave.heading - Slave.angle) / 13.0)));
					setFire(3);
				}
			}
		} else if(enemies.size() == 1 && getTime() > 50) {
			setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
			EnemyInfo tmpInfo = (EnemyInfo)(enemies.values().toArray())[0];

			double myAngle = (isLeader) ? 0 : Math.PI;
			Point2D.Double wantToBe = project(tmpInfo, myAngle, 100);
			setGoto(wantToBe.x, wantToBe.y);
			
			if(tmpInfo.distance < 150) {
				setTurnGunRightRadians(Utils.normalRelativeAngle(tmpInfo.angle
					- getGunHeadingRadians() + (tmpInfo.velocity *
					Math.sin(tmpInfo.heading - tmpInfo.angle) / 13.0)));
			
				setFire(3);
			}
		} else {
			setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
			if(isLeader)
				setGoto(100, 400);
			else
				setGoto(700, 400);
		}
	}
	
	private void setGoto(double x, double y) {
		double goAngle = Utils.normalRelativeAngle(
			Math.atan2(x - myLocation.x, y - myLocation.y) - getHeadingRadians());
		setTurnRightRadians(Math.tan(goAngle));
		setAhead(Math.cos(goAngle)*Math.sqrt(
			(myLocation.x-x)*(myLocation.x-x)+
			(myLocation.y-y)*(myLocation.y-y)));
	}
	
	public void onPaint(Graphics2D g) {
		g.setColor(java.awt.Color.RED);
		if(center != null)
			g.fillOval((int)center.x-3, (int)center.y-3, 6, 6);
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		enemies.remove(e.getName());
	}
	
	public static final double absoluteAngle(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	
	public static final Point2D.Double project(
			Point2D.Double location, double angle, double distance){
		return new Point2D.Double(location.x + distance*Math.sin(angle),
								location.y + distance*Math.cos(angle));
	}
	
	private class EnemyInfo extends Point2D.Double {
		String name;
		long lastScanTime;
		double angle, heading, velocity, distance;
		boolean isLeader, isSet;
	}
}
