//--------------------------------------------------------------------------
// $Id: SimpleEnemy.java,v 1.1 2003/08/29 09:18:58 erning Exp $
//--------------------------------------------------------------------------
// Copyright (c) 2000-2003 Dragon Software Corp. All rights reserved.
//
// Please refer to COPYRIGHT for notices regarding the confidential
// and proprietary nature of this source code.
//--------------------------------------------------------------------------

package net.dragonsoft.robocoding.lindada;

import net.dragonsoft.robocoding.AbstractBot;
import net.dragonsoft.robocoding.Enemy;
import net.dragonsoft.robocoding.EnemyState;
import net.dragonsoft.robocoding.util.Position;

import robocode.ScannedRobotEvent;

public class SimpleEnemy implements Enemy
{
    public SimpleEnemy(AbstractBot robot, String name)
    {
        _robot = robot;
        _name = name;
    }

    public EnemyState update(ScannedRobotEvent event)
    {
        // create new state
        EnemyState es = new EnemyState();

        es.myEnergy = _robot.getEnergy();
        es.myHeading = _robot.getHeadingRadians();
        es.myVelocity = _robot.getVelocity();
        es.myX = _robot.getX();
        es.myY = _robot.getY();

        es.energy = event.getEnergy();
        es.heading = event.getHeadingRadians();
        es.bearing = event.getBearingRadians();
        es.velocity = event.getVelocity();
        es.distance = event.getDistance();
        //es.angle = (es.myHeading + es.bearing) % (Math.PI * 2);
        es.angle = robocode.util.Utils.normalAbsoluteAngle(es.myHeading + es.bearing);
        Position p = Position.calcPosition(es.myX, es.myY, es.angle, es.distance);
        es.x = p.x;
        es.y = p.y;

        es.time = _robot.getTime();

        if (_currentState != null)
        {
            es.velocityChange = es.velocity - _currentState.velocity;
            es.headingChange = es.heading - _currentState.heading;
            es.energyChange = es.energy - _currentState.energy;
        }

        _currentState = es;

        return es;
    }

    /**
     * Returns the current state of the enemy
     */
    public EnemyState getCurrentState()
    {
        return _currentState;
    }


    public EnemyState getState(int index)
    {
        return _currentState;
    }

    /**
     * Returns the enemy's name
     */
    public String getName()
    {
        return _name;
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append("SimpleEnemy: [").append(_name).append("]");
        sb.append(" CurrentState: ").append(_currentState);
        return sb.toString();
    }

    protected String _name;
    protected EnemyState _currentState = null;

    protected AbstractBot _robot;
}

