package axeBots.data;

import java.util.ArrayList;
import axeBots.AxeBot;
import axeBots.AxeException;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;
import java.awt.geom.*;
import java.io.*;

/**
 * BotData - 11/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZs comment about
 * OpenSouce: "At least is a good Karma".
 */
public class BotData {

	public static final char VERSION = 231;
	private String bot = null;

	public static final int MAX_SAMPLES = AxeBot.LITE_CANNON ? 200 : 20000;
	public static final int RADAR = 2000;
	public static final int HEADS = 180;
	public static final int MAX_TIME = 200;
	private ArrayList interpolated = new ArrayList();
	private ArrayList samplesList = new ArrayList();
	private SegmentedGFs gfHistory = new SegmentedGFs();
	private BotScore scorer = null;
	private ArrayList myAttackAngles = null;

	public BotData(String botName) {
		super();
		bot = botName;
		scorer = new BotScore(bot);
	}

	public void reset() {
		scorer = new BotScore(bot);
		interpolated = new ArrayList();
		samplesList = new ArrayList();
		newRound();
	}

	public int getSamplesListSize() {
		return samplesList.size();
	}

	public int getSamplesSize() {
		int sz = 0;
		for (int i = 0; i < samplesList.size(); i++) {
			sz += ((ArrayList) (samplesList.get(i))).size();
		}
		return sz;
	}

	public ArrayList getSamplesList() {
		return samplesList;

	}

	public void newRound() {
		AxeBot.getIt().out.println("BotData new round. samples size before:"
				+ this.getSamplesSize());
		restrictSamples(MAX_SAMPLES);
		AxeBot.getIt().out.println("BotData new round. samples size after:"
				+ this.getSamplesSize());
		samplesList.ensureCapacity(samplesList.size() + 1000);
		interpolated.ensureCapacity(interpolated.size() + 1000);
		samplesList.add(new ArrayList());
		interpolated.add(new ArrayList());
		scorer.newRound();
		gfHistory.newRound();
		myAttackAngles = new ArrayList();
		
		PatternSample.incSampCont(PatternSample .AGING_LIFE );
		
	}

	public void restrictSamples(int to) {
		int c = samplesList.size() - 1;
		if (c < 0) {
			return;
		}
		int samps = 0;
		do {
			samps += ((ArrayList) (samplesList.get(c))).size();
			c--;
		} while ((samps < to) && (c >= 0));
		if (c >= 0) {
			samplesList = new ArrayList(samplesList.subList(c + 2, samplesList
					.size()));
			interpolated = new ArrayList(interpolated.subList(c + 2,
					interpolated.size()));
		}
	}

	public void restrictRounds(int to) {
		if (samplesList.size() < to) {
			return;
		}
		samplesList = new ArrayList(samplesList.subList(
				samplesList.size() - to, samplesList.size()));
		interpolated = new ArrayList(interpolated.subList(interpolated.size()
				- to, interpolated.size()));
	}

	public void restrictInterpolated(int to) {
		int c = interpolated.size() - 1;
		if (c < 0) {
			return;
		}
		int iters = 0;
		do {
			iters += ((ArrayList) (interpolated.get(c))).size();
			c--;
		} while ((iters < to) && (c >= 0));
		if (c >= 0) {
			samplesList = new ArrayList(samplesList.subList(c + 2, samplesList
					.size()));
			interpolated = new ArrayList(interpolated.subList(c + 2,
					interpolated.size()));
		}
	}

	public void add(double x, double y, double time, double timesDelta,
			double distMe, double headToMe, double myAttackAngle,
			long timeSinceAcc, long timeSinceDeacc, long timeSinceFire) {
		ArrayList inter = (ArrayList) interpolated.get(interpolated.size() - 1);
		AxeVector last;
		if (inter.size() == 0) {
			last = new AxeVector(x, y);
			//			adicionado posiccao do tempo zero
			//			inter.add(last);
		} else {
			last = (AxeVector) inter.get(inter.size() - 1);
		}
		double x0 = last.getX();
		double y0 = last.getY();
		double Dx = x - x0;
		double Dy = y - y0;
		double dx = Dx / timesDelta;
		double dy = Dy / timesDelta;
		AxeVector interpol = null;
		for (int i = 0; i < timesDelta; i++) {
			x0 += dx;
			y0 += dy;
			interpol = new AxeVector(x0, y0); //, tetha, mod);
			inter.add(interpol);
			myAttackAngles.add(new Double(myAttackAngle));
		}
		addSample(headToMe, distMe, (int) timesDelta, timeSinceAcc,
				timeSinceDeacc,timeSinceFire, myAttackAngle);
	}

	public double getMyAttackAngle(long atTime) {
		atTime = (atTime > (myAttackAngles.size() - 1))
				? myAttackAngles.size() - 1
				: atTime - 1;
		return ((Double) myAttackAngles.get((int)atTime)).doubleValue();
	}

	public Point2D.Double getPos(int atTime) {
		ArrayList inter = (ArrayList) interpolated.get(interpolated.size() - 1);
		if (inter.size() < atTime) {
			System.out.println(".................... " + this.bot
					+ " HISTORY FORA DE FASE: atTime:" + atTime + " sz:"
					+ inter.size() + " now:" + AxeBot.getIt().getTime());
		}
		atTime = (inter.size() < atTime) ? inter.size() : atTime;
		return ((AxeVector) inter.get(atTime - 1)).getEndPoint();
	}

	private void addSample(double headToMe, double distMe, int deltatime,
			long timeSinceAcc, long timeSinceDeacc, long timeSinceFire, double myAttackAngle) {
		ArrayList inter = (ArrayList) interpolated.get(interpolated.size() - 1);
		ArrayList samples = (ArrayList) samplesList.get(samplesList.size() - 1);
		int iSize = inter.size();
		//        int sSize= samples.size();
		int maxwid = PatternSample.getMaxWideness();
		//int deltatime= iSize - (sSize+maxwid );
		if (iSize <= maxwid) {
			return;
		}
		for (int j = deltatime; j > 0; j--) {
			int now = iSize - j;
			if (now <= maxwid) {
				continue;
			}
			Point2D.Double p0 = ((AxeVector) inter.get(now)).getEndPoint();
			AxeVector samps[] = new AxeVector[PatternSample.GROUPS.length];
			for (int i = 0; i < samps.length; i++) {
				Point2D.Double pf = ((AxeVector) inter.get(now
						- PatternSample.GROUPS[i])).getEndPoint();
				samps[i] = new AxeVector(p0, pf);
			}
			try {
				samples.add(new PatternSample(samps, now, distMe, headToMe,
						timeSinceAcc, timeSinceDeacc, timeSinceFire, myAttackAngle));
			} catch (AxeException e) {
				e.printStackTrace();
			}
		}
	}

	public ArrayList getInterpolated() {
		return interpolated;
	}

	public BotScore getScorer() {
		return scorer;
	}

	public SegmentedGFs getGfHistory() {
		return gfHistory;
	}

}