package jwst.DAD;

import java.awt.Color;

import robocode.*;

import jwst.DAD.SpecialRobots.*;

/*****************************************************************************************************
 * DarkAndDarker: Made for a High School Java class 
 * Teacher: George Peck
 * we have HOPE!!... that we can win
 *             
 * Our robot generally implements 3 strategies in order to dominate(or try to :D) the other 
 * robots. 
 * 
 * Shooting: Guess Factor Targeting - it creates an array of data that tracks where the enemy
 * has moved in a set of movements and fires towards the area in which the enemy is most 
 * likely to move. It records the information in what could be called a virtual graph, creating
 * a set of data that eventually has a high point. That peak in the graph tells us where the
 * enemy is most likely to move and we fire in that location.
 * 
 * Movement(One on One): WaveSurfing - it can easily be called the counter to Guess Factor
 * Targeting. The array used in Guess Factor targeting can be described as a graph that could
 * look something like a peak, and the robot uses that peak in the graph to fire at that 
 * certain location. WaveSurfing attemps to make this graph as even as possible for the other
 * robot so that they have no idea where to fire, and their targeting is skewed.
 * 
 * Movement(Melee): AntiGravity - this uses basic vectors to assign "gravity points" to objects
 * that we want to avoid. This is especially helpful in the melee because by assigning gravity
 * points to, say, the center of the battlefield or setting gravity points to robots we can
 * make sure that we stay clear and away from danger.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * @date June 10th, 2009
 * 
 * Credit: Inspiration of ideas (e.g. splitting from Patrick Lin) And many more
 *         all the addicted programmers out there who have really no life and instead
 *         play around with robocode all day (e.g. Dookious guys, and many more)
 *         More credit given within each class
 ********************************************************************************************************/

public class DarkAndDarker extends AdvancedRobot
{
    // I took a color sample from the playing field to have fun with and set as an invisible color
    private final static Color invisible = new Color(70, 77, 106);
    
    // a static reference to a oneVone bot
    private static OneVOneBot oneVone;
    // a static reference to a melee bot
    private static MeleeBot melee;
    // a static reference set to either the melee or oneVone bot that is "me"
    private static specializedRobot me;
    
    public void run()
    {
        // only do this if the round number is 0
        if(getRoundNum() == 0)
        {
            // set our colors
            setColors( Color.black, Color.green, Color.red, Color.green, Color.red );
            setBulletColor(invisible);
            oneVone = new OneVOneBot(this);
            melee = new MeleeBot(this);
        }
        // check how many other robots there are and then set me to either the melee or oneVone
        me = getOthers() > 1 ? melee : oneVone;
        
        // prints out the toString method of me, our robot
        System.out.println(me);
        // the abstract class specialized run method that we call 
        me.run();
    }
    
    /**
     * passes the ScannedRobot Event to the specializedRobot abstract class 
     */
    public void onScannedRobot(robocode.ScannedRobotEvent e) 
    {
        me.onScannedRobot(e);
    }

    /**
     * passes the HitByBullet Event to the specializedRobot abstract class 
     */
    public void onHitByBullet(robocode.HitByBulletEvent e) 
    {
        me.onHitByBullet(e);
    }
    
    /**
     * passes the HitRobotEvent Event to the specializedRobot abstract class 
     */
    public void onHitRobot(robocode.HitRobotEvent e) 
    {
        me.onHitRobot(e);
    }

    /**
     * passes the HitWallEvent Event to the specializedRobot abstract class 
     */
    public void onHitWall(robocode.HitWallEvent e) 
    {
        me.onHitWall(e);
    }

    /**
     * passes the WinEvent Event to the specializedRobot abstract class 
     */
    public void onWin(robocode.WinEvent e) 
    {
        me.onWin(e);
    }

    /**
     * passes the DeathEvent Event to the specializedRobot abstract class 
     */
    public void onDeath(robocode.DeathEvent e) 
    {
        me.onDeath(e);
    }

    /**
     * passes the BulletHitEvent Event to the specializedRobot abstract class 
     */
    public void onBulletHit(robocode.BulletHitEvent e) 
    {
        me.onBulletHit(e);
    }

    /**
     * passes the BulletMissedEvent Event to the specializedRobot abstract class 
     */
    public void onBulletMissed(robocode.BulletMissedEvent e)
    {
        me.onBulletMissed(e);
    }

    /**
     * passes the BulletHitBulletEvent Event to the specializedRobot abstract class 
     */
    public void onBulletHitBullet(robocode.BulletHitBulletEvent e) 
    {
        me.onBulletHitBullet(e);
    }

    /**
     * passes the CustomEvent Event to the specializedRobot abstract
     */
    public void onCustomEvent(robocode.CustomEvent e) 
    {
        me.onCustomEvent(e);
    }

    /**
     * Passes the onPaint method to the specialized robot abstract class 
     * 
     */
    public void onPaint(java.awt.Graphics2D g) 
    {
        me.onPaint(g);
    }
    
    /**
     * passes the ScannedRobot Event to the specializedRobot abstract class 
     */
    public void onRobotDeath(RobotDeathEvent e)
    {
        // it calls the robotDeathEvent for the specialized robot because 
        // GFT and wavesurfing need to handle this
        // event individually
        me.onRobotDeath(e);
        //on each robot death it checks how many robots there are 
        //in order to check if we want to switch from melee strategy
        //to 1v1 strategy
        if(getOthers() == 1)
        {
            //it sets the max velocity to 8 because in melee it varies
            //the maximum velocity 
        	setMaxVelocity(8);
            me = oneVone;//sets me, our robot, to switch to 1v1 strategy
        }
    }
}
