package jwst.Enemies;

import robocode.*;
import java.awt.geom.Point2D;
/**
 * This class helps us track information about the enemy including the enemies bearing, 
 * distance from us, energy, heading, velocity and the "absolute bearing" which is a the 
 * closest angle from us. It also gives us its location in a Point 2D. 
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * 
 * Credit: Mr. Peck
 *
 */
public class Enemy
{
	/**
	 * enemy's bearing
	 */
    public double bearing;
    
    /**
     * enemy's distance
     */
    public double distance;
    
    /**
     * enemy's energy
     */
    public double energy;
    
    /**
     * enemy's heading
     */
    public double heading; 
    
    /**
     * enemy's velocity
     */
    public double velocity; 
    
    /**
     * enemy's absBearing
     */
    public double absBearing;
    
    /**
     * enemy's x
     */
    public double x;
    
    /**
     * enemy's y
     */
    public double y;
    
    /**
     * enemy's location
     */
    public Point2D.Double location;
    
    /**
     * enemy's name
     */
    public String name;
    
    /**
     * A blank enemy constructor in which the enemy is automatically reset
     */
    public Enemy()
    {
        reset();
    }

    /*
     * The following methods get information from the enemy robot and updates the information 
     * after every turn.
     */
    
    /**
     * @return bearing
     */
    public double getBearingRadians()
    {
        return bearing;
    }
    
    /**
     * @return distance
     */
    public double getDistance()
    {
        return distance;
    }
    
    /**
     * @return energy
     */
    public double getEnergy()
    {
        return energy;
    }
    
    /**
     * @return heading in radians
     */
    public double getHeadingRadians()
    {
        return heading;
    }
    
    /**
     * @return velocity
     */
    public double getVelocity()
    {
        return velocity;
    }
    
    /**
     * @return absBearing
     */
    public double getAbsBearing()
    {
        return absBearing;
    }
    
    /**
     * @return name
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * @return x
     */
    public double getX()
    {
        return x;
    }

    /**
     * @return y
     */
    public double getY()
    {
        return y;
    }
    
    /**
     * @return location
     */
    public Point2D.Double getLocation()
    {
        return location;
    }

    /**
     * This updates our knowledge of the enemy's bearing, distance, energy
     * heading, velocity, name, absolute bearing, x and y coordinates and 
     * location
     * 
     * @param e - the ScannedRobot Event
     * @param robot - the Advanced robot that uses this enemy class's method
     */
    public void update( ScannedRobotEvent e, AdvancedRobot robot )
    {
        bearing = e.getBearingRadians();
        distance = e.getDistance();
        energy = e.getEnergy();
        heading = e.getHeadingRadians();
        velocity = e.getVelocity();
        name = e.getName();
        absBearing = robot.getHeadingRadians() + bearing;
        x = robot.getX() + Math.sin(absBearing) * e.getDistance();
        y = robot.getY() + Math.cos(absBearing) * e.getDistance();
        location.setLocation(x,y);
    }

    /**
     * it resets all the values at the beginning, when the enemy is first initiated
     */
    public void reset()
    {
        bearing = 0.0;
        distance = 0.0;
        energy = 0.0;
        heading = 0.0;
        velocity = 0.0;
        name = "";
        x = 0.0;
        y = 0.0;
        location = new Point2D.Double();
    }

}