package suh.util;

import robocode.*;
import suh.movement.Movement;
import suh.radar.Radar;
import suh.targeting.Targeting;

public abstract class BaseRobot<R extends Radar, T extends Targeting, M extends Movement> extends AdvancedRobot {
    public R radar;
    public T targeting;
    public M movement;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	init();
	radar.init();
	targeting.init();
	movement.init();
	while(true) {
	    radar.run();
	    targeting.run();
	    movement.run();
	    execute();
	}
    }
    
    public abstract void init();
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	radar.onScannedRobot(e);
	targeting.onScannedRobot(e);
	movement.onScannedRobot(e);
    }
    
    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
	radar.onSkippedTurn(e);
    }
}
