package rh.abs;
import robocode.*;
import robocode.util.Utils;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.HashMap;
import java.util.Arrays;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.geom.Ellipse2D;

/**
 * Gun - a class by Damij
 */
public final class Gun  
{

	private final AdvancedRobot tank;
	
	private final HashMap<String, double[]> memory;
	
	private final RoundRectangle2D.Double arena;
	
	private final List<Wave> _waves;
	private final List<Future> _futures;
		
	private final Point2D.Double enemyPos, nextFront, nextBack, pos;
	
	private final double WALL_STICK = 120d, MAX_DIST;

	private final int BINS = 75;
	
	private String eState;
	
	private double absBearing, targetWidth, targetX, targetY, targetDist,
		bPower, lastVelocity, velocity, latDir, latHeading, turnAmount, lastHeading,
		heading, direction, bearing;
	
	private long lastScan, timeOfScan, scanDelta, tos;
	
	private int targetBinWidth;
	
	public Gun(final AdvancedRobot tank) {
		this.tank = tank;
		this.memory = new HashMap<>();
		this._waves = new LinkedList<>();
		this._futures = new LinkedList<>();
		this.enemyPos = new Point2D.Double(0,0);
		this.nextFront = new Point2D.Double(0,0);
		this.nextBack = new Point2D.Double(0,0);
		this.pos = new Point2D.Double(0,0);
		
		arena = new RoundRectangle2D.Double(
			18, 18, tank.getBattleFieldWidth() - 36, tank.getBattleFieldHeight() - 36,
			0, 0
		);

		MAX_DIST = Math.sqrt(tank.getBattleFieldWidth()
			*tank.getBattleFieldWidth() + tank.getBattleFieldHeight()
			*tank.getBattleFieldHeight());
			
		targetBinWidth = 2;	
	}

	public Bullet update(final ScannedRobotEvent e, final double absBearing) {

		pos.x = tank.getX();
		pos.y = tank.getY();	

		lastScan = Math.min(tank.getTime(), timeOfScan);
		timeOfScan = tank.getTime();
		scanDelta = timeOfScan - lastScan;
		lastVelocity = velocity;
		velocity = e.getVelocity();
		lastHeading = heading;
		heading = e.getHeadingRadians();
		bearing = e.getBearingRadians();
		this.absBearing = absBearing;
		this.targetDist = e.getDistance();
		

		this.turnAmount = Math.abs(Utils.normalRelativeAngle(heading-lastHeading))
			/ (20d * scanDelta);
		
		latHeading = Utils.normalRelativeAngle(e.getHeadingRadians() - (Math.PI/2d - absBearing));
		
		targetX = Math.sin(absBearing) * targetDist + tank.getX();
		targetY = Math.cos(absBearing) * targetDist + tank.getY();
		
		enemyPos.x = targetX;
		enemyPos.y = targetY;
		
		direction = velocity == 0 ? direction :
			sign(velocity);
		
		latDir = velocity == 0 ? latDir :
			sign(Utils.normalRelativeAngle(
				e.getHeadingRadians() - absBearing
			) * velocity);

		final Iterator<Wave> witt = _waves.iterator();
		
		while(witt.hasNext()) {
			final Wave w = witt.next();
			w.advance((int)scanDelta);
			if(w.broke(enemyPos.distance(w.source()))) {
				storeWave(w);
				witt.remove();
			}
		}
		
		if(tos == tank.getTime() && tank.getGunTurnRemaining() == 0 && tank.getGunHeat() == 0 && bPower < tank.getEnergy()) {
			final Wave newWave;
			_waves.add(newWave = new Wave(tank.getX(), tank.getY(),
				Rules.getBulletSpeed(bPower),
					targetX, targetY,
						eState, latDir)
			);
			final Point2D.Double[] nexts
				= getMaxPos(newWave);
		
			final double backOffset = newWave.calcOffset(nexts[0]);
			final double frontOffset = newWave.calcOffset(nexts[1]);
		
			if(latDir < 0)
			{
				newWave.trySetMAEFB(new double[]{backOffset,frontOffset});
			} else {
				newWave.trySetMAEFB(new double[]{frontOffset,backOffset});
			}
			newWave.trySetMAE(Math.max(backOffset,frontOffset));
			
			/*final double aPB  = newWave.mAE() / (double)((BINS-1)/2);
			final double aPT = Math.asin(36d/newWave.source().distance(enemyPos));
			final int binWidth = (int)Math.ceil(aPT/aPB);*/

			return tank.setFireBullet(bPower);
		}
		
		eState = velocity - lastVelocity == 0 ? "a"
			: sign(velocity) * (velocity - lastVelocity) < 0 ? "b" : "c";
	
		eState += "abcd".charAt((int)Math.min(Math.abs(velocity) / 8d * 4d, 3));
		
		eState += "abcd".charAt((int)Math.min(targetDist / MAX_DIST * 4d, 3));
		
		eState += "abcd".charAt((int)Math.min((latHeading/Math.PI+1d)/2d * 4d, 3));
		
		eState += "abcd".charAt((int)Math.min(turnAmount * 400d, 3));
		
		//System.out.println(turnAmount*700d);

		bPower = calcBPower(e.getEnergy());
		
		
		targetWidth = Math.asin(20d/e.getDistance());
		
		//if(tank.getGunTurnRemainingRadians() <= targetWidth 
		//	&& tank.getGunHeat() == 0 && bPower < tank.getEnergy())
		//{
			tos = tank.getTime() + 1;
		//}
		
		tank.setTurnGunRightRadians(
			getDesiredGunTurn(getTargetAngle(eState))
		);

		return null;
	}
	
	public final void storeWave(final Wave toStore) {
		final double myDist[] = new double[BINS];
		final int myBin = toStore.calcBin(enemyPos, BINS);
		
		final double aPB  = toStore.mAE() / (double)((BINS-1)/2);
		final double aPT = Math.asin(36d/toStore.source().distance(enemyPos));
		final int binWidth = (int)Math.ceil(aPT/aPB);
		
		for(int i = 0; i < BINS; i ++) {
			//myDist[i] = 1d/((i-myBin)*(i-myBin)+1d);
			//myDist[i] = Math.min(1d, 5d*Math.exp(-(i-myBin)*(i-myBin)/(2d*(binWidth/4d)*(binWidth/4d))));
			myDist[i] = Math.exp(-(i-myBin)*(i-myBin)/(2d*(binWidth/4d)*(binWidth/4d)));
		}
		
		//System.out.println("BinWidth: " + binWidth);
		//System.out.println(Arrays.toString(myDist));

		final String wState = toStore.state();
		for(int a = 0; a <= wState.length(); a ++) {
			final String c = wState.substring(0,a);
			double[] dist = memory.get(c);
			if(dist == null) {
				dist = new double[BINS];
			}
			for(int i = 0; i < BINS; i ++) {
				dist[i] += myDist[i];
			}
			memory.put(c, dist);
		}
	}
	
	private double calcBPower(final double energy) {
		double bP;
		if(energy > 16) {
			bP = Math.max(1.7, (1d-targetDist/MAX_DIST) * 3d);
		} else if(energy > 4) {
			bP = Math.min(1.9d,(energy+2d)/6d);
		} else {
			bP = energy/4d;
		}
		
		if(tank.getEnergy()<=bP) {
			bP = Math.max(0.1d, energy-0.1d);
		}
		return bP;
	}
	
	private double getTargetAngle(final String state) {
		//System.out.println("State: " + state);
		String key = null;
		for(int i = 0; i < state.length(); i ++) {
			key = state.substring(0,state.length()-i);
			if(memory.get(key)!=null) {
				break;
			}
		}
		if(memory.get(key) == null) {
			return absBearing;
		}

			final Wave newWave = new Wave(tank.getX(), tank.getY(),
				Rules.getBulletSpeed(bPower),
					targetX, targetY,
						eState, latDir);

			final Point2D.Double[] nexts
				= getMaxPos(newWave);
		
			final double reverseOffset = newWave.calcOffset(nexts[0]);
			final double continueOffset = newWave.calcOffset(nexts[1]);
			
		newWave.trySetMAE(Math.max(reverseOffset, continueOffset));
		
		final double aPB  = Math.max(reverseOffset, continueOffset) / (double)((BINS-1)/2);
		final double aPT = Math.asin(36d/pos.distance(enemyPos));
		final int binWidth = (int)Math.ceil(aPT/aPB);

		final double[] targetHeat = memory.get(key);
		double maxVal = Double.NEGATIVE_INFINITY;
		int maxBin = -1;
		for(int i = binWidth/2; i < targetHeat.length - binWidth/2; i ++) {
			double localHeat = 0d;
			for(int b = -binWidth/2; b < binWidth/2; b ++) {
				localHeat += targetHeat[i+b];
			}
			if(localHeat>maxVal) {
				maxVal = localHeat;
				maxBin = i;
			}
		}
		//System.out.println("key: " + key);	
		//System.out.println("Aiming at: " + maxBin);
		return angleFromBin(maxBin, newWave.mAE());
	}

	private double getDesiredGunTurn(final double desiredAngle) {
		return Utils.normalRelativeAngle(
			desiredAngle - tank.getGunHeadingRadians()
		);
	}
	
	private double sign(final double value) {
		return value >= 0 ? 1d : -1d;
	}
	
	private double angleFromBin(final int bin, final double mAE) {
		final double mEA = mAE;//Math.asin(8d/Rules.getBulletSpeed(bPower));
		final int midbin = (BINS+1)/2;
		return (bin-midbin) / (double) midbin * mEA * latDir + absBearing;
	}
	
	public void endRound() {
		_waves.clear();
	}

	public void handlePaint(final Graphics2D g) {
		g.setColor(Color.CYAN);
		for(final Future fut : _futures) {
			g.setColor(fut.dir() < 0 ? Color.RED : Color.GREEN);
			g.draw(
				new Ellipse2D.Double(
					fut.x-3,
					fut.y-.5d,
					6,
					1
				)
			);
		}
	}
	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	
	private double wallSmooth(final Point2D.Double posi,
		double heading, final double dir)
	{
		while(
			!arena.contains(
				project(posi,heading,WALL_STICK)
			)
		) {
			heading += 0.01d * dir;
		}
		return heading;
	}
	
	private Point2D.Double project(final Point2D.Double pos,
		final double heading, final double dist)
	{
		return  new Point2D.Double(
			pos.x + Math.sin(heading) * dist,
			pos.y + Math.cos(heading) * dist
		);
	}
	
	private double limit(final double low, final double mid, final double high) {
		return Math.min(high,Math.max(low,mid));
	}


	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	
	private Point2D.Double[] getMaxPos(final Wave w) {
		final double escAngleBonus  = 0d;
		final double bareing = Math.atan2(enemyPos.x - w.source().x, enemyPos.y-w.source().y);
		_futures.clear();
		if(Math.abs(velocity) <= 2d) {
			_futures.add(new Future(enemyPos.x,enemyPos.y, 0));
		}
		for(double dir = -1d; dir <= 1d; dir += 2d) {
			Point2D.Double future =
				(Point2D.Double) enemyPos.clone();
			double futureVelocity = velocity;
			double runningDir = direction;
			double runningLatDir = latDir;
			double futureHeading = bareing - (Math.PI / 2d) * sign(bearing);
			futureHeading += dir*direction < 0d ? Math.PI : 0d;
			for(int futures = 1; !w.broke(future.distance(w.source()), futures); futures ++) {
				futureVelocity += dir*runningDir > 0 ? dir : 2d*dir;
				futureVelocity = limit(-8d, futureVelocity, 8d);
				runningDir = futureVelocity == 0d ? runningDir : sign(futureVelocity);
				runningLatDir = runningDir*sign(bearing);
				futureHeading = wallSmooth(future, futureHeading, sign(Utils.normalRelativeAngle(
				futureHeading - absBearing
			)));
				
				future = project(future, futureHeading, Math.abs(futureVelocity));
				_futures.add(new Future(future.x,future.y, dir));
			}
			if(dir == -1d) {
				nextBack.x = future.x;
				nextBack.y = future.y;
			} else {
				nextFront.x = future.x;
				nextFront.y = future.y;
			}
		}
		
		return new Point2D.Double[] {nextBack, nextFront};
	}
	
	private class Future extends Point2D.Double {
		private final double dir;
		Future(final double x, final double y, final double dir) {
			super(x,y);
			this.dir = dir;
		}
		double dir() {
			return dir;
		}
	}

}
