package rh.abs;
import robocode.*;
import robocode.util.Utils;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.HashMap;
import java.awt.geom.Point2D;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.Color;

/**
 * Surf - a class by Damij
 */
public final class Surf
{

	private final AdvancedRobot tank;
	
	private final HashMap<String, double[]> memory;
	
	private final RoundRectangle2D.Double arena;

	private final List<Bullet> _bullets;
	private final List<Wave> _waves;
	private final List<Future> futures;
	
	private final Point2D.Double ePos, pos, nextFront, nextBack, lastEPos;
	
	private final double MAX_DIST, WALL_STICK = 120d;
	
	private final int BINS = 35;
	
	private String state;
	
	private Point2D.Double[] posHist = new Point2D.Double[2];
	
	private String[] stateHist = new String[3];
	
	private double[] dirHistory = new double[2];
	
	private double eEnergy, lastEEnergy, eVelocity,
		lastEVelocity, targetDist, targetX, targetY,
		latDirection, direction, velocity, lastVelocity,
		heading, lastHeading, turnAmount, absBearing,
		eBearing, lastShotPower;
		
	private long scanTime, lastScan, deltaScan;

	public Surf(final AdvancedRobot tank) {
		this.tank = tank;
		
		memory = new HashMap<>();
		
		_bullets = new LinkedList<>();
		_waves = new LinkedList<>();
		futures = new LinkedList<>();
		
		ePos = new Point2D.Double(0,0);
		pos = new Point2D.Double(tank.getX(),tank.getY());
		nextFront = new Point2D.Double(pos.x,pos.y);
		nextBack = new Point2D.Double(pos.x,pos.y);
		lastEPos = new Point2D.Double(0,0);
		
		for(int i = 0; i < posHist.length; i ++) {
			posHist[i] = new Point2D.Double();
		}

		eEnergy = 100d;

		MAX_DIST = Math.sqrt(tank.getBattleFieldWidth()
			*tank.getBattleFieldWidth() + tank.getBattleFieldHeight()
			*tank.getBattleFieldHeight());
			
		arena = new RoundRectangle2D.Double(
			36, 36, tank.getBattleFieldWidth() - 72, tank.getBattleFieldHeight() - 72,
			72, 72
		);
		
		direction = 1;
	}
	
	public void update(final Bullet b,
			final ScannedRobotEvent e,
				final double absBearing
	) {
		
		if(b != null) {
			_bullets.add(b);
		}
		
		this.absBearing = absBearing;
		this.eBearing = e.getBearingRadians();
		
		targetDist = e.getDistance();
		
		dirHistory[1] = dirHistory[0];
		dirHistory[0] = latDirection;		

		direction = tank.getVelocity() == 0 ?
			direction : sign(tank.getVelocity());
		latDirection = sign(direction * eBearing);
		
		targetX = Math.sin(absBearing) * targetDist + tank.getX();
		targetY = Math.cos(absBearing) * targetDist + tank.getY();
		
		lastEPos.x = ePos.x;
		lastEPos.y = ePos.y;

		ePos.x = targetX;
		ePos.y = targetY;
		
		posHist[1].x = posHist[0].x;
		posHist[1].y = posHist[0].y;
		
		posHist[0].x = pos.x;
		posHist[0].y = pos.y;
		
		pos.x = tank.getX();
		pos.y = tank.getY();
		
		lastEEnergy = eEnergy;
		eEnergy = e.getEnergy();
		final double energyDelta = lastEEnergy - eEnergy;
		
		lastEVelocity = eVelocity;
		eVelocity = e.getVelocity();
		
		lastScan = scanTime;
		scanTime = tank.getTime();
		deltaScan = scanTime - lastScan;
		
		lastVelocity = velocity;
		velocity = tank.getVelocity();
		
		lastHeading = heading;
		heading = tank.getHeadingRadians();
		turnAmount = Math.abs(Utils.normalRelativeAngle(heading-lastHeading))
			/ (20d * deltaScan);
		

		lastShotPower = limit(0,energyDelta,3);
		//System.out.println(turnAmount*800);
		
		state = "";

		state += velocity - lastVelocity == 0 ? "a"
			: sign(velocity) * (velocity - lastVelocity) < 0 ? "b" : "c";
			
		state += "abcdefgh".charAt((int)Math.min(Math.abs(velocity) / 8d * 8d, 7));
		
		state += "abcdefghijklm".charAt((int)Math.min(lastShotPower / 3d * 13d, 12d));
		
		state += "abcdefghijkl".charAt((int)Math.min(targetDist / MAX_DIST * 12d, 11));
		
		state += "abcdefghijklmnop".charAt((int)Math.min(turnAmount * 1600d, 15));
		
		state += "abcdefghijklmnop".charAt((int)Math.min((eBearing/Math.PI+1d)/2d*16d,15));
		
		stateHist[2] = stateHist[1];
		stateHist[1] = stateHist[0];
		stateHist[0] = state;
		

		
		
		if(Math.abs(eVelocity-lastEVelocity)/deltaScan <= 2
			&& energyDelta <= 3.0d && energyDelta > 0d)
		{
			final Wave newWave;
			_waves.add(newWave = new Wave(lastEPos.x, lastEPos.y,
				Rules.getBulletSpeed(energyDelta),
					posHist[1].x, posHist[1].y,
						stateHist[2], dirHistory[1])
			);
			
			final Point2D.Double[] nexts
				= getMaxPos(newWave);
		
			final double backOffset = newWave.calcOffset(nexts[0]);
			final double frontOffset = newWave.calcOffset(nexts[1]);
		
			if((int)sign(eBearing) == 1) {
				newWave.trySetMAEFB(new double[]{frontOffset,backOffset});
			} else {
				newWave.trySetMAEFB(new double[]{backOffset,frontOffset});
			}
			newWave.trySetMAE(Math.max(backOffset,frontOffset));
		}
		
		final Iterator<Wave> witt = _waves.iterator();
		
		while(witt.hasNext()) {
			final Wave w = witt.next();
			w.advance((int)deltaScan);
			if(w.broke(targetDist+w.velocity())) {
			//	if(!w.stored()) {
			//		storeWave(w, pos);
			//		w.setStored();
			//	}
				witt.remove();
			}
		}
		
		final Wave surfWave = getCurrentSurfWave();
		final Wave secondWave = getSecondWave(surfWave);
		
		if(surfWave!=null) {
			surf(surfWave, secondWave);
			//surfBetter(surfWave);
		} else {
			emptySurf();
		}

	}

	public void onPaint(final Graphics2D g) {
		g.setColor(Color.WHITE);
		g.draw(
			new Ellipse2D.Double(
				tank.getX() - 10,
				tank.getY() - 10,
				20,
				20
			)
		);
		for(final Wave w : _waves) {
			g.setColor(Color.ORANGE.darker());
			g.draw(
				new Ellipse2D.Double(
					w.source().x - w.distTravelled,
					w.source().y - w.distTravelled,
					w.distTravelled * 2,
					w.distTravelled * 2
				)
			);
		}
		//g.setColor(Color.RED.brighter().brighter());
		for(final Future fut : futures) {
			g.setColor(new Color(255, 127 + 127 * (int) fut.dir(), 255));
			g.draw(
				new Ellipse2D.Double(
					fut.x - 3,
					fut.y - 3,
					6,
					6
				)
			);
		}
		g.setColor(Color.GREEN);
		g.draw(
			new Ellipse2D.Double(
				nextFront.x - 3,
				nextFront.y - 3,
				6,
				6
			)
		);
		g.setColor(Color.YELLOW);
		g.draw(
			new Ellipse2D.Double(
				nextBack.x - 3,
				nextBack.y - 3,
				6,
				6
			)
		);
		g.setColor(Color.RED.brighter());
		g.draw(
			arena
		);
	}
	
	public void handleHit(final HitByBulletEvent e) {
		Wave hitWave = null;
		//WHY DID I WRITE IT THIS POORLY? ASK YOURSELF...
		final Point2D.Double position = 
			new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
		final double speed = Rules.getBulletSpeed(e.getBullet().getPower());
		//
		for(final Wave potential : _waves) {
			//System.out.println(potential.velocity() + " " + speed + " vel comp");
			//System.out.println("Dist diff: " +Math.abs(position.distance(potential.source()) - potential.velocity() - potential.distTravelled()));
			//System.out.println("? " + (Math.abs(position.distance(potential.source()) - potential.velocity() - potential.distTravelled()) < potential.velocity));
			if(Math.abs(potential.velocity() - speed) < 0.3d
				&& Math.abs(position.distance(potential.source()) - potential.velocity() - potential.distTravelled()) < potential.velocity) {
					hitWave = potential;
					break;
			}
		}
		if(hitWave != null) {
			storeWave(hitWave, position);
			_waves.remove(hitWave);
		} else {
			System.out.println("Dropped Wave");
		}
	}
	
	public void handleBulletHitBullet(final BulletHitBulletEvent e) {
		Wave hitWave = null;
		//WHY DID I WRITE IT THIS POORLY? ASK YOURSELF...
		final Point2D.Double position = 
			new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
		final double speed = Rules.getBulletSpeed(e.getHitBullet().getPower());
		//
		for(final Wave potential : _waves) {
			System.out.println(potential.velocity() + " " + speed + " vel comp");
			System.out.println("Dist diff: " + Math.abs(position.distance(potential.source()) - potential.velocity() - potential.distTravelled()));
			if(Math.abs(potential.velocity() - speed) < 0.3d
				&& position.distance(potential.source()) - potential.velocity() - potential.distTravelled() < potential.velocity) {
					hitWave = potential;
					break;
			}
		}
		if(hitWave != null) {
			storeWave(hitWave, position);
			_waves.remove(hitWave);
		} else {
			System.out.println("Dropped BulletHitBullet Wave");
		}
	}
	
	private void storeWave(final Wave toStore, final Point2D.Double spot) {
		final double myDist[] = new double[BINS];
		final int myBin =
			toStore.calcBinFB(
				spot,
				BINS
			);
			
		final double aPB  = toStore.mAE() / (double)((BINS-1)/2);
		final double aPT = Math.asin(36d/toStore.source().distance(spot));
		final int binWidth = (int)Math.ceil(aPT/aPB);
		//System.out.println("Bin Width on hit: " + binWidth);
		
		for(int i = 0; i < BINS; i ++) {
			//myDist[i] = 1d/((i-myBin)*(i-myBin)+1d);
			myDist[i] = Math.exp(-(i-myBin)*(i-myBin)/(2d*(binWidth/4d)*(binWidth/4d)));
		}

		final String wState = toStore.state();
		for(int a = 0; a <= wState.length(); a ++) {
			final String c = wState.substring(0,a);
			double[] dist = memory.get(c);
			if(dist == null) {
				dist = new double[BINS];
			}
			for(int i = 0; i < BINS; i ++) {
				dist[i] += myDist[i];
			}
			memory.put(c, dist);
		}
	}
	
	private String getCurrentKey(final Wave w) {
		String key = "";
		final String currState = w.state();
		for(int i = 0; i < currState.length(); i ++) {
			key = currState.substring(0,currState.length()-i);
			if(memory.get(key)!=null) {
				break;
			}
		}
		return key;
	}
	
	private Wave getCurrentSurfWave() {
		Wave toSurf = null;
		double hitTime = Double.POSITIVE_INFINITY;
		for(final Wave w : _waves) {
			if(w.timeTillHit(pos) < hitTime && w.timeTillHit(pos) > 1) {
				hitTime = w.timeTillHit(pos);
				toSurf = w;
			}
		}
		return toSurf;
	}
	
	private Wave getSecondWave(final Wave ref) {
		Wave toSurf = null;
		double hitTime = Double.POSITIVE_INFINITY;
		for(final Wave w : _waves) {
			if(!w.equals(ref) && w.timeTillHit(pos) < hitTime && w.timeTillHit(pos) > 0) {
				hitTime = w.timeTillHit(pos);
				toSurf = w;
			}
		}
		return toSurf;
	}
	
	private double sign(final double value) {
		return value >= 0 ? 1d : -1d;
	}
	
	private double limit(final double low, final double mid, final double high) {
		return Math.min(high,Math.max(low,mid));
	}
	
	public void endRound() {
		eEnergy = 100d;
		eVelocity = 0d;
		scanTime = 0l;
		velocity = 0d;
		
		_bullets.clear();
		_waves.clear();
		futures.clear();
	}
	
	private double wallSmooth(final Point2D.Double pos,
		double heading, final double dir)
	{
		while(
			!arena.contains(
				project(pos,heading,WALL_STICK)
			)
		) {
			heading += 0.01d * dir;
		}
		return heading;
	}
	
	private Point2D.Double project(final Point2D.Double pos,
		final double heading, final double dist)
	{
		return  new Point2D.Double(
			pos.x + Math.sin(heading) * dist,
			pos.y + Math.cos(heading) * dist
		);
	}
	
	private void driveTo(final Point2D.Double dest) {
		final double angle = Math.atan2(
			dest.x - pos.x, dest.y - pos.y);
		final double dist = dest.distance(pos);
		double angleTo = 
				Utils.normalRelativeAngle(angle-heading);
			
		int goDir = 1;	
		if(angleTo > Math.PI/2d || angleTo < -Math.PI/2d) {
			goDir = -1;
			angleTo += Math.PI;
		}		

		if(Double.compare(dist-2d,0)>0) {
			tank.setTurnRightRadians(
				Utils.normalRelativeAngle(angleTo)
			);
		}
		tank.setAhead(100d*goDir);
	}
	
	/////////////////////////////////////////////////////
	/////////////////////////////////////////////////////
	/////////////////////////////////////////////////////
	/////////////////////////////////////////////////////
	/////////////////////////////////////////////////////
	
	private void surfBetter(final Wave w) {
		tank.setMaxVelocity(8);
		final String key = getCurrentKey(w);
		
		if(Math.abs(velocity) <= 2) {
			futures.add(new Future(pos.x,pos.y, 0d));
		}
		
		final double escAngleBonus = 0d;
		final double bareing = Math.atan2(w.source().x-pos.x,w.source().y-pos.y);
		final double futureHeading = bareing - (Math.PI / 2d + escAngleBonus) * sign(eBearing);

		final double[] dangerScape = memory.get(key);
		final double aPB  = w.mAE() / (double)((BINS-1)/2);
		final double aPT = Math.asin(36d/w.source().distance(pos));
		final int binWidth = (int)Math.ceil(aPT/aPB);
		//System.out.println("Bin Width: " + binWidth);
		
		final Point2D.Double[] extremes = getMaxPos(w);
		final int backBin = w.calcBin(extremes[0], BINS);
		final int frontBin = w.calcBin(extremes[1], BINS);
		
		double goDir = 1d;
			//if(Math.abs(currBin-minBin) < binWidth / 2) {
				double headingCorrection = sign(eBearing)*w.dir() > 0 ? 0 : Math.PI;
				double nextHeading = wallSmooth(pos, futureHeading+headingCorrection, latDirection);
				double turnAmount = Utils.normalRelativeAngle(nextHeading - heading);
				if(turnAmount > Math.PI/2 || turnAmount < -Math.PI/2) {
					goDir = -1;
					turnAmount += Math.PI;
				}
				tank.setTurnRightRadians(Utils.normalRelativeAngle(turnAmount));

		if(dangerScape != null) {
			double minDanger = Double.POSITIVE_INFINITY;
			int minBin = -1;
			for(int i = Math.max(binWidth/2, Math.min(backBin,frontBin)); i < Math.min(BINS - binWidth/2, Math.max(backBin,frontBin)); i ++) {
				double dangerSum = 0d;
				for(int wid = -binWidth/2; wid < binWidth/2; wid ++) {
					dangerSum += dangerScape[i+wid];
				}
				if(dangerSum < minDanger) {
					minDanger = dangerSum;
					minBin = i;
				}
			}

			int currBin = w.calcBin(pos, BINS);
	
			System.out.println("BinDiff: " + (currBin-minBin));
			
			
				tank.setAhead(100d*(minBin-currBin)*w.dir());
			/*}
			else {
				if((int)(w.dir()*latDirection) == 1) {
					if(currBin < minBin) {
						double headingCorrection = direction > 0 ? 0 : Math.PI;
						double nextHeading = wallSmooth(pos, futureHeading+headingCorrection, latDirection);
						double turnAmount = Utils.normalRelativeAngle(nextHeading - heading);
						if(turnAmount > Math.PI/2 || turnAmount < -Math.PI/2) {
							goDir = -1;
							turnAmount += Math.PI;
						}
						tank.setTurnRightRadians(Utils.normalRelativeAngle(turnAmount));
						tank.setAhead(100d*goDir);
					} else if(currBin > minBin) {
						double headingCorrection = direction > 0 ? Math.PI : 0;
						double nextHeading = wallSmooth(pos, futureHeading+headingCorrection, -latDirection);
						double turnAmount = Utils.normalRelativeAngle(nextHeading - heading);
						if(turnAmount > Math.PI/2 || turnAmount < -Math.PI/2) {
							goDir = -1;
							turnAmount += Math.PI;
						}
						tank.setTurnRightRadians(Utils.normalRelativeAngle(turnAmount));
						tank.setAhead(100d*goDir);
					}
				}
				else {
					if(currBin < minBin) {
						double headingCorrection = direction < 0 ? 0 : Math.PI;
						double nextHeading = wallSmooth(pos, futureHeading+headingCorrection, -latDirection);
						double turnAmount = Utils.normalRelativeAngle(nextHeading - heading);
						if(turnAmount > Math.PI/2 || turnAmount < -Math.PI/2) {
							goDir = -1;
							turnAmount += Math.PI;
						}
						tank.setTurnRightRadians(Utils.normalRelativeAngle(turnAmount));
						tank.setAhead(100d*goDir);
					} else if(currBin > minBin) {
						double headingCorrection = direction < 0 ? Math.PI : 0;
						double nextHeading = wallSmooth(pos, futureHeading+headingCorrection, latDirection);
						double turnAmount = Utils.normalRelativeAngle(nextHeading - heading);
						if(turnAmount > Math.PI/2 || turnAmount < -Math.PI/2) {
							goDir = -1;
							turnAmount += Math.PI;
						}
						tank.setTurnRightRadians(Utils.normalRelativeAngle(turnAmount));
						tank.setAhead(100d*goDir);
					}
				}
			}*/
		}		
		/*for(double dir = -1; dir <= 1d; dir += 2d) {
			Point2D.Double future =
				(Point2D.Double) pos.clone();
			double futureVelocity = velocity;
			double runningDir = direction;
			double runningLatDir = latDirection;
			double futureHeading = bareing - (Math.PI / 2d + escAngleBonus) * sign(eBearing);
			for(int futureCount = 1; futureCount < 100; futureCount  ++) {
			
			}
		}*/
	}
	
	private Point2D.Double[] getMaxPos(final Wave w) {
		final double escAngleBonus  = Math.toRadians(15);
		final double bareing = Math.atan2(w.source().x-pos.x,w.source().y-pos.y);
		for(double dir = -1d; dir <= 1d; dir += 2d) {
			Point2D.Double future =
				(Point2D.Double) pos.clone();
			double futureVelocity = velocity;
			double runningDir = direction;
			double runningLatDir = latDirection;
			double futureHeading = bareing - (Math.PI / 2d + escAngleBonus) * sign(eBearing);
			futureHeading += dir*direction < 0d ? (Math.PI + 2d*escAngleBonus)*sign(eBearing): 0d;
			for(int futures = 1; !w.broke(future.distance(w.source()), futures); futures ++) {
				futureVelocity += dir*runningDir > 0 ? dir : 2d*dir;
				futureVelocity = limit(-8d, futureVelocity, 8d);
				runningDir = futureVelocity == 0d ? runningDir : sign(futureVelocity);
				runningLatDir = runningDir*sign(eBearing);
				futureHeading = wallSmooth(future, futureHeading, latDirection*dir);
				
				future = project(future, futureHeading, Math.abs(futureVelocity));
			}
			if(dir == -1d) {
				nextBack.x = future.x;
				nextBack.y = future.y;
			} else {
				nextFront.x = future.x;
				nextFront.y = future.y;
			}
		}
		
		return new Point2D.Double[] {nextBack, nextFront};
	}
	
	private void surf(final Wave w, final Wave w2) {
		tank.setMaxVelocity(8d);
		final String key = getCurrentKey(w);
		final String key2 = w2 == null ? "" : getCurrentKey(w2);
		final Point2D.Double source = w.source();
		final List<Future> nexts = new LinkedList<>();
		futures.clear();
		if(Math.abs(velocity) <= 2) {
			nexts.add(new Future(pos.x,pos.y,0));
		}
		final double escAngleBonus  = Math.toRadians(10-0.75d*Math.abs(velocity))/2d;//0.232d;
		final double bareing = Math.atan2(w.source().x-pos.x,w.source().y-pos.y);
		for(double dir = -1d; dir <= 1d; dir += 2d) {
			Point2D.Double future =
				(Point2D.Double) pos.clone();
			double futureVelocity = velocity;
			double runningDir = direction;
			double runningLatDir = latDirection;
			double futureHeading = bareing - (Math.PI / 2d) * sign(eBearing) - escAngleBonus*sign(eBearing);
			futureHeading += dir*direction < 0d ? (Math.PI + 2d*escAngleBonus)*sign(eBearing) : 0d;
			for(int futures = 1; !w.broke(future.distance(w.source()), futures); futures ++) {
				futureVelocity += dir*runningDir > 0 ? dir : 2d*dir;
				futureVelocity = limit(-8d, futureVelocity, 8d);
				runningDir = futureVelocity == 0d ? runningDir : sign(futureVelocity);
				runningLatDir = runningDir*sign(eBearing);
				futureHeading = wallSmooth(future, futureHeading, latDirection*dir);
				
				future = project(future, futureHeading, Math.abs(futureVelocity));
				this.futures.add(new Future(future.x,future.y, dir));
				nexts.add(new Future(future.x, future.y, dir));
				
			}
			if(dir == -1d) {
				nextBack.x = future.x;
				nextBack.y = future.y;
			} else {
				nextFront.x = future.x;
				nextFront.y = future.y;
			}
		}
		
		double[] risk = memory.get(key);
		double[] risk2 = memory.get(key2);
		
		if(risk == null) {
			risk = memory.get("a");
		} if(risk2 == null) {
			risk = memory.get("a");
		}
		
		Future targetPos = null;
		if(risk != null) {
			final double aPB  = w.mAE() / (double)((BINS-1)/2);
			final double aPT = Math.asin(36d/w.source().distance(pos));
			final int binWidth = (int)Math.ceil(aPT/aPB);
			//System.out.println(key);
			double minDanger = Double.POSITIVE_INFINITY;
			for(final Future posi : nexts) {
				final int bin = w.calcBin(posi, BINS);
				final int bin2;
				if(w2!=null) {
					bin2 = w2.calcBin(posi, BINS);
				} else {
					bin2 = -1;
				}
				double localTotal = 0d;
				for(int b = bin-binWidth/2; b < bin+binWidth/2; b ++) {
					localTotal += risk[(int)Math.min(BINS-1,Math.max(0,b))];
				}
				if(bin2 >= 0 && risk2 != null) {
					for(int b = bin2-binWidth/2; b < bin2+binWidth/2; b ++) {
						localTotal += risk2[(int)Math.min(BINS-1,Math.max(0,b))] / 2d;
					}
				}
				if(localTotal < minDanger) {
					minDanger = localTotal;
					targetPos = posi;
				}
			}
		}
		
		if(targetPos != null) {
			driveTo(targetPos);
		} else {
			emptySurf();
		}
		
		/*futures.clear();
		if(targetPos != null) {
			double distanceToDest = targetPos.distance(pos);
			final double angleTo = Math.atan2(targetPos.x - pos.x, targetPos.y - pos.y);
			double runningVelo = velocity * w.dir() * targetPos.dir * latDirection * direction;
			int futureCount = 1;
			Point2D.Double runningPos = new Point2D.Double(pos.x,pos.y);
			while(distanceToDest > 0 && !w.broke(runningPos.distance(w.source()), futureCount)) {
				futureCount ++;
				//System.out.println("FutureCount: " + futureCount);
				//System.out.println("Velo: " + runningVelo);
				//System.out.println("DistanceToTest: " + distanceToDest);
				runningVelo = getNewVelocity(velocity, distanceToDest);
				runningPos = project(runningPos, angleTo, runningVelo);
				futures.add(new Point2D.Double(runningPos.x,runningPos.y));
				distanceToDest -= Math.abs(runningVelo) * sign(distanceToDest);
			}
			
			Point2D.Double goalPos = null;
			double minDanger = Double.POSITIVE_INFINITY;
			for(final Point2D.Double posi : futures) {
				final int b = w.calcBin(posi, BINS);
				if(risk[b] < minDanger) {
					minDanger = risk[b];
					goalPos = posi;
				}
			}
			if(goalPos != null) {
				driveTo(goalPos);
			}
			//driveTo(targetPos);
		}*/
		
		/*final int backBin = w.calcBin(nextBack, BINS);
		final int aheadBin = w.calcBin(nextFront, BINS);
		
		if(risk != null) {
			if(risk[backBin] < risk[aheadBin]) {
				driveTo(nextBack);
			} else {
				driveTo(nextFront);
			}
		} else {
			
		}*/
		
	}
	
	private void emptySurf() {
		final double escAngleBonus  = Math.toRadians(10-0.75d*Math.abs(velocity))/2d;
		final double desiredHeading;
		if(sign(eBearing) > 0) {
			desiredHeading
				= Utils.normalAbsoluteAngle(
					absBearing - (Math.PI/2d + escAngleBonus) * direction
				);
		} else {
			desiredHeading
				= Utils.normalAbsoluteAngle(
					absBearing + (Math.PI/2d + escAngleBonus) * direction
				);
		}
		
		final double aheadAngle = wallSmooth(pos, desiredHeading, latDirection);
		final double backAngle = wallSmooth(pos, desiredHeading + (Math.PI + 2d * escAngleBonus)* sign(eBearing) * direction, -latDirection);
		
		final boolean shouldReverse
			= project(pos, aheadAngle, WALL_STICK).distance(ePos) <
				project(pos, backAngle, WALL_STICK).distance(ePos);
	
		final double newHeading;
		if(shouldReverse) {
			newHeading = backAngle;
		} else {
			newHeading = aheadAngle;
		}		
		//final double newHeading = wallSmooth(pos, desiredHeading, latDirection);
		double angleDelta = Utils.normalRelativeAngle(newHeading - heading);
		
		double goDir = 1;
		if(angleDelta > Math.PI/2d || angleDelta < -Math.PI/2d) {
			goDir = -1d;
			angleDelta += Math.PI;
		}
		
		tank.setAhead(100d*goDir);
		double maxSpeed = 8d;
		for(int i = 8; i >= 0; i --) {
			maxSpeed = i;
			if(Rules.getTurnRateRadians(i)*2 > Math.abs(tank.getTurnRemainingRadians())) {
				break;
			} 
		}
		tank.setTurnRightRadians(Utils.normalRelativeAngle(angleDelta));
		tank.setMaxVelocity(maxSpeed);
	}
	
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	
	private class Future extends Point2D.Double {
		private final double dir;
		Future(final double x, final double y, final double dir) {
			super(x,y);
			this.dir = dir;
		}
		double dir() {
			return dir;
		}
	}
	
	private double getNewVelocity(double velocity, double distance) {
		// If the distance is negative, then change it to be positive and change the sign of the input velocity and the result
		if (distance < 0) {
			return -getNewVelocity(-velocity, -distance);
		}

		double newVelocity;

		// Get the speed, which is always positive (because it is a scalar)
		final double speed = Math.abs(velocity); 

		// Check if we are decelerating, i.e. if the velocity is negative.
		// Note that if the speed is too high due to a new max. velocity, we must also decelerate.
		if (velocity < 0 || speed > 8) {
			// If the velocity is negative, we are decelerating
			newVelocity = speed - Rules.DECELERATION;

			// Check if we are going from deceleration into acceleration
			if (newVelocity < 0) {
				// If we have decelerated to velocity = 0, then the remaining time must be used for acceleration
				double decelTime = speed / Rules.DECELERATION;
				double accelTime = (1 - decelTime);

				// New velocity (v) = d / t, where time = 1 (i.e. 1 turn). Hence, v = d / 1 => v = d
				// However, the new velocity must be limited by the max. velocity
				newVelocity = Math.min(8,
						Math.min(Rules.DECELERATION * decelTime + Rules.ACCELERATION * accelTime,
						distance));

				// Note: We change the sign here due to the sign check later when returning the result
				velocity *= -1;
			}
		} else {
			// Else, we are not decelerating, but might need to start doing so due to the remaining distance

			// Deceleration time (t) is calculated by: v = a * t => t = v / a
			final double decelTime = speed / Rules.DECELERATION;

			// Deceleration time (d) is calculated by: d = 1/2 a * t^2 + v0 * t + t
			// Adding the extra 't' (in the end) is special for Robocode, and v0 is the starting velocity = 0
			final double decelDist = 0.5 * Rules.DECELERATION * decelTime * decelTime + decelTime;

			// Check if we should start decelerating
			if (distance <= decelDist) {
				// If the distance < max. deceleration distance, we must decelerate so we hit a distance = 0

				// Calculate time left for deceleration to distance = 0
				double time = distance / (decelTime + 1); // 1 is added here due to the extra 't' for Robocode

				// New velocity (v) = a * t, i.e. deceleration * time, but not greater than the current speed

				if (time <= 1) {
					// When there is only one turn left (t <= 1), we set the speed to match the remaining distance
					newVelocity = Math.max(speed - Rules.DECELERATION, distance);
				} else {
					// New velocity (v) = a * t, i.e. deceleration * time
					newVelocity = time * Rules.DECELERATION;

					if (speed < newVelocity) {
						// If the speed is less that the new velocity we just calculated, then use the old speed instead
						newVelocity = speed;
					} else if (speed - newVelocity > Rules.DECELERATION) {
						// The deceleration must not exceed the max. deceleration.
						// Hence, we limit the velocity to the speed minus the max. deceleration.
						newVelocity = speed - Rules.DECELERATION;
					}
				}
			} else {
				// Else, we need to accelerate, but only to max. velocity
				newVelocity = Math.min(speed + Rules.ACCELERATION, 8);
			}
		}

		// Return the new velocity with the correct sign. We have been working with the speed, which is always positive
		return (velocity < 0) ? -newVelocity : newVelocity;
	}

}
