package rh.abs;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.Graphics2D;

/**
 * Xwing - a robot by Damij
 */
public class Xwing extends AdvancedRobot
{

	private static Gun weapon;
	private static Surf mov;
	
	private double absBearing;
	private long timeSinceScan;
	/**
	 * run: Xwing's default behavior
	 */
	public final void run() {
		setColors(new Color(224, 176, 255),new Color(255,176,224),new Color(255, 224, 176)); // body,gun,radar
		
		super.setAdjustRadarForGunTurn(true);
		super.setAdjustRadarForRobotTurn(true);
		super.setAdjustGunForRobotTurn(true);

		if(weapon == null) {
			weapon = new Gun(this);
		}
		if(mov == null) {
			mov = new Surf(this);
		}
		weapon.endRound();
		mov.endRound();
		
		timeSinceScan = 1000;
		// Robot main loop
		while(true) {
			if(timeSinceScan > 6) {
				setTurnRadarRight(360d);
			} else {
				
				final double radarOffset =
					Utils.normalRelativeAngle(
						super.getRadarHeadingRadians()
							- absBearing
					);
			
				super.setTurnRadarLeftRadians(
					2d*radarOffset
				);
			
			}
			timeSinceScan++;
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public final void onScannedRobot(final ScannedRobotEvent e) {
		absBearing =
			Utils.normalAbsoluteAngle(
				super.getHeadingRadians()
					+ e.getBearingRadians()
			);

		final Bullet b = 
			weapon.update(e, absBearing);
		
		mov.update(b, e, absBearing);
		
		timeSinceScan = 0l;
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public final void onHitByBullet(final HitByBulletEvent e) {
		mov.handleHit(e);
	}
	
	public final void onBulletHitBullet(final BulletHitBulletEvent e) {
		
	}
	
	public final void onRoundEnded(final RoundEndedEvent e) {
		
	}
	
	public final void onPaint(final Graphics2D g) {
		mov.onPaint(g);
		weapon.handlePaint(g);
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public final void onHitWall(final HitWallEvent e) {
		
	}	
	
	private double limit(final double low, final double mid, final double high) {
		return Math.min(high,Math.max(low,mid));
	}
	
}
