package kvk.Bots;
import kvk.ExtendedRobot;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.Manager;
import kvk.Utils.Point;
import robocode.*;

/**
 * BotManager : gre les robots de l'arne
 *
 * @author     Ssin.le.Terrible
 * @created    12 janvier 2004
 */
public class BotManager extends Manager {
	//{{{ *** Variables de BotManager
	Bot[]  bots;                                                                   // tableau avec tous les robots
	int    nbConnu;                                                                // nombre de robots connus
	int    nbTotal;                                                                // nombre total de robots dans l'arne
	//}}}

	//{{{ *** Constructor

	public BotManager(ExtendedRobot er) {
		super(er);
		nbTotal = myBot.getOthers();
		bots = new Bot[nbTotal];
		nbConnu = 0;
	}
	//}}}

	//{{{ ***************************** METHODES D'ACCES ***************************** //
	public Bot getBot(int index) {
		return bots[index];
	}

	public Bot getBot(String name) {
		for (int i = 0; i < nbConnu; i++) {
			if (bots[i].getName().equals(name)) {
				return bots[i];
			}
		}
		return null;
	}

	public int getSize() {
		return nbConnu;
	}
	// **************************************************************************** //}}}

	/**
	 *  Action  faire  chaque tour
	 */
	public void action() {
		if (!myBot.isOvO()) {
			for (int i = 0; i < nbConnu; i++) {
				bots[i].updateEachTurn();
			}
		}
	}

	/**
	 * Ecrit tous les robots dans les fichiers
	 */
	private void botMapEcriture() {
		for (int i = 0; i < nbConnu; i++) {
			bots[i].botEcriture();
		}
	}

	/**
	 * En fin de bataille, crit les fichiers
	 */
	private void gameOver() {
		if (myBot.getRoundNum() == myBot.getNumRounds() - 1) {
		}
	}

	/**
	 * Mise  jour lorsque je touche
	 *
	 * @param  e  Description of the Parameter
	 */
	public void onBulletHit(BulletHitEvent e) {
		Bot  b  = getBot(e.getName());
		if (b != null) {
			b.setEnergy(e.getEnergy());
		}
	}

	/**
	 * Action en cas de mort
	 *
	 * @param  e  Description of the Parameter
	 */
	public void onDeath(DeathEvent e) {
		gameOver();
	}

	/**
	 * Action lors de la mort d'un robot
	 *
	 * @param  e  RobotdeatEvent
	 */
	public void onRobotDeath(RobotDeathEvent e) {
		updateDead(e.getName());
	}

	/**
	 *  Action lorsque je vois un robot
	 *
	 * @param  e  Description of the Parameter
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		String  name  = e.getName();
		int     i;

		// Recherche si le robot est dj connu
		for (i = 0; i < nbConnu; i++) {
			if (bots[i].getName().equals(name)) {
				bots[i].update(e.getBearingRadians(), e.getHeadingRadians(), e.getVelocity(), e.getDistance(), e.getEnergy(), e.getTime());
				bots[i].testWave(myBot.getTime());
				return;
			}
		}
		// Le robot est inconnu
		Bot     b     = new Bot(myBot, name);
		bots[i] = b;
		bots[i].update(e.getBearing(), e.getHeading(), e.getVelocity(), e.getDistance(), e.getEnergy(), e.getTime());
		bots[i].testWave(myBot.getTime());
		myBot.print(true, "Bienvenue " + name);
		nbConnu++;
	}

	/**
	 * Action en cas de victoire
	 *
	 * @param  e  Description of the Parameter
	 */
	public void onWin(WinEvent e) {
		gameOver();
	}

	/**
	 *  Rinitialise la carte pour le 2me tour et les suivants
	 */
	public void reinitialise() {
		for (int i = 0; i < nbConnu; i++) {
			bots[i].reinitialise();
		}
	}

	/**
	 *  Dclaration d'un robot mort
	 *
	 * @param  name  Description of the Parameter
	 */
	public void updateDead(String name) {
		Bot  b  = getBot(name);
		if (b != null) {
			b.updateDead();
		}
	}

	//**********************************************************//
	/**
	 *  Calcul de l'AntiGravit des bots suivant cx.mini.Nimrod
	 *
	 * @return    The nimrodForce value
	 */
	public Point getNimrodForce() {
		Bot    currentBot;
		Point  force       = new Point();
		for (int i = 0; i < nbConnu; i++) {
			currentBot = bots[i];
			if (!currentBot.isDead()) {
				force = Fct.calcXY(force, currentBot.getAbsBearing(), -1d / currentBot.getDistance());
			}
		}
		return force;
	}
}

