package bayen;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.util.Utils;
/**

 * Uba - a robot by Bayen

 */
public class UbaMicro extends AdvancedRobot
{
      static double FORWARD = 1;//choose forward or backward
      static String targeting = "linear";//the targeting type
      int misscount = 0; //# of times I missed
      /**

       * CrazyTracker2 and Uba's run method

       */
      public void run() {
setColors(Color.yellow,Color.blue,Color.yellow);
setAdjustGunForRobotTurn(true);//allow gun and radar
setAdjustRadarForGunTurn(true);//free movement
while(true)                              //keep scanning
turnRadarRight(Double.POSITIVE_INFINITY);//for enemies
      }
      /**

       * onScannedRobot:  We have a target.  Go get it.

       */
      public void onScannedRobot(ScannedRobotEvent e) {
//**One-on-One movement (zigsags)**\\
if(getOthers() == 1){
if (getDistanceRemaining() == 0) {FORWARD =-FORWARD;
setAhead(185 * FORWARD);}
setTurnRightRadians(e.getBearingRadians()
+Math.PI/2-0.5236*FORWARD
*(e.getDistance()>200?1:-1));}
//**Melee Movement--Random!**\\
if(getOthers() > 1){
if(getDistanceRemaining() == 0){setAhead(100*FORWARD);
setTurnRightRadians(2* Math.random()*FORWARD);
FORWARD = -FORWARD;}}
//**LINEAR TARGETING**\\
if(targeting == "linear"){
double bulletPower = Math.min(3.0,getEnergy());
double myX = getX();double myY = getY();
double absoluteBearing =
getHeadingRadians() + e.getBearingRadians();
double enemyX = getX() 
+ e.getDistance() * Math.sin(absoluteBearing);
double enemyY = getY() 
+ e.getDistance() * Math.cos(absoluteBearing);
double enemyHeading = e.getHeadingRadians();
double enemyVelocity = e.getVelocity();
double deltaTime = 0;
double battleFieldHeight=
getBattleFieldHeight(),battleFieldWidth=
getBattleFieldWidth();
double predictedX = enemyX, predictedY = enemyY;
while((++deltaTime)*(20.0
- 3.0*bulletPower)
<Point2D.Double.distance(myX, myY, predictedX, predictedY)){
            predictedX += Math.sin(enemyHeading) 
            * enemyVelocity;  
            predictedY += Math.cos(enemyHeading) 
            * enemyVelocity;
                  if(   predictedX < 18.0 
                        || predictedY < 18.0
                        || predictedX > battleFieldWidth - 18.0
                        || predictedY > battleFieldHeight - 18.0){
predictedX = 
Math.min(Math.max(18.0, predictedX), battleFieldWidth 
- 18.0);    
predictedY = 
Math.min(Math.max(18.0, predictedY), battleFieldHeight
- 18.0);break;}}
double theta =
Utils.normalAbsoluteAngle(Math.atan2(predictedX
- getX(), predictedY - getY()));
setTurnRadarRightRadians
(Utils.normalRelativeAngle(absoluteBearing 
- getRadarHeadingRadians()));
setTurnGunRightRadians(Utils.normalRelativeAngle(theta
- getGunHeadingRadians()));
            fire(3);}
//**Head on Targeting**\\
      if(targeting=="hot"){
            double absoluteBearing = getHeadingRadians()
            + e.getBearingRadians();
            double bearingFromGun =
            Utils.normalRelativeAngle(absoluteBearing
            - getGunHeadingRadians());
            double bearingFromRadar =
            Utils.normalRelativeAngle(absoluteBearing
            - getRadarHeadingRadians());
            if (Math.abs(bearingFromGun) <= 3) {
                  setTurnRadarRightRadians(bearingFromRadar);
                  turnGunRightRadians(bearingFromGun);
                  if (getGunHeat() == 0)
                        fire (Math.min(3 -
                        Math.abs(bearingFromGun),getEnergy()
                        - .1));}
            else {
                  setTurnRadarRightRadians(bearingFromRadar);
                  turnGunRightRadians(bearingFromGun);}
            if (bearingFromGun == 0)
                  scan();}}
      /**

       * onHitByBullet: Randomize my movement

       */
      public void onHitByBullet(HitByBulletEvent e) {
            turnRadarRight(e.getBearing());
}

      public void onHitRobot(HitRobotEvent e) {
            setTurnRight(e.getBearing());
            setBack(100);
}

      public void onHitWall(HitWallEvent e) {
            setTurnRight(e.getBearing());
            setBack(100);
}
      /**

       * onBulletMissed: Tally up misses

       */
      public void onBulletMissed(BulletMissedEvent e) {
            misscount++;
            if(misscount > 3){
                  if(getOthers() > 1){
                  turnRadarRight(360);
                  misscount = 0;
            }
            }
            if(misscount > 5){
                  misscount = 0;
                  if(targeting=="linear")
                  targeting = "hot";
                  if(targeting=="hot")
                  targeting = "linear";
                  out.println("Changed Targeting");
            }

}}
