package ag.movement;

import ag.battledata.DataVector;;

/**
 * A point representing a moving gravity point.
 * @author Andree Grosse
 */
public class GravPoint extends DataVector implements GravObject {

	protected double mForce, mExp, mMaxDist;
	
	/**
	 * Constructor.
	 * @param position Position of the point
	 * @param force The  force this point emits. At distance 'force',
	 * the force on a point is 1
	 * @param exp The exponent for the force calculation
	 * @param maxDist Maximum distance for force
	 */
	public GravPoint(DataVector position, double force, double exp, double maxDist) {
		super(position);
		mForce = Math.signum(force) * Math.pow(Math.abs(force), exp);
		mExp = exp;
		mMaxDist = maxDist;
	}
	
	/**
	 * Calculates the forces emitted on a point.
	 * @param point the point for which to calculate the force
	 * @return a DataVector representing the force
	 */
	public DataVector getForceOn(DataVector point){
		DataVector diff = point.minus(this);
		//System.out.println("POINT");
		//point.print();
		// gravity formula
		return calcForce(diff);
	}
	
	/**
	 * Sets the position
	 * @param dir new position
	 */
	public void setPosition(DataVector pos){
		x = pos.x;
		y = pos.y;
	}
	
	/**
	 * Sets the force
	 * @param force new force
	 */
	public void setForce(double force){
		mForce = Math.signum(force) * Math.pow(Math.abs(force), mExp);;
	}
	
	/**
	 * Returns
	 */
	public double getForce(){
		return Math.signum(mForce) * Math.pow(Math.abs(mForce), 1/mExp);
	}
	
	/**
	 * Applies force formula on a vector
	 * @param dir the simple difference vector
	 * @return a DataVector representing the force 
	 */
	private DataVector calcForce(DataVector dir){
		double len = dir.normalize();

		if(len > mMaxDist){
			return new DataVector(.0, .0);
		}
		else if(len < 0.1)
			len = 0.1;
		len = Math.pow(len, mExp);
		return dir.multiple(mForce / len);
	}
	
}
