
package sgp;
import robocode.*;

public class ShiningBeetle extends AdvancedRobot
{
	private double radarTurnAngleRadians = Math.PI;
	private double gunTurnAngleRadians = 0.0;
	private long lastScannedTime = -1;
	private double hVelocity = 0.0;
//	static private double firePower = 2.0;

	/**
	 * The behaviour
	 */
	public void run()
	{
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		while (true)
		{							
			if (getDistanceRemaining() == 0)
			{	
				setAhead((Math.round(Math.random()) * 2 - 1) * 160);
			}
			setTurnRightRadians(1000);


			setTurnGunRightRadians(gunTurnAngleRadians);
			setTurnRadarRightRadians(radarTurnAngleRadians);
			radarTurnAngleRadians = Math.PI;

			fire(2.0/*firePower*/);
		}
	}

	public void onScannedRobot(ScannedRobotEvent event) 
	{
		lastScannedTime = getTime();
		
		double abs_bearing = event.getBearingRadians() + getHeadingRadians();
		double relativeHeading = event.getHeadingRadians() - abs_bearing;
		
		//firePower = 300.0 / event.getDistance(); //full strength up to 100 away
		
		hVelocity = (1.0/60.0) * event.getVelocity() * Math.sin(relativeHeading) + (59.0/60.0) * hVelocity;

		//track target
		gunTurnAngleRadians = Math.asin(Math.sin(abs_bearing - getGunHeadingRadians() + Math.asin(hVelocity / (20-3*2/*firePower*/))));

		//move radar in the correct direction
		radarTurnAngleRadians = Math.asin(Math.sin(hVelocity / event.getDistance() + abs_bearing - getRadarHeadingRadians()));
	}
}
