/**************************************************************************************
*  Robot:   mini.TimVA
*  Author:  Liuyang
*  Create:  2003.03.26
*  Tips:    ..oOOo..oOOo..
*  ....................................................................................
*  v0.31 - 2003.03.26 - 968 - Fix moving and shoot param,add LEN,WALL variable.
*  v0.32 - 2003.04.25 - 983 - Fix moving condition.
*  v0.33 - 2003.04.29 - 980 - Fix moving condition and param.
*  v0.41 - 2003.07.30 - 1208 - VirtualBullet Attack.
*  v0.42 - 2003.08.15 - 1128+156 - Usage double[][][][] store virtual bullet info.
*  v0.43 - 2003.09.01 - 933+177  - Remove read write object.Change movement.
**************************************************************************************/
package timmit.mini;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

public class TimVA extends AdvancedRobot{
	
	static int dLength = 10,vLength = 17,aLength = 3,vbHalfLength = 32;
	static long moveTime;
	static double epVelocity;
	static Vector v = new Vector();
	static double[][][][] vData = new double[dLength][vLength][aLength][vbHalfLength*2+1];
	
	public void run(){
		setColors(Color.green,Color.green,Color.white);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		do{
			turnRadarRightRadians(1);
		}while(true);
	}
	
	/**
	 *  scanned emeny event.
	 */
	public void onScannedRobot(ScannedRobotEvent e){
		long cTime = getTime();
		double cx = getX(),cy = getY(),distance = e.getDistance();
		double absBearing = e.getBearingRadians() + getHeadingRadians(),eHead = e.getHeadingRadians() - absBearing;
		//double firepower = minmaxOf(260/Math.max(distance,120)+0.9,0.1,3);
		double firepower = minmaxOf(Math.min(getEnergy()/5,e.getEnergy()/4),0.1,3);
		Point2D.Double enemyPoint = this.getPoint(cx,cy,absBearing,distance);
		int dIndex = Math.min((int)(distance/100),9);
		int aIndex = (int)minmaxOf(e.getVelocity() - epVelocity,-1,1) + 1,vbIndex = vbHalfLength;
		epVelocity = e.getVelocity();
		int vIndex = (int)epVelocity + 8;
		
		//GUN TURN METHOD//
		for(Iterator iter = v.iterator();iter.hasNext();){
			VirtualBullet vb = (VirtualBullet)iter.next();
			vData[vb.dIndex][vb.vIndex][vb.aIndex][vb.vbIndex] *= 0.99;
			if(vb.isHit(enemyPoint,cTime)){
				vData[vb.dIndex][vb.vIndex][vb.aIndex][vb.vbIndex] += 0.01;
				iter.remove();
			}else if(vb.isOut(enemyPoint,cTime)){
				iter.remove();
			}
			
			//SEARCH BEST VBINDEX//
			if(vData[dIndex][vIndex][vb.aIndex][vb.vbIndex] > vData[dIndex][vIndex][vb.aIndex][vbIndex]){
				vbIndex = vb.vbIndex;
			}
		}
		//double linear = Math.asin(velocity * Math.sin(e.getHeadingRadians() - absBearing)/(20-3*firepower));
		setTurnGunRightRadians(relativeOf(absBearing - getGunHeadingRadians() + linearOf(vbIndex,eHead,firepower)));
		
		//FIRE ENEMY//
		if(getGunHeat()==0 && (getEnergy()-firepower)>0.2){
			setFireBullet(firepower);
		}
		
		//ROBOT MOVEMENT METHOD//
		if(--moveTime <= 0){
			moveTime = (long)(Math.random() * distance / 13);
			double nextX,nextY,bestAngle = 0,turn = 0,dist = 0;
			for(int vi=0,j=vbHalfLength*2+1;vi<j;vi++){
				nextX = Math.random() * (this.getBattleFieldWidth() - 50) + 25;
				nextY = Math.random() * (this.getBattleFieldHeight() - 50) + 25;
				if(bestAngle < (bestAngle = Math.max(Math.abs(Math.tan(angleOf(cx,cy,nextX,nextY) - absBearing)),Math.PI/3))){
					turn = relativeOf(angleOf(cx,cy,nextX,nextY) - getHeadingRadians());
					dist = Point2D.Double.distance(cx,cy,nextX,nextY);
				}
				//FIRE VIRTUAL BULLET//
				v.add(new VirtualBullet(dIndex,vIndex,aIndex,vi,cTime,firepower,absBearing+linearOf(vi,eHead,firepower),cx,cy));
			}
			if(Math.abs(turn) > Math.PI/2){
				turn += Math.PI;
				dist = -dist;
			}
			setTurnRightRadians(relativeOf(turn));
			setAhead(dist);
		}else{
			if(Math.abs(getDistanceRemaining())<=1){
				setTurnRightRadians(relativeOf(absBearing + Math.PI/2 * rDirect(0.5) - getHeadingRadians()));
				setAhead(16 * rDirect(0.5));
			}
		}
		
		//RADAR TURN//
		setTurnRadarRightRadians(relativeOf(absBearing - getRadarHeadingRadians()) * 1.5);
		scan();
	}
	
	static int rDirect(double rator){return Math.random() > rator ? 1 : -1;}
	
	static double relativeOf(double r){return Math.atan2(Math.sin(r),Math.cos(r));}
	
	static double randomOf(double min,double max){return new Random().nextDouble()*(max-min)+min;}
	
	static double minmaxOf(double value,double min,double max){return Math.min(Math.max(value,min),max);}
	
	//static double distanceOf(double x1,double y1,double x2,double y2){return Point2D.Double.distance(x1,y1,x2,y2);}
	
	static double angleOf(double x1,double y1,double x2,double y2){return Math.atan2(x2-x1,y2-y1);}
	
	//param ehead  = e.getHeadingRadians() - absBearingRadians//
	static double linearOf(int vi,double ehead,double power){
		return Math.asin((vi-vbHalfLength)*(8/(double)vbHalfLength) * Math.sin(ehead)/(20-3*power));
	}
	
	static Point2D.Double getPoint(double originX,double originY,double absBearing,double distance){
		return new Point2D.Double(originX + Math.sin(absBearing) * distance,originY + Math.cos(absBearing) * distance);
	}
}

/**
 *  Virtual Bullet Class. codesize = 177
 */
class VirtualBullet{
	
	int dIndex,vIndex,aIndex,vbIndex;
	long start;
	double ox,oy,power,absBearing;
	
	VirtualBullet(int dIndex,int vIndex,int aIndex,int vbIndex,long start,double power,double absBearing,double ox,double oy){
		this.dIndex = dIndex;
		this.vIndex = vIndex;
		this.aIndex = aIndex;
		this.vbIndex = vbIndex;
		this.start = start;
		this.power = power;
		this.absBearing = absBearing;
		this.ox = ox;
		this.oy = oy;
	}
	
	boolean isHit(Point2D.Double enemyPoint,long now){
		return getPoint(now).distance(enemyPoint) < 30 ? true : false;
	}
	
	/**
	 *  return true if bullet will never hit enemy.
	 */
	boolean isOut(Point2D.Double enemyPoint,long now){
		for(double t=0.1;t<=1;t+=0.1){
			if((getPoint(now).distance(ox,oy) - enemyPoint.distance(ox,oy)) > 30) return true;
		}
		return false;
	}
	
	Point2D.Double getPoint(long now){
		return TimVA.getPoint(ox,oy,absBearing,(now - start) * (20 - 3 * power));
	}
}