package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;

public class VengenceTargetChooser extends TargetChooser implements java.io.Serializable
{
	private String[] robotnames;
	private int[] vengenceFactors;
	private String lastShooter;

	public VengenceTargetChooser(AdvancedRobot robot, EnemyManager manager)
	{
		super(robot, manager);
		robotnames = new String[robot.getOthers()];
		lastShooter = "";
		vengenceFactors = new int[robotnames.length];
	}

	public void onEvent(Event e)
	{
		if (e instanceof HitRobotEvent)
		{
			String name = ((HitRobotEvent)e).getName();
			if (!((HitRobotEvent)e).isMyFault())
				logFault(name, 2);
		}
		else if (e instanceof HitByBulletEvent)
		{
			HitByBulletEvent ev = (HitByBulletEvent)e;
			String name = ev.getName();
			double power = ev.getPower();
			double damage = 4*power;
			if (power > 1)
				damage += 2*(power-1);
			logFault(name, (int)damage);
			lastShooter = name;
		}
		else if (e instanceof DeathEvent)
			logFault(lastShooter, 50);

	}

	private void logFault(String name, int fault)
	{
		for (int i=0; i<robotnames.length; i++)
			if (robotnames[i] == null)
			{
				robotnames[i] = name;
				vengenceFactors[i] = fault;
			}
			else if (robotnames[i].equals(name))
			{
				vengenceFactors[i] += fault;
				break;
			}
	}

	public EnemyState chooseTarget()
	{
		EnemyState closest = null;
		for (int i=0; i<manager.countEnemies(); i++)
		{
			EnemyState enemy = manager.getEnemyAt(i);
			if (enemy == null || enemy.isDead() || enemy.getTimeElapsed(robot.getTime()) > 20 || enemy.getTimeElapsed(robot.getTime()) < 0)
				continue;
			if (closest == null || closest.isDead() || closest.getTimeElapsed(robot.getTime()) > 20 || closest.getTimeElapsed(robot.getTime()) < 0)
				closest = enemy;
			else if (getVengenceFactor(closest.getName()) < getVengenceFactor(enemy.getName()))
				closest = enemy;
		}
		return closest;
	}

	private int getVengenceFactor(String name)
	{
		for (int i=0; i<robotnames.length; i++)
			if (robotnames[i] == null)
				return 0;
			else if (robotnames[i].equals(name))
				return vengenceFactors[i];
		return 0;
	}
}
