package trab.crusader;

import trab.intel.IntelligenceManager;
import trab.utils.Utils;
import java.awt.geom.*;
import trab.utils.Wave;

import java.util.ArrayList;

public class MovementManager {
  
  /*
  Rectangle2D.Double battleField;
  final int WALL_MARGIN = 18;
  */
  
  IntelligenceManager intel;
  
  public MovementManager( IntelligenceManager intel_ ) {
    intel = intel_;  
  }
  
  public ArrayList getMaxMovePathUntilWaveHits( Point2D robotPos, double heading, double velocity, double orbitDirection, MovementWave wave ) {
    
    MoveStat currentMove = new MoveStat( robotPos, heading, velocity );
    Point2D gotoPoint;
    
    ArrayList path = new ArrayList();
    
    int runs = 0;
    while ( !wave.hasHit( currentMove.position ) ) {
    
      gotoPoint = getGotoPoint( currentMove.position, wave.getSource(), orbitDirection );  
      currentMove = getNextMoveStat( currentMove, gotoPoint );
    
      path.add( (Point2D)currentMove.position.clone() );
    
      wave.advance(1);  
      runs++;
    }
    
    wave.advance( -runs );
    
    return path;
  }
  
  private MoveStat getNextMoveStat( MoveStat move, Point2D gotoPoint ) { // accel = 1, stop = 0
    double a = goToAngle( move.position, gotoPoint, move.heading );  
    double aHead = goToDistance( move.position, gotoPoint, move.heading );  
    
    // Heading, then acceleration, then velocity, then x/y.
    double newHeading = move.heading + a; 
    double newVelocity;
    
    // think someting is wrong here especially with decel part
    
    if ( Utils.sign(aHead) == Utils.sign(move.velocity) )
      newVelocity = move.velocity + 1 * Utils.sign(aHead); // accel
    else
      newVelocity = move.velocity + 2 * Utils.sign(aHead); // decel
    
    newVelocity = Utils.scale( -8, newVelocity, 8 );
    
    
    MoveStat newMove = new MoveStat();
    newMove.velocity = newVelocity;
    newMove.heading = newHeading;
    newMove.position.setLocation( move.position.getX() + Math.sin(newMove.heading)*newMove.velocity, 
                                  move.position.getY() + Math.cos(newMove.heading)*newMove.velocity );
    
    return newMove;
  }
  
  
  
  public Point2D getGotoPoint( Point2D myPos, Point2D orbitPoint, double orbitDir ) {
    
    double absoluteBearing = Utils.absoluteBearing( myPos, orbitPoint );
    double a = absoluteBearing + Math.PI/2 * orbitDir;
    
    double dist = myPos.distance( intel.getEnemyPosition(0) )-38;// * orbitDir;
    
    double aInc = Math.PI/2 * orbitDir * (dist < 400 ? Math.pow((400-dist)/400, 1 ) : 0 );
    a += Math.min( aInc, Math.PI/2 );
    
    //a+=0.2;
    //return wallSmooth( new Point2D.Double( myPos.getX() + Math.sin(a) * 135 * orbitDir, myPos.getY() + Math.cos(a) * 135 * orbitDir ), myPos, orbitDir );
    return wallSmooth( new Point2D.Double( myPos.getX() + Math.sin(a) * 135, myPos.getY() + Math.cos(a) * 135 ), myPos, orbitDir );
  }
  
  
  private double goToAngle( Point2D myPos, Point2D gotoPoint, double heading ) {
    double angle = Utils.normalRelativeAngle( Utils.absoluteBearing( myPos, gotoPoint ) - heading );
    return Math.atan(Math.tan(angle));
  }
  
  private double goToDistance( Point2D myPos, Point2D gotoPoint, double heading ) {
    double angle = Utils.normalRelativeAngle( Utils.absoluteBearing( myPos, gotoPoint ) - heading );
    double turnAngle = Math.atan(Math.tan(angle));
    
    double ahead = myPos.distance(gotoPoint) * (angle == turnAngle ? 1 : -1);
    return ahead * Math.pow(Math.cos(turnAngle),8);
  }
  
  
  
  private Point2D wallSmooth( Point2D gotoPoint, Point2D orign, double orbitDir ) {
    /*
    double a = Utils.absoluteBearing( orign, gotoPoint );
    double len = orign.distance( gotoPoint );
    
    while ( !intel.isOnBattleField( gotoPoint ) ) {
      a -= Math.PI/180D * orbitDir;
      gotoPoint.setLocation( orign.getX() + Math.sin(a) * len, orign.getX() + Math.cos(a) * len );
    }
    
    return gotoPoint;
    */
    int tries = 0;
    while( !intel.isOnBattleField( gotoPoint ) && tries++ < 90 ) {
      gotoPoint = Utils.project( orign, Utils.absoluteBearing( orign, gotoPoint ) - (Math.PI * 8 / 180)*orbitDir, 135D );
    }
    return gotoPoint;
  }
  
  private class MoveStat {
    Point2D position;
    double heading;
    double velocity;
  
    public MoveStat() {
      position = new Point2D.Double();
      heading = velocity = 0;
    }
    
    public MoveStat( Point2D p, double h, double v ) {
      position = new Point2D.Double( p.getX(), p.getY() );
      //position.setLocation( p.getX(), p.getY() );
      heading = h;
      velocity = v;
    }
  
  }
  
}