package jam.micro;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;
import java.util.*;
import java.io.*;

/*
	RaikoMicro 1.3 by Jamougha.  
						
	Movement from Raiko 0.3, with simple guess factor targeting.
*/

public class RaikoMicro extends AdvancedRobot {

	static final double BEST_DISTANCE = 525;
	static boolean flat = false;
	static double circleDir = 1, enemyFirePower, enemyEnergy, enemyDistance, lastVChangeTime;//, lastReverseTime, hitRate = .94;
	static int enemyVelocity;
	static Point2D.Double enemyLocation;
	static final int GF_ZERO = 15;
	static final int GF_ONE = 30;
	static int[][][][][] guessFactors = new int[6][3][2][8][GF_ONE+1]; 
	
    public void run() {
		//this is always a bad sign...
        //setColors(Color.red, Color.white, Color.white);

		//Possibly you were right PEZ :-)
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY); 
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
	
	
		/*-------- setup data -----*/
		
    	Point2D.Double robotLocation = new Point2D.Double(getX(), getY());
		double theta;
        double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
		enemyLocation = projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
		
        if ((enemyEnergy -= e.getEnergy()) >= 0.1 && enemyEnergy <= 3.0) 
            enemyFirePower = enemyEnergy;
		
        enemyEnergy = e.getEnergy();

		/* ---- Movement ---- */
		
		Point2D.Double newDestination;
		
		double distDelta = 0.02 + Math.PI/2 + (enemyDistance > BEST_DISTANCE ? -.1 : .5);
		Rectangle2D.Double BF = new Rectangle2D.Double(18, 18, 764, 564);
		while (!BF.contains(newDestination = projectMotion(robotLocation, enemyAbsoluteBearing + circleDir*(distDelta-=0.02), 170)));

		theta = 0.5952*(20D - 3D*enemyFirePower)/enemyDistance;
		if ( (Math.random() > Math.pow(theta, theta) && flat) || distDelta < Math.PI/3.5)
			circleDir = -circleDir;
		
		theta = absoluteBearing(robotLocation, newDestination) - getHeadingRadians();
		setAhead(Math.cos(theta)*100);
		setTurnRightRadians(Math.tan(theta));
		

	/* ------------- Fire control ------- */
		
		MicroWave w;
		addCustomEvent(w = new MicroWave());
		w.bearingDirection = (theta = e.getVelocity())*Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) > 0 ? .7D/GF_ZERO : -.7D/GF_ZERO;
		
		int bestGF = Math.min(4, (int)(Math.sqrt(224D*lastVChangeTime++/enemyDistance)))+1;
		if (enemyVelocity > (enemyVelocity = (int)Math.abs(theta))){
			lastVChangeTime = 0;
			bestGF = 0;
		}
		w.firePosition = robotLocation;
		w.enemyAbsBearing = enemyAbsoluteBearing;
		w.waveGuessFactors = guessFactors[bestGF][enemyVelocity/3][BF.contains(projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection*GF_ZERO, enemyDistance)) ? 0 : 1][(int)enemyDistance/140];

		 
		
		bestGF = GF_ZERO;

		for (int gf = GF_ONE; gf >= 0 && e.getEnergy() > 0; gf--) //Saves one byte compared to going up, weird
			if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF])
				bestGF = gf;
			
		setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() + w.bearingDirection*(bestGF-GF_ZERO) ));

		if (getEnergy() > 2)
			setFire(2);
		
        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);

    }

    //public void onHitByBullet(HitByBulletEvent e) {
		/* 
			The infamous Axe-hack
	 		see: http://robowiki.net/?Musashi
			Implemented using Paul Evan's Rolling Average function
		*/
		//hitRate = hitRate*.875 + (getTime() - lastReverseTime < enemyDistance/e.getVelocity() ? .125 : 0);

	//}

	private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance){
		
		return new Point2D.Double(loc.x + distance*Math.sin(heading), loc.y + distance*Math.cos(heading));			
	}

    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

	public void onDeath(DeathEvent e){
		flat = flat || getRoundNum() < 5;	
	}
	
class MicroWave extends Condition
{
	
	Point2D.Double firePosition;
	int[] waveGuessFactors;
	double enemyAbsBearing, distance, bearingDirection;
	
	public boolean test(){

		if ((RaikoMicro.enemyLocation).distance(firePosition) <= (distance+=14D)){
			try {
				waveGuessFactors[(int)Math.round(Utils.normalRelativeAngle(absoluteBearing(firePosition, RaikoMicro.enemyLocation) - enemyAbsBearing)/bearingDirection + GF_ZERO)]++;
			} catch (ArrayIndexOutOfBoundsException e){}
			removeCustomEvent(this);
		}
		return false;
	}
}


}
