// <750 Byte Code
package fromHell;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class C4H10O extends AdvancedRobot {

    static double _lastEnemyEnergy;

    // for movement:
    private final static double PERPENDICULAR = Math.PI / 2.0;
    private final static double MOVE_DISTANCE = 55;
    private final static double WALL_STICK = 160.0;
    private final static double SMOOTH_INC = 0.07;

    private final static double CLOSE_FACTOR = 400;

    private final static double PREFERRED_RANGE = 500;
    private final static double RANDOM_FACTOR = 18;
    private final static double REVERSE_ANGLE = Math.PI / 4.0;

    private final static double REVERSE_CHANCE = 0.6;
    private final static double REVERSE_DIST_ADJ = 150;
    private final static double REVERSE_SUB = 0.02;

    private static double _direction = 1;
    private static double _enemyBulletVelocity = 15.0;

    private static boolean _flat = false;
    private static int _numerOfDeaths = 0;

    // for gun:
    static String enemyHistory = "2222222222222222222222222222222222222222222222222222222222222222222222222222222222222222";
    private final static int MATCH_LENGTH = 35;
    private final static int BEST_INDEX = 40;
    private final static int BINS = 80;
    private final static double CORRECTION_FACTOR = 0.0303378723;

    public void run() {
	setColors(Color.black, Color.darkGray, Color.lightGray, null, Color.black);
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	while (true) {
	    turnRadarRightRadians(1);
	}
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
	double tempDouble, enemyAbsoluteBearing, enemyDistance;

	// radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((tempDouble = enemyAbsoluteBearing = scannedRobotEvent.getBearingRadians() + (getHeadingRadians())) - getRadarHeadingRadians()));

	// movement
	double smoothedDirection;
	tempDouble = PERPENDICULAR - ((enemyDistance = scannedRobotEvent.getDistance()) - PREFERRED_RANGE) / CLOSE_FACTOR;
	while (!(new Rectangle2D.Double(18, 18, 764, 564)).contains(project((new Point2D.Double(getX(), getY())), smoothedDirection = enemyAbsoluteBearing + _direction * (tempDouble -= SMOOTH_INC), WALL_STICK)))
	    ;
	if ((_flat && (Math.random() < REVERSE_CHANCE * Math.sqrt(_enemyBulletVelocity / (enemyDistance + REVERSE_DIST_ADJ)) - REVERSE_SUB)) || tempDouble < REVERSE_ANGLE) {
	    _direction = -_direction;
	}
	setTurnRightRadians(Math.tan(smoothedDirection -= getHeadingRadians()));
	setMaxVelocity(7 + Math.random() * RANDOM_FACTOR);
	if (((tempDouble = _lastEnemyEnergy - scannedRobotEvent.getEnergy()) < 3.01 && tempDouble > 0.09) || _flat) {
	    setAhead((MOVE_DISTANCE - Rules.getBulletSpeed(tempDouble)) * Math.signum(Math.cos(smoothedDirection)));
	}

	// gun
	int matchLength = MATCH_LENGTH;
	int bestIndex = BEST_INDEX;
	int evaluatedPatterns;
	int predictedPosition;
	int matchedPosition;
	double bulletPower;
	enemyHistory = String.valueOf((char) (int) (scannedRobotEvent.getVelocity() * Math.sin(scannedRobotEvent.getHeadingRadians() - enemyAbsoluteBearing))).concat(enemyHistory);
	double bulletSpeed = Rules.getBulletSpeed(bulletPower = (enemyDistance < 100) ? 2.99 : Math.min(1.99, Math.min(_lastEnemyEnergy / 4, (_lastEnemyEnergy = scannedRobotEvent.getEnergy()) / 8)));

	while (matchLength-- > 1) {
	    matchedPosition = -1;
	    evaluatedPatterns = 0;

	    double[] angleValue = new double[BINS + 1];

	    while ((predictedPosition = matchedPosition = enemyHistory.indexOf(enemyHistory.substring(0, matchLength), Math.max(matchedPosition + 1, (int) (enemyDistance / (bulletSpeed - 4))))) >= 0) {
		evaluatedPatterns++;
		tempDouble = -bulletSpeed;
		double offset = 0.0;
		do
		    offset += (short) enemyHistory.charAt(--predictedPosition);
		while ((predictedPosition > 0) && ((tempDouble += bulletSpeed) * tempDouble < enemyDistance * enemyDistance + offset * offset));
		double bestValue = 0.0;
		int bin = BINS;
		do {
		    if ((angleValue[bin] += 1 / (1 + Math.abs(bin - (BINS / 2) + (int) (Math.atan(offset / enemyDistance) / CORRECTION_FACTOR)))) >= bestValue) {
			bestValue = angleValue[bin];
			bestIndex = bin;
		    }
		} while (bin-- > 0);
	    }

	    if (evaluatedPatterns > 5 + (int) Math.pow(enemyHistory.length(), 0.3)) {
		break;
	    }
	}
	setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing + ((BINS / 2) - bestIndex) * CORRECTION_FACTOR - getGunHeadingRadians()));
	setFire(bulletPower);
    }

    private static Point2D.Double project(Point2D.Double location, double angle, double distance) {
	return new Point2D.Double(location.x + distance * Math.sin(angle), location.y + distance * Math.cos(angle));
    }

    public void onDeath(DeathEvent deathEvent) {
	if ((getRoundNum() < 5) || (_numerOfDeaths++ >= 2))
	    _flat = true;
    }
}
