package shinh;

import robocode.*;

public class MoveRam extends Move {
	public String name() {
		return "ram";
	}

	public MoveRam() {
	}

	public void goRadian(double trans) {
		if (trans >= Const.PI_2) {
			ent.nativeSetBack(100);
			ent.setTurnRightRadians(trans-Const.PI);
		}
		else if (trans >= -Const.PI_2) {
			ent.nativeSetAhead(100);
			ent.setTurnRightRadians(trans);
		}
		else {
			ent.nativeSetBack(100);
			ent.setTurnRightRadians(Const.PI+trans);
		}
	}

	public void update() {
		if (ent.target == null) return;

		double r = Util.getNormalRadian(ent.target.radian -
										ent.getHeadingRadians());
		goRadian(r);
	}

}

