package shinh;

import robocode.*;

public class RadarOne implements Radar {
	private Entangled ent;

	public RadarOne() {
		ent = Entangled.me;

		ent.out.println("radar: for one");
	}

	public void update() {
		if (ent.target != null) {
			if (ent.target.turn + 30 > ent.getTime()) {
				ent.target.recalcRadian();
				double r = ent.getRadarHeadingRadians() - ent.target.radian;
				if (r > Const.PI) {
					ent.setTurnRadarRightRadians(100);
				}
				else if (r > 0) {
					ent.setTurnRadarLeftRadians(r + Const.PI_8);
				}
				else if (r > -Const.PI) {
					ent.setTurnRadarRightRadians(-r + Const.PI_8);
				}
				else {
					ent.setTurnRadarLeftRadians(100);
				}
			}
			else {
				ent.setTurnRadarLeftRadians(1000);
			}
		}
		else {
			ent.setTurnRadarLeftRadians(1000);
		}

	}

}

