package staticline.whiskey.utils;

public final class DistanceMeasures {
	/**
	 * found on http://en.literateprograms.org/Levenshtein_distance_(Java)
	 * 
	 * @param pattern1
	 * @param pattern2
	 * @return the Levenshtein distance
	 */
	public static final int getLevenshteinDist(String pattern1, String pattern2) {
		int[][] dp = new int[pattern1.length() + 1][pattern2.length() + 1];
		for (int i = 0; i < dp.length; i++) {
			for (int j = 0; j < dp[i].length; j++) {
				dp[i][j] = i == 0 ? j : j == 0 ? i : 0;
				if (i > 0 && j > 0) {
					if (pattern1.charAt(i - 1) == pattern2.charAt(j - 1))
						dp[i][j] = dp[i - 1][j - 1];
					else
						dp[i][j] = Math.min(dp[i][j - 1] + 1, Math.min(
								dp[i - 1][j - 1] + 1, dp[i - 1][j] + 1));
				}
			}
		}
		return dp[pattern1.length()][pattern2.length()];
	}
}
