/**
 *	Store Enemy inforamtion.
 */

package timmit;
import robocode.ScannedRobotEvent;

class Enemy{
	String name = "";
	double bearingRadians;
	double absoluteBearingRadians;
	double headingRadians;
	double[] headingRadiansChanged;
	double[] velocity;
	double distance;
	double epEnergy;
	double energy;
	double[] score = new double[3];			//[0]=linear [1]=nolinear [2]=fixlinear
	int match = 0;							//enemy score match.
	long scannedTime;
	int n = 0;								//enemy info index.
	int MAX;								//enemy info index lengh.
	
	Enemy(int infoLenght){
		MAX = infoLenght;
		headingRadiansChanged = new double[MAX];
		velocity = new double[MAX];
		this.reset();
	}//end construct
	
	protected void update(ScannedRobotEvent e,TimmiT bot){		//update enemy info when scanned.
		bearingRadians = e.getBearingRadians();
		absoluteBearingRadians = bot.getHeadingRadians() + e.getBearingRadians();
		headingRadiansChanged[n] = e.getHeadingRadians() - headingRadians;
		headingRadians = e.getHeadingRadians();
		velocity[n] = e.getVelocity();
		distance = e.getDistance();
		epEnergy = energy;
		energy = e.getEnergy();
		scannedTime = bot.getTime();
	}//end
	
	protected void reset(){
		distance = Double.POSITIVE_INFINITY;
		energy = 100;
	}//end
	
	protected void increaseIndex(){					//increase enemy info index.
		this.n = ++n % MAX;
	}//end
}