package kc.serpent.gun;
import kc.serpent.*;
import kc.serpent.utils.*;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.Color;

public class DuelGunDC {
	public static boolean isTC = false;
	public static boolean isMelee = false;
	AdvancedRobot robot;
    RobotPredictor robotPredictor; 
	public DuelGunDC(AdvancedRobot robot, RobotPredictor robotPredictor) {
		this.robot = robot;
		this.robotPredictor = robotPredictor;
	}

	static final double PI = Math.PI;
	static final double FULL_POWER_THRESHOLD = 133.0;
	static final double WALL_MARGIN = 17.999;
	static final double REAL_WAVE_WEIGHT = 2;
	static final int CLUSTER_SIZE = 100;
	static final int MAX_TESTING_NODES = 100000;
	static final int DIMENSIONS = 7;
	static final int RECORDED_POSITION_TICKS = 8;
	static double MAX_DISTANCE;
	static double NORMAL_BULLET_SPEED;
	static double NORMAL_ESCAPE_ANGLE;
	static double NORMAL_MAX_IMPACT_TIME;
	static final double[] VELOCITY_SLICES = new double[] {1.001, 3.001, 5.001, 7.001};
	static final double[] ACCEL_SLICES = new double[] {-0.01, 0.01};
	static final double[] WEIGHTS = new double[] {6, 4, 3, 5, 2, 1, 4};
		
	Point2D.Double myLocation;
	Point2D.Double enemyLocation;
	static Rectangle2D battleField;
	static int hits;
	static int shots;
	static int enemyIndex;
	double myEnergy;
	double enemyEnergy;
	double enemyDistance;
	double lastEnemyVelocity;
	int enemyClockDirection;
	long gameTime;
	long lastEnemyAccelerationTime;
	ArrayList enemyPositionHistory = new ArrayList();
	
	ArrayList waves = new ArrayList();
	static ArrayList[][] data = new ArrayList[VELOCITY_SLICES.length + 1][ACCEL_SLICES.length + 1];
	static ArrayList dataFast = new ArrayList();
	
	public void init() {
		if(robot.getRoundNum() == 0) {
			battleField = KUtils.makeField(robot.getBattleFieldWidth(), robot.getBattleFieldHeight(), WALL_MARGIN);
			MAX_DISTANCE = Math.max(robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
			NORMAL_BULLET_SPEED = isTC ? 11 : 14.3;
			NORMAL_ESCAPE_ANGLE = Math.asin(8 / NORMAL_BULLET_SPEED);
			NORMAL_MAX_IMPACT_TIME = MAX_DISTANCE / NORMAL_BULLET_SPEED;
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		gameTime = robot.getTime();
		myLocation = new Point2D.Double(robot.getX(), robot.getY());
		myEnergy = robot.getEnergy();
		enemyEnergy = e.getEnergy();
		enemyDistance = e.getDistance();
		double enemyVelocity = e.getVelocity();
		double enemyHeading = e.getHeadingRadians();
		double absoluteBearing = robot.getHeadingRadians() + e.getBearingRadians();
		enemyLocation = KUtils.projectMotion(myLocation, absoluteBearing, enemyDistance);
		if(enemyVelocity != 0){
			enemyClockDirection = KUtils.sign(Math.sin(enemyHeading - absoluteBearing) * enemyVelocity);
		}
		
		double bulletPower = findBulletPower();
		double bulletSpeed = KUtils.bulletSpeed(bulletPower);
		double bulletImpactTime = enemyDistance / bulletSpeed;
		
		double accel = Math.abs(enemyVelocity - lastEnemyVelocity) * (Math.abs(enemyVelocity) < Math.abs(lastEnemyVelocity) ? -1 : 1);
		lastEnemyVelocity = enemyVelocity;
		if(Math.abs(accel) > 0.01) {
			lastEnemyAccelerationTime = gameTime;
		}
		double accelTimer = ((double)(gameTime) - (double)(lastEnemyAccelerationTime)) / bulletImpactTime;
		
		enemyPositionHistory.add((Point2D.Double)(enemyLocation));
		if(enemyPositionHistory.size() > RECORDED_POSITION_TICKS + 1) {
			enemyPositionHistory.remove(0);
		}
		Point2D.Double latestPoint = enemyLocation;
		Point2D.Double earliestPoint = (Point2D.Double)(enemyPositionHistory.get(0));
		
		double wallAhead = NORMAL_ESCAPE_ANGLE * 1.5;
		double wallReverse = NORMAL_ESCAPE_ANGLE * 1.5;
		Point2D.Double enemyProjectedLocation;
		for(wallAhead = 0; wallAhead <= NORMAL_ESCAPE_ANGLE * 1.5; wallAhead += 0.002) {
			enemyProjectedLocation = KUtils.projectMotion(myLocation, absoluteBearing + (enemyClockDirection * wallAhead), enemyDistance);
			if(!battleField.contains(enemyProjectedLocation)) {
				break;
			}
		}
		for(wallReverse = 0; wallReverse <= NORMAL_ESCAPE_ANGLE * 1.5; wallReverse += 0.002){
			enemyProjectedLocation = KUtils.projectMotion(myLocation, absoluteBearing - (enemyClockDirection * wallReverse), enemyDistance);
			if(!battleField.contains(enemyProjectedLocation)) {
				break;
			}
		}
		wallAhead /= KUtils.maxEscapeAngle(bulletSpeed);
		wallReverse /= KUtils.maxEscapeAngle(bulletSpeed);
		
		double approachVelocity = Math.abs(Utils.normalRelativeAngle(enemyHeading - absoluteBearing + (enemyVelocity > 0 ? 0 : PI)));//enemyVelocity * -Math.cos(e.getHeadingRadians() - absoluteBearing);//
		
		robot.setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - robot.getGunHeadingRadians()));
		
		if(robot.getTime() < 3 / robot.getGunCoolingRate()) {
			waves.clear();
		}
		
		if(myEnergy - bulletPower < 0.01 && (!isTC || myEnergy <= 0)) {
			waves.clear();
			return;
		}
		if((myEnergy < 8 || isMelee)&&(myEnergy > enemyEnergy)&&(myEnergy - bulletPower < enemyEnergy)&&(!isTC)){
			waves.clear();
			return;
		}
		
		updateWaves();
		
		GunWave w = new GunWave();
		w.active = 0;
		w.source = myLocation;
		w.target = enemyLocation;
		w.speed = bulletSpeed;
		w.fireTime = gameTime;
		w.clockDirection = enemyClockDirection;
		w.velocity = Math.abs(enemyVelocity);
		w.accel = accel;

		w.waveNode = new Node(bulletImpactTime, accelTimer, latestPoint.distance(earliestPoint), wallAhead, wallReverse, approachVelocity, Math.abs(enemyVelocity));
		
		if(robot.getGunHeat()/robot.getGunCoolingRate() > 6) {
			waves.add(w);
			return;
		}
				
		ArrayList currentData = data[KUtils.index(w.velocity, VELOCITY_SLICES)][KUtils.index(w.accel, ACCEL_SLICES)];
		if(currentData == null) {
			data[KUtils.index(w.velocity, VELOCITY_SLICES)][KUtils.index(w.accel, ACCEL_SLICES)] = new ArrayList();
			waves.add(w);
			return;
		}
		
		if(currentData.size() == 0) {
			currentData = dataFast;
		}
		
		double[] deviationList = new double[CLUSTER_SIZE];
		double[] GFList = new double[CLUSTER_SIZE];
		double[] weightList = new double[CLUSTER_SIZE];
		int filledSlots = 0;
		for(int i = 0; i < CLUSTER_SIZE; i++) {
			deviationList[i] = Double.POSITIVE_INFINITY;
		}
		
		for(int testIndex = Math.max(currentData.size() - MAX_TESTING_NODES, 0); testIndex < currentData.size(); testIndex++) {
			Node test = (Node)(currentData.get(testIndex));
			double deviation = 0;
			boolean considered = true;
			for(int compareIndex = 0; compareIndex < DIMENSIONS; compareIndex++) {
				deviation += WEIGHTS[compareIndex] * KUtils.sqr(test.data[compareIndex] - w.waveNode.data[compareIndex]);
				if(deviation > deviationList[CLUSTER_SIZE - 1] || !isSimilar(deviation, deviationList[0])) {
					considered = false;
					break;
				}
			}
			
			if(considered) {
				for(int compare = 0; compare <= filledSlots; compare++) {
					if(deviation <= deviationList[compare]) {
						for(int refill = filledSlots; refill > compare; refill--) {
							deviationList[refill] = deviationList[refill - 1];
							GFList[refill] = GFList[refill - 1];
							weightList[refill] = weightList[refill - 1];
						}
						filledSlots = Math.min(filledSlots + 1, CLUSTER_SIZE - 1);
						deviationList[compare] = deviation;
						GFList[compare] = test.GF;
						weightList[compare] = test.weight;
						break;
					}
				}
			}
		}
		
		int firstDiscardedMatch = CLUSTER_SIZE;
		for(int i = 0; i < CLUSTER_SIZE; i++) {
			if(!isSimilar(deviationList[i], deviationList[0])) {
				firstDiscardedMatch = i;
				break;
			}
		}
		for(int i = 0; i < firstDiscardedMatch; i++) {
			deviationList[i] = Math.sqrt(deviationList[i]);
			weightList[i] /= deviationList[i];
		}
		
		double bestGF = GFList[0];
		double bestValue = Double.NEGATIVE_INFINITY;
		double windowSize = KUtils.windowFactor(15.0, enemyDistance, KUtils.maxEscapeAngle(bulletSpeed));

		double[][] comparisonValue = new double[firstDiscardedMatch][firstDiscardedMatch];
		for(int i = 0; i < firstDiscardedMatch; i++) {
			for(int ii = i; ii < firstDiscardedMatch; ii++) {
				double diff = Math.abs(GFList[i] - GFList[ii]);
				comparisonValue[i][ii] = comparisonValue[ii][i] = KUtils.thirtysecond(2.0 - diff) + (diff < windowSize ? 2000000000.0 : 0.0);
			}
		}
		
		for(int i = 0; i < firstDiscardedMatch; i++) {
			double value = 0;
			
			for(int ii = 0; ii < firstDiscardedMatch; ii++) {
				value += weightList[ii] * comparisonValue[i][ii];
			}
			
			if(value > bestValue) {
				bestValue = value;
				bestGF = GFList[i];
			}
		}
		
		double gunTurn = Utils.normalRelativeAngle((enemyClockDirection * bestGF * KUtils.maxEscapeAngle(bulletSpeed)) + absoluteBearing - robot.getGunHeadingRadians());
		robot.setTurnGunRightRadians(gunTurn);
		if(Math.abs(gunTurn) < PI/9 && robot.getGunHeat() == 0.0){
			w.active = 1;
			robot.setFire(bulletPower);
		}
		
		waves.add(w);
	}

	public static boolean isSimilar(double newValue, double oldValue) { 
		return (newValue - 5 <= oldValue || newValue < 10);
	}
	
	public double findBulletPower() {
		if(isTC){
			return Math.min(3, myEnergy);
		}
				
		double minimumKillPower = 0.1 + (enemyEnergy / 4);
		if(enemyEnergy >= 4.5) {
			minimumKillPower = 0.1 + ((enemyEnergy + 2) / 6);
		}
	
		double bulletPower = 1.9;
		if(!isMelee && (double)(hits)/(double)(shots) > 0.3 && robot.getRoundNum() > 3){ 
			bulletPower = 2.4;
		}
		if(isMelee && myEnergy < 35) {
			bulletPower = 1.4;
		}
		if(myEnergy < 20.0 && enemyEnergy > myEnergy) {
			bulletPower = 1.4;
		}
		if(myEnergy < 10.0  && enemyEnergy > 3) {
			bulletPower = 1.4;
		}
		if(myEnergy < 20.0  && enemyEnergy > 8) {
			bulletPower = 1.4;
		}
		if(myEnergy < 10.0  && enemyEnergy > myEnergy) {
			bulletPower = 0.9;
		}
		if(isMelee && myEnergy < 20) {
			bulletPower = 0.9;
		}
		if(enemyDistance < FULL_POWER_THRESHOLD) {
			bulletPower = 3.0;
		}
		bulletPower = Math.min(Math.min(bulletPower, (enemyDistance < FULL_POWER_THRESHOLD ? myEnergy : isMelee ? myEnergy / 6 : myEnergy / 3)), minimumKillPower);
		return Math.max(bulletPower, 0.1);
	}
	
	public void updateWaves() {
		int n = 0;
		while (n < waves.size()) {
			GunWave w = (GunWave)(waves.get(n++));
			w.distance = enemyLocation.distance(w.source);
			w.setRadius(gameTime);
			
			if(w.radius >= w.distance) {
				double GF = w.getGF(enemyLocation);
			
				ArrayList current = data[KUtils.index(w.velocity, VELOCITY_SLICES)][KUtils.index(w.accel, ACCEL_SLICES)];
				if(current == null) {
					current = data[KUtils.index(w.velocity, VELOCITY_SLICES)][KUtils.index(w.accel, ACCEL_SLICES)] = new ArrayList();
				}
				
				w.waveNode.GF = GF;
				w.waveNode.weight = w.active == 1 ? REAL_WAVE_WEIGHT : 1;
				current.add(w.waveNode);
				dataFast.add(w.waveNode);
				if(dataFast.size() > 100) {
					dataFast.remove(0);
				} 
			
				if(w.active == 1) {
					shots++;
				}
				waves.remove(w);
				n--;
			}
		}
	}

	public void onBulletHit(BulletHitEvent e) {
		hits++;
	}

	public void printStats() {
		System.out.println("my hit rate: " + hits + "/" + shots + " = " + (100*(float)(hits)/(float)(shots)) + "%");
	}

	public void setEnemyIndex(int i) {
		enemyIndex = i;
	}

	public class Node {
		public double[] data = new double[DIMENSIONS];
		public double GF;
		public double weight;
		
		public Node(double bulletImpactTime, double accelTimer, double distanceLastEight, double wallAhead, double wallReverse, double approachVelocity, double enemyVelocity) {
			data[0] = Math.min(bulletImpactTime / NORMAL_MAX_IMPACT_TIME, 1);
			data[1] = Math.min(accelTimer / 1.5, 1);
			data[2] = distanceLastEight / 64;
			data[3] = Math.min(wallAhead, 1.5) / 1.5;
			data[4] = Math.min(wallReverse, 1.5) / 1.5;
			data[5] = approachVelocity / PI;
			data[6] = enemyVelocity / 8;
		}
	}
	
	public class GunWave extends Wave {
		Node waveNode;
		double velocity;
		double accel;
	}
}