package dft.bin;

import java.util.ArrayList;

public class Log {

	private static ArrayList <ReducedState> states;
	
	public Log() {
		states = new ArrayList();
	}
	
	public static void update(State s) {		
		states.add(new ReducedState(s));
		if (states.size()>32) {
			states.remove(0);
		}
	}
	
	/**
	 * The parameter ticks should be negative; get(-2)
	 * returns the second to last saved state.
	 */
	public ReducedState get(int ticks) throws IllegalArgumentException {
		if (ticks >= 0)
			throw new IllegalArgumentException("Ticks must be negative.");
		if (states.size()+ticks>=0) {
			return states.get(states.size()+ticks);
		}
		else {
			throw new IllegalArgumentException("Not enough scans stored; " +
					ticks + " requested, " + (-states.size()) + " available.");
		}
	}
	
}
