package gadsky;

public final class Vector2D {
	public final static Vector2D EX = new Vector2D(1.0, 0.0);

	public final double x;
	public final double y;

	private double squaredLength() {
		return x * x + y * y;
	}

	public final double length() {
		return Math.sqrt(squaredLength());
	}

	private double dot(Vector2D v) {
		return x * v.x + y * v.y;
	}

	private double angle(Vector2D v) {
		double lengthProduct = Math.sqrt(squaredLength() * v.squaredLength());
		double cos = dot(v) / lengthProduct;
		cos = Math.max(-1.0, Math.min(cos, 1.0));
		return Math.acos(cos);
	}

	public final double signedAngle(Vector2D v) {
		double determinant = x * v.y - y * v.x;
		return determinant > 0.0 ? angle(v) : -angle(v);
	}

	public final Vector2D rotated(double angle) {
		return new Vector2D(
			x * Math.cos(angle) - y * Math.sin(angle),
			x * Math.sin(angle) + y * Math.cos(angle)
		);
	}

	public final Vector2D sub(Vector2D v) {
		return new Vector2D(x - v.x, y - v.y);
	}

	public final Vector2D add(Vector2D v) {
		return new Vector2D(x + v.x, y + v.y);
	}

	public final Vector2D mul(double a) {
		return new Vector2D(x * a, y * a);
	}

	public final Vector2D normalized() {
		double length = length();
		return new Vector2D(x / length, y / length);
	}

	public Vector2D(double x, double y) {
		this.x = x;
		this.y = y;
	}

	public final String toString() {
		return "(" + Double.toString(x) + ", " + Double.toString(y) + ")";
	}
}


